/*
 * Decompiled with CFR 0.152.
 */
package jeresources.compatibility.minecraft;

import java.util.HashMap;
import jeresources.api.conditionals.LightLevel;
import jeresources.compatibility.minecraft.MinecraftCompat;
import jeresources.entry.MobEntry;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.monster.BlazeEntity;
import net.minecraft.entity.monster.GuardianEntity;
import net.minecraft.entity.monster.MagmaCubeEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.PatrollerEntity;
import net.minecraft.entity.monster.PhantomEntity;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.entity.monster.VexEntity;
import net.minecraft.entity.monster.WitchEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.BatEntity;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.util.Tuple;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class MobCompat {
    private static World world = MinecraftCompat.getWorld();
    private final HashMap<Class, Tuple<Integer, Integer>> MOB_XP = new HashMap();
    private final HashMap<Class, LightLevel> LIGHT_LEVEL = new HashMap();
    private static MobCompat instance;

    public static MobCompat getInstance() {
        if (instance == null) {
            instance = new MobCompat();
            return instance;
        }
        return instance;
    }

    private MobCompat() {
        this.initMobXp();
        this.initLightLevel();
    }

    public void setLightLevel(MobEntry entry) {
        Class<?> entityClass = entry.getEntity().getClass();
        entry.setLightLevel(this.LIGHT_LEVEL.get(entityClass));
    }

    public void setExperience(MobEntry entry) {
        Class<?> entityClass = entry.getEntity().getClass();
        entry.setMinExp((Integer)this.MOB_XP.get(entityClass).func_76341_a());
        entry.setMaxExp((Integer)this.MOB_XP.get(entityClass).func_76340_b());
    }

    private void initMobXp() {
        for (EntityType entityType : ForgeRegistries.ENTITIES) {
            Entity entity = entityType.func_200721_a(world);
            if (!(entity instanceof MobEntity)) continue;
            Class<?> entityClass = entity.getClass();
            Tuple exp = entity instanceof AnimalEntity || entity instanceof WaterMobEntity ? new Tuple((Object)1, (Object)3) : (entity instanceof EnderDragonEntity ? new Tuple((Object)500, (Object)12000) : (entity instanceof SlimeEntity || entity instanceof MagmaCubeEntity ? new Tuple((Object)1, (Object)4) : new Tuple((Object)((MobEntity)entity).field_70728_aV, (Object)((MobEntity)entity).field_70728_aV)));
            this.MOB_XP.put(entityClass, (Tuple<Integer, Integer>)exp);
        }
    }

    private void initLightLevel() {
        for (EntityType entityType : ForgeRegistries.ENTITIES) {
            Entity entity = entityType.func_200721_a(world);
            if (!(entity instanceof MobEntity)) continue;
            Class<?> entityClass = entity.getClass();
            if (this.cannotSpawnNaturally(entity)) {
                this.LIGHT_LEVEL.put(entityClass, LightLevel.any);
                continue;
            }
            if (entity instanceof BlazeEntity) {
                this.LIGHT_LEVEL.put(entityClass, LightLevel.blaze);
                continue;
            }
            if (entity instanceof MonsterEntity || entity instanceof SlimeEntity || entity instanceof PhantomEntity) {
                this.LIGHT_LEVEL.put(entityClass, LightLevel.hostile);
                continue;
            }
            if (entity instanceof BatEntity) {
                this.LIGHT_LEVEL.put(entityClass, LightLevel.bat);
                continue;
            }
            this.LIGHT_LEVEL.put(entityClass, LightLevel.any);
        }
    }

    private boolean cannotSpawnNaturally(Entity entity) {
        return entity instanceof VexEntity || entity instanceof GuardianEntity || entity instanceof PatrollerEntity && !(entity instanceof WitchEntity);
    }
}

