/*
 * Decompiled with CFR 0.152.
 */
package jeresources.jei.plant;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import javax.annotation.Nonnull;
import jeresources.api.drop.PlantDrop;
import jeresources.compatibility.CompatBase;
import jeresources.entry.PlantEntry;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.ingredient.ITooltipCallback;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.extensions.IRecipeCategoryExtension;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;

public class PlantWrapper
implements IRecipeCategoryExtension,
ITooltipCallback<ItemStack> {
    private final PlantEntry plantEntry;
    private BlockState state;
    private Property<?> ageProperty;
    private long timer = -1L;
    private static final int TICKS = 500;

    public PlantWrapper(PlantEntry entry) {
        this.plantEntry = entry;
    }

    public void setIngredients(@Nonnull IIngredients ingredients) {
        ingredients.setInput(VanillaTypes.ITEM, (Object)this.plantEntry.getPlantItemStack());
        ingredients.setOutputs(VanillaTypes.ITEM, this.plantEntry.getLootDropStacks());
    }

    public void drawInfo(int recipeWidth, int recipeHeight, MatrixStack matrixStack, double mouseX, double mouseY) {
    }

    public void onTooltip(int slotIndex, boolean input, ItemStack ingredient, List<ITextComponent> tooltip) {
        if (!input) {
            tooltip.add((ITextComponent)this.getChanceString(ingredient));
        }
    }

    public float getChance(ItemStack itemStack) {
        PlantDrop drop = this.plantEntry.getDrop(itemStack);
        switch (drop.getDropKind()) {
            case chance: {
                return drop.getChance();
            }
            case weight: {
                return (float)drop.getWeight() / (float)this.plantEntry.getTotalWeight();
            }
            case minMax: {
                return Float.NaN;
            }
        }
        return 0.0f;
    }

    public int[] getMinMax(ItemStack itemStack) {
        PlantDrop drop = this.plantEntry.getDrop(itemStack);
        return new int[]{drop.getMinDrop(), drop.getMaxDrop()};
    }

    private StringTextComponent getChanceString(ItemStack itemStack) {
        String toPrint;
        float chance = this.getChance(itemStack);
        if (Float.isNaN(chance)) {
            int[] minMax = this.getMinMax(itemStack);
            toPrint = minMax[0] + (minMax[0] == minMax[1] ? "" : " - " + minMax[1]);
        } else {
            toPrint = String.format("%2.2f", Float.valueOf(chance * 100.0f)).replace(",", ".") + "%";
        }
        return new StringTextComponent(toPrint);
    }

    private BlockState getBlockState() {
        if (this.state == null) {
            this.state = this.plantEntry.getPlantState() != null ? this.plantEntry.getPlantState() : (this.plantEntry.getPlant() != null ? this.plantEntry.getPlant().getPlant((IBlockReader)CompatBase.getWorld(), BlockPos.field_177992_a) : Block.func_149634_a((Item)this.plantEntry.getPlantItemStack().func_77973_b()).func_176223_P());
            if (this.plantEntry.getAgeProperty() != null) {
                this.ageProperty = this.plantEntry.getAgeProperty();
            } else {
                this.state.func_235904_r_().stream().filter(p -> p.func_177701_a().equals("age")).findAny().ifPresent(property -> {
                    this.ageProperty = property;
                });
            }
        }
        if (this.ageProperty != null) {
            if (this.timer == -1L) {
                this.timer = System.currentTimeMillis() + 500L;
            } else if (System.currentTimeMillis() > this.timer) {
                this.state = (BlockState)this.state.func_235896_a_(this.ageProperty);
                this.timer = System.currentTimeMillis() + 500L;
            }
        }
        return this.state;
    }

    private BlockState getFarmland() {
        if (this.plantEntry.getSoil() != null) {
            return this.plantEntry.getSoil();
        }
        return Blocks.field_150458_ak.func_176223_P();
    }
}

