/*
 * Decompiled with CFR 0.152.
 */
package jeresources.profiling;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import jeresources.profiling.ProfiledDimensionData;
import jeresources.profiling.ProfilingBlacklist;
import jeresources.profiling.ProfilingTimer;
import jeresources.util.MapKeys;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ServerWorld;

public class ChunkProfiler
implements Runnable {
    private final ServerWorld world;
    private final ProfilingTimer timer;
    private final ProfilingBlacklist blacklist;
    private final List<Chunk> chunks;
    @Nonnull
    private final ProfiledDimensionData dimensionData;
    public static final int CHUNK_SIZE = 16;
    public static final int CHUNK_HEIGHT = 256;

    public ChunkProfiler(ServerWorld world, List<Chunk> chunks, @Nonnull ProfiledDimensionData dimensionData, ProfilingTimer timer, ProfilingBlacklist blacklist) {
        this.world = world;
        this.chunks = chunks;
        this.dimensionData = dimensionData;
        this.timer = timer;
        this.blacklist = blacklist;
    }

    @Override
    public void run() {
        this.chunks.forEach(this::profileChunk);
    }

    private void profileChunk(Chunk chunk) {
        RegistryKey worldRegistryKey = this.world.func_234923_W_();
        this.timer.startChunk((RegistryKey<World>)worldRegistryKey);
        HashMap<String, Object[]> temp = new HashMap<String, Object[]>();
        BlockPos.Mutable blockPos = new BlockPos.Mutable();
        BlockRayTraceResult rayTraceResult = new BlockRayTraceResult(new Vector3d(0.0, 0.0, 0.0), Direction.DOWN, (BlockPos)blockPos, true);
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        int maxY = chunk.func_76625_h();
        for (int y = 0; y < maxY; ++y) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    Object[] array;
                    blockPos.func_181079_c(x + chunk.func_76632_l().field_77276_a * 16, y, z + chunk.func_76632_l().field_77275_b * 16);
                    BlockState blockState = chunk.func_180495_p(new BlockPos(x, y, z));
                    if (this.blacklist.contains(blockState)) continue;
                    String key = MapKeys.getKey(blockState, (RayTraceResult)rayTraceResult, (World)this.world, (BlockPos)blockPos, (PlayerEntity)player);
                    if (!this.dimensionData.dropsMap.containsKey(key)) {
                        this.dimensionData.dropsMap.put(key, ChunkProfiler.getDrops(this.world, (BlockPos)blockPos, blockState));
                    }
                    if (!this.dimensionData.silkTouchMap.containsKey(key)) {
                        Block block = blockState.func_177230_c();
                        boolean canSilkTouch = block.canHarvestBlock(blockState, (IBlockReader)this.world, (BlockPos)blockPos, (PlayerEntity)player);
                        this.dimensionData.silkTouchMap.put(key, canSilkTouch);
                    }
                    if ((array = (Integer[])temp.get(key)) == null) {
                        array = new Integer[256];
                        Arrays.fill(array, (Object)0);
                    }
                    Object[] objectArray = array;
                    int n = y;
                    Object object = objectArray[n];
                    objectArray[n] = (Integer)objectArray[n] + 1;
                    Integer n2 = objectArray[n];
                    temp.put(key, array);
                }
            }
        }
        for (Map.Entry entry : temp.entrySet()) {
            Object[] array = (Integer[])this.dimensionData.distributionMap.get(entry.getKey());
            if (array == null) {
                array = new Integer[256];
                Arrays.fill(array, (Object)0);
            }
            for (int i = 0; i < 256; ++i) {
                Object[] objectArray = array;
                int n = i;
                Integer.valueOf((Integer)objectArray[n] + ((Integer[])entry.getValue())[i]);
            }
            this.dimensionData.distributionMap.put((String)entry.getKey(), (Integer[])array);
        }
        this.timer.endChunk((RegistryKey<World>)worldRegistryKey);
    }

    public static Map<String, Map<Integer, Float>> getDrops(ServerWorld world, BlockPos pos, BlockState state) {
        int totalTries = 10000;
        HashMap<String, Map<Integer, Float>> resultMap = new HashMap<String, Map<Integer, Float>>();
        for (int fortune = 0; fortune <= 3; ++fortune) {
            HashMap<String, Integer> dropsMap = new HashMap<String, Integer>();
            for (int i = 0; i < 10000; ++i) {
                NonNullList drops = NonNullList.func_191196_a();
                Block.func_220070_a((BlockState)state, (ServerWorld)world, (BlockPos)pos, null);
                for (ItemStack drop : drops) {
                    if (drop == null) continue;
                    String key = MapKeys.getKey(drop);
                    Integer count = (Integer)dropsMap.get(key);
                    count = count != null ? Integer.valueOf(count + drop.func_190916_E()) : Integer.valueOf(drop.func_190916_E());
                    dropsMap.put(key, count);
                }
            }
            for (Map.Entry dropEntry : dropsMap.entrySet()) {
                HashMap<Integer, Float> fortuneMap = (HashMap<Integer, Float>)resultMap.get(dropEntry.getKey());
                if (fortuneMap == null) {
                    fortuneMap = new HashMap<Integer, Float>();
                }
                fortuneMap.put(fortune, Float.valueOf((float)((Integer)dropEntry.getValue()).intValue() / 10000.0f));
                resultMap.put((String)dropEntry.getKey(), (Map<Integer, Float>)fortuneMap);
            }
        }
        return resultMap;
    }
}

