/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.block;

import java.util.Objects;
import java.util.Optional;
import mod.chiselsandbits.ChiselsAndBits;
import mod.chiselsandbits.api.block.IMultiStateBlock;
import mod.chiselsandbits.api.block.entity.IMultiStateBlockEntity;
import mod.chiselsandbits.api.chiseling.eligibility.IEligibilityManager;
import mod.chiselsandbits.api.exceptions.SpaceOccupiedException;
import mod.chiselsandbits.api.item.multistate.IMultiStateItemFactory;
import mod.chiselsandbits.api.multistate.StateEntrySize;
import mod.chiselsandbits.api.multistate.accessor.IAreaAccessor;
import mod.chiselsandbits.api.multistate.accessor.IStateEntryInfo;
import mod.chiselsandbits.api.multistate.mutator.batched.IBatchMutation;
import mod.chiselsandbits.api.multistate.snapshot.IMultiStateSnapshot;
import mod.chiselsandbits.api.util.ArrayUtils;
import mod.chiselsandbits.api.util.SingleBlockBlockReader;
import mod.chiselsandbits.api.util.SingleBlockWorldReader;
import mod.chiselsandbits.api.util.StateEntryPredicates;
import mod.chiselsandbits.api.voxelshape.IVoxelShapeManager;
import mod.chiselsandbits.block.entities.ChiseledBlockEntity;
import mod.chiselsandbits.client.model.data.ChiseledBlockModelDataManager;
import mod.chiselsandbits.network.packets.NeighborBlockUpdatedPacket;
import mod.chiselsandbits.utils.EffectUtils;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.material.PushReaction;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChiseledBlock
extends Block
implements IMultiStateBlock,
IWaterLoggable {
    public ChiseledBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    public float getSlipperiness(BlockState state, IWorldReader world, BlockPos pos, @Nullable Entity entity) {
        return this.getBlockEntityFromOrThrow((IBlockReader)world, pos).map(multiStateBlockEntity -> Float.valueOf(multiStateBlockEntity.getStatistics().getSlipperiness())).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        return this.getBlockEntityFromOrThrow(world, pos).map(multiStateBlockEntity -> (int)(multiStateBlockEntity.getStatistics().getLightEmissionFactor() * (float)world.func_201572_C())).orElse(0);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new ChiseledBlockEntity();
    }

    public boolean canHarvestBlock(BlockState state, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return this.getBlockEntityFromOrThrow(world, pos).map(e -> {
            BlockState primaryState = e.getStatistics().getPrimaryState();
            return primaryState.canHarvestBlock((IBlockReader)new SingleBlockBlockReader(primaryState, pos, world), pos, player);
        }).orElse(true);
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        if (!(target instanceof BlockRayTraceResult)) {
            return ItemStack.field_190927_a;
        }
        BlockRayTraceResult blockRayTraceResult = (BlockRayTraceResult)target;
        if (player.func_213453_ef()) {
            return this.getBlockEntityFromOrThrow(world, pos).map(e -> {
                IMultiStateSnapshot snapshot = e.createSnapshot();
                return snapshot.toItemStack().toBlockStack();
            }).orElse(ItemStack.field_190927_a);
        }
        return this.getBlockEntityFromOrThrow(world, pos).flatMap(e -> {
            Vector3d hitVec = blockRayTraceResult.func_216347_e();
            BlockPos blockPos = blockRayTraceResult.func_216350_a();
            Vector3d accuratePos = new Vector3d((double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p());
            Vector3d faceOffset = new Vector3d((double)((float)blockRayTraceResult.func_216354_b().func_176734_d().func_82601_c() * StateEntrySize.current().getSizePerHalfBit()), (double)((float)blockRayTraceResult.func_216354_b().func_176734_d().func_96559_d() * StateEntrySize.current().getSizePerHalfBit()), (double)((float)blockRayTraceResult.func_216354_b().func_176734_d().func_82599_e() * StateEntrySize.current().getSizePerHalfBit()));
            Vector3d hitDelta = hitVec.func_178788_d(accuratePos).func_178787_e(faceOffset);
            try {
                return e.getInAreaTarget(hitDelta);
            }
            catch (IllegalArgumentException exception) {
                return Optional.empty();
            }
        }).map(targetedStateEntry -> IMultiStateItemFactory.getInstance().createBlockFrom((IStateEntryInfo)targetedStateEntry)).orElseGet(() -> this.getBlockEntityFromOrThrow(world, pos).map(e -> {
            IMultiStateSnapshot snapshot = e.createSnapshot();
            return snapshot.toItemStack().toBlockStack();
        }).orElse(ItemStack.field_190927_a));
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean addHitEffects(BlockState state, World world, RayTraceResult target, ParticleManager manager) {
        if (!(target instanceof BlockRayTraceResult)) {
            return false;
        }
        BlockRayTraceResult blockRayTraceResult = (BlockRayTraceResult)target;
        return this.getBlockEntityFromOrThrow((IBlockReader)world, blockRayTraceResult.func_216350_a()).map(e -> EffectUtils.addHitEffects(world, blockRayTraceResult, e.getStatistics().getPrimaryState(), manager)).orElse(false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean addDestroyEffects(BlockState state, World world, BlockPos pos, ParticleManager manager) {
        return this.getBlockEntityFromOrThrow((IBlockReader)world, pos).map(e -> EffectUtils.addBlockDestroyEffects(new SingleBlockWorldReader(e.getStatistics().getPrimaryState(), pos, (IWorldReader)world), pos, e.getStatistics().getPrimaryState(), manager, world)).orElse(false);
    }

    public BlockState rotate(BlockState state, IWorld world, BlockPos pos, Rotation rotation) {
        for (Direction.Axis axis : Direction.Axis.values()) {
            if (!rotation.func_235574_a_().func_235529_a_(axis)) continue;
            this.getBlockEntityFromOrThrow((IBlockReader)world, pos).ifPresent(e -> e.rotate(axis));
            return state;
        }
        return state;
    }

    public boolean shouldCheckWeakPower(BlockState state, IWorldReader world, BlockPos pos, Direction side) {
        return this.getBlockEntityFromOrThrow((IBlockReader)world, pos).map(multiStateBlockEntity -> multiStateBlockEntity.getStatistics().shouldCheckWeakPower()).orElse(false);
    }

    public boolean isToolEffective(BlockState state, ToolType tool) {
        return true;
    }

    public boolean shouldDisplayFluidOverlay(BlockState state, IBlockDisplayReader world, BlockPos pos, FluidState fluidState) {
        return true;
    }

    @NotNull
    private Optional<IMultiStateBlockEntity> getBlockEntityFromOrThrow(IBlockReader worldIn, BlockPos pos) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (!(tileEntity instanceof IMultiStateBlockEntity)) {
            return Optional.empty();
        }
        return Optional.of((IMultiStateBlockEntity)tileEntity);
    }

    public boolean func_200123_i(@NotNull BlockState state, @NotNull IBlockReader reader, @NotNull BlockPos pos) {
        return this.getBlockEntityFromOrThrow(reader, pos).map(multiStateBlockEntity -> multiStateBlockEntity.getStatistics().canPropagateSkylight()).orElse(false);
    }

    public void func_180657_a(@NotNull World worldIn, @NotNull PlayerEntity player, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable TileEntity te, @NotNull ItemStack stack) {
        if (te instanceof IMultiStateBlockEntity) {
            IMultiStateBlockEntity multiStateBlockEntity = (IMultiStateBlockEntity)te;
            IMultiStateSnapshot snapshot = multiStateBlockEntity.createSnapshot();
            ChiseledBlock.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)snapshot.toItemStack().toBlockStack());
        }
    }

    public void func_180633_a(@NotNull World worldIn, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity placer, @NotNull ItemStack stack) {
        this.getBlockEntityFromOrThrow((IBlockReader)worldIn, pos).ifPresent(multiStateBlockEntity -> {
            Direction placementDirection = placer == null ? Direction.NORTH : placer.func_174811_aO().func_176734_d();
            int horizontalIndex = placementDirection.func_176736_b();
            int rotationCount = horizontalIndex - 4;
            if (rotationCount < 0) {
                rotationCount += 4;
            }
            multiStateBlockEntity.rotate(Direction.Axis.Y, rotationCount);
            super.func_180633_a(worldIn, pos, state, placer, stack);
        });
    }

    public void func_149666_a(@NotNull ItemGroup group, @NotNull NonNullList<ItemStack> items) {
    }

    public boolean func_208619_r() {
        return true;
    }

    @Override
    @NotNull
    public BlockState getPrimaryState(@NotNull IBlockReader world, @NotNull BlockPos pos) {
        return this.getBlockEntityFromOrThrow(world, pos).map(e -> e.getStatistics().getPrimaryState()).orElse(Blocks.field_150350_a.func_176223_P());
    }

    public void func_196243_a(@NotNull BlockState state, @NotNull World worldIn, @NotNull BlockPos pos, BlockState newState, boolean isMoving) {
        if (newState.func_177230_c() instanceof ChiseledBlock) {
            return;
        }
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    @NotNull
    public PushReaction func_149656_h(@NotNull BlockState state) {
        return PushReaction.BLOCK;
    }

    public boolean func_196253_a(@NotNull BlockState state, BlockItemUseContext useContext) {
        return this.getBlockEntityFromOrThrow((IBlockReader)useContext.func_195991_k(), useContext.func_195995_a()).map(multiStateBlockEntity -> multiStateBlockEntity.getStatistics().isEmptyBlock()).orElse(true);
    }

    @NotNull
    public VoxelShape func_230335_e_(@NotNull BlockState state, @NotNull IBlockReader reader, @NotNull BlockPos pos) {
        VoxelShape shape = this.getBlockEntityFromOrThrow(reader, pos).map(multiStateBlockEntity -> IVoxelShapeManager.getInstance().get((IAreaAccessor)multiStateBlockEntity, areaAccessor -> StateEntryPredicates.COLLIDEABLE_ONLY)).orElse(VoxelShapes.func_197880_a());
        return shape.func_197766_b() ? VoxelShapes.func_197868_b() : shape;
    }

    public float func_220080_a(@NotNull BlockState state, @NotNull IBlockReader worldIn, @NotNull BlockPos pos) {
        return 1.0f - 0.8f * this.getBlockEntityFromOrThrow(worldIn, pos).map(multiStateBlockEntity -> Float.valueOf(multiStateBlockEntity.getStatistics().getFullnessFactor())).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public int func_200011_d(@NotNull BlockState state, @NotNull IBlockReader worldIn, @NotNull BlockPos pos) {
        return (int)this.getBlockEntityFromOrThrow(worldIn, pos).map(multiStateBlockEntity -> Float.valueOf((float)worldIn.func_201572_C() * multiStateBlockEntity.getStatistics().getFullnessFactor())).orElse(Float.valueOf(0.0f)).floatValue();
    }

    @NotNull
    public VoxelShape func_220053_a(@NotNull BlockState state, @NotNull IBlockReader worldIn, @NotNull BlockPos pos, @NotNull ISelectionContext context) {
        VoxelShape shape = this.getBlockEntityFromOrThrow(worldIn, pos).map(multiStateBlockEntity -> IVoxelShapeManager.getInstance().get((IAreaAccessor)multiStateBlockEntity)).orElse(VoxelShapes.func_197880_a());
        return shape.func_197766_b() ? VoxelShapes.func_197868_b() : shape;
    }

    @NotNull
    public VoxelShape func_220071_b(@NotNull BlockState state, @NotNull IBlockReader worldIn, @NotNull BlockPos pos, @NotNull ISelectionContext context) {
        VoxelShape shape = this.getBlockEntityFromOrThrow(worldIn, pos).map(multiStateBlockEntity -> IVoxelShapeManager.getInstance().get((IAreaAccessor)multiStateBlockEntity, areaAccessor -> StateEntryPredicates.COLLIDEABLE_ONLY)).orElse(VoxelShapes.func_197880_a());
        if (shape.func_197766_b()) {
            boolean justFluids = this.getBlockEntityFromOrThrow(worldIn, pos).map(IAreaAccessor::stream).map(stream -> stream.allMatch(stateEntry -> stateEntry.getState().func_196958_f() || !stateEntry.getState().func_204520_s().func_206888_e())).orElse(false);
            return justFluids ? shape : VoxelShapes.func_197868_b();
        }
        return shape;
    }

    @NotNull
    public VoxelShape func_230322_a_(@NotNull BlockState state, @NotNull IBlockReader reader, @NotNull BlockPos pos, @NotNull ISelectionContext context) {
        return this.func_220053_a(state, reader, pos, context);
    }

    public float func_180647_a(@NotNull BlockState state, @NotNull PlayerEntity player, @NotNull IBlockReader worldIn, @NotNull BlockPos pos) {
        return this.getBlockEntityFromOrThrow(worldIn, pos).map(multiStateBlockEntity -> Float.valueOf(multiStateBlockEntity.getStatistics().getRelativeBlockHardness(player))).orElse(Float.valueOf(1.0f)).floatValue();
    }

    public boolean func_204510_a(@NotNull IBlockReader worldIn, @NotNull BlockPos pos, @NotNull BlockState state, Fluid fluidIn) {
        return IEligibilityManager.getInstance().canBeChiseled(fluidIn.func_207188_f().func_206883_i());
    }

    public boolean func_204509_a(@NotNull IWorld worldIn, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull FluidState fluidStateIn) {
        return this.getBlockEntityFromOrThrow((IBlockReader)worldIn, pos).map(entity -> {
            try (IBatchMutation ignored = entity.batch();){
                entity.mutableStream().forEach(stateEntry -> {
                    if (stateEntry.getState().func_196958_f()) {
                        try {
                            stateEntry.setState(fluidStateIn.func_206883_i().getBlockState());
                        }
                        catch (SpaceOccupiedException spaceOccupiedException) {
                            // empty catch block
                        }
                    }
                });
            }
            return true;
        }).orElse(false);
    }

    @NotNull
    public Fluid func_204508_a(@NotNull IWorld worldIn, @NotNull BlockPos pos, @NotNull BlockState state) {
        return Fluids.field_204541_a;
    }

    public void func_220069_a(@NotNull BlockState state, World level, @NotNull BlockPos position, @NotNull Block block, @NotNull BlockPos otherPosition, boolean update) {
        TileEntity tileEntity = level.func_175625_s(position);
        if (level.func_201670_d() && tileEntity instanceof ChiseledBlockEntity) {
            ChiseledBlockModelDataManager.getInstance().updateModelData((ChiseledBlockEntity)tileEntity);
        } else if (!level.func_201670_d() && tileEntity instanceof ChiseledBlockEntity) {
            ChiselsAndBits.getInstance().getNetworkChannel().sendToTrackingChunk(new NeighborBlockUpdatedPacket(position, otherPosition), level.func_175726_f(position));
        }
    }

    public float[] getBeaconColorMultiplier(BlockState state, IWorldReader world, BlockPos pos, BlockPos beaconPos) {
        return this.getBlockEntityFromOrThrow((IBlockReader)world, pos).filter(e -> e.getStatistics().getStateCounts().keySet().stream().filter(entryState -> !entryState.func_196958_f()).allMatch(entryState -> entryState.getBeaconColorMultiplier((IWorldReader)new SingleBlockWorldReader(e.getStatistics().getPrimaryState(), pos, world), pos, beaconPos) != null)).flatMap(e -> e.getStatistics().getStateCounts().entrySet().stream().filter(entryState -> !((BlockState)entryState.getKey()).func_196958_f()).map(entryState -> ArrayUtils.multiply(((BlockState)entryState.getKey()).getBeaconColorMultiplier((IWorldReader)new SingleBlockWorldReader(e.getStatistics().getPrimaryState(), pos, world), pos, beaconPos), ((Integer)entryState.getValue()).intValue())).reduce((floats, floats2) -> {
            if (((float[])floats).length != ((float[])floats2).length) {
                return null;
            }
            if (floats == null) {
                return null;
            }
            if (floats2 == null) {
                return null;
            }
            float[] result = new float[((float[])floats).length];
            for (int i = 0; i < ((float[])floats).length; ++i) {
                result[i] = floats[i] + floats2[i];
            }
            return result;
        }).filter(Objects::nonNull).flatMap(summedResult -> this.getBlockEntityFromOrThrow((IBlockReader)world, pos).map(entity -> ArrayUtils.multiply(summedResult, 1.0f / (entity.getStatistics().getFullnessFactor() * (float)StateEntrySize.current().getBitsPerBlock()))))).orElse(null);
    }
}

