/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.block.entities;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Stream;
import mod.chiselsandbits.ChiselsAndBits;
import mod.chiselsandbits.api.block.entity.IMultiStateBlockEntity;
import mod.chiselsandbits.api.block.state.id.IBlockStateIdManager;
import mod.chiselsandbits.api.change.IChangeTracker;
import mod.chiselsandbits.api.chiseling.conversion.IConversionManager;
import mod.chiselsandbits.api.chiseling.eligibility.IEligibilityManager;
import mod.chiselsandbits.api.exceptions.SpaceOccupiedException;
import mod.chiselsandbits.api.multistate.StateEntrySize;
import mod.chiselsandbits.api.multistate.accessor.IStateEntryInfo;
import mod.chiselsandbits.api.multistate.accessor.identifier.IAreaShapeIdentifier;
import mod.chiselsandbits.api.multistate.accessor.identifier.ILongArrayBackedAreaShapeIdentifier;
import mod.chiselsandbits.api.multistate.accessor.sortable.IPositionMutator;
import mod.chiselsandbits.api.multistate.mutator.IMutableStateEntryInfo;
import mod.chiselsandbits.api.multistate.mutator.batched.IBatchMutation;
import mod.chiselsandbits.api.multistate.mutator.callback.StateClearer;
import mod.chiselsandbits.api.multistate.mutator.callback.StateSetter;
import mod.chiselsandbits.api.multistate.mutator.world.IInWorldMutableStateEntryInfo;
import mod.chiselsandbits.api.multistate.snapshot.IMultiStateSnapshot;
import mod.chiselsandbits.api.multistate.statistics.IMultiStateObjectStatistics;
import mod.chiselsandbits.api.util.BlockPosStreamProvider;
import mod.chiselsandbits.api.util.IPacketBufferSerializable;
import mod.chiselsandbits.api.util.SingleBlockBlockReader;
import mod.chiselsandbits.api.util.SingleBlockWorldReader;
import mod.chiselsandbits.api.util.Vector2i;
import mod.chiselsandbits.client.model.data.ChiseledBlockModelDataManager;
import mod.chiselsandbits.legacy.LegacyLoadManager;
import mod.chiselsandbits.network.packets.TileEntityUpdatedPacket;
import mod.chiselsandbits.registrars.ModTileEntityTypes;
import mod.chiselsandbits.utils.ChunkSectionUtils;
import mod.chiselsandbits.utils.MultiStateSnapshotUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.common.util.INBTSerializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChiseledBlockEntity
extends TileEntity
implements IMultiStateBlockEntity {
    public static final float ONE_THOUSANDS = 0.001f;
    private final MutableStatistics mutableStatistics;
    private final Map<UUID, IBatchMutation> batchMutations = Maps.newConcurrentMap();
    private ChunkSection compressedSection;
    private IModelData modelData = new ModelDataMap.Builder().build();

    public ChiseledBlockEntity() {
        super((TileEntityType)ModTileEntityTypes.CHISELED.get());
        this.compressedSection = new ChunkSection(0);
        this.mutableStatistics = new MutableStatistics(() -> ((ChiseledBlockEntity)this).func_145831_w(), () -> ((ChiseledBlockEntity)this).func_174877_v());
    }

    @Override
    public IAreaShapeIdentifier createNewShapeIdentifier() {
        return new Identifier(this.compressedSection);
    }

    @Override
    public Stream<IStateEntryInfo> stream() {
        return BlockPosStreamProvider.getForRange(StateEntrySize.current().getBitsPerBlockSide()).map(blockPos -> new StateEntry(this.compressedSection.func_177485_a(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p()), (IWorld)this.func_145831_w(), this.func_174877_v(), (Vector3i)blockPos, this::setInAreaTarget, this::clearInAreaTarget));
    }

    @Override
    public boolean isInside(Vector3d inAreaTarget) {
        return !(inAreaTarget.func_82615_a() < 0.0 || inAreaTarget.func_82617_b() < 0.0 || inAreaTarget.func_82616_c() < 0.0 || inAreaTarget.func_82615_a() >= 1.0 || inAreaTarget.func_82617_b() >= 1.0 || inAreaTarget.func_82616_c() >= 1.0);
    }

    @Override
    public Optional<IStateEntryInfo> getInAreaTarget(Vector3d inAreaTarget) {
        if (inAreaTarget.func_82615_a() < 0.0 || inAreaTarget.func_82617_b() < 0.0 || inAreaTarget.func_82616_c() < 0.0 || inAreaTarget.func_82615_a() >= 1.0 || inAreaTarget.func_82617_b() >= 1.0 || inAreaTarget.func_82616_c() >= 1.0) {
            throw new IllegalArgumentException("Target is not in the current area.");
        }
        BlockPos inAreaPos = new BlockPos(inAreaTarget.func_216372_d((double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide()));
        BlockState currentState = this.compressedSection.func_177485_a(inAreaPos.func_177958_n(), inAreaPos.func_177956_o(), inAreaPos.func_177952_p());
        return Optional.of(new StateEntry(currentState, (IWorld)this.func_145831_w(), this.func_174877_v(), (Vector3i)inAreaPos, this::setInAreaTarget, this::clearInAreaTarget));
    }

    @Override
    public boolean isInside(BlockPos inAreaBlockPosOffset, Vector3d inBlockTarget) {
        if (!inAreaBlockPosOffset.equals((Object)BlockPos.field_177992_a)) {
            return false;
        }
        return this.isInside(inBlockTarget);
    }

    @Override
    public Optional<IStateEntryInfo> getInBlockTarget(BlockPos inAreaBlockPosOffset, Vector3d inBlockTarget) {
        if (!inAreaBlockPosOffset.equals((Object)BlockPos.field_177992_a)) {
            throw new IllegalStateException(String.format("The given in area block pos offset is not inside the current block: %s", inAreaBlockPosOffset));
        }
        return this.getInAreaTarget(inBlockTarget);
    }

    @Override
    public IMultiStateSnapshot createSnapshot() {
        return MultiStateSnapshotUtils.createFromSection(this.compressedSection);
    }

    public void func_230337_a_(@Nullable BlockState state, @NotNull CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.deserializeNBT(nbt);
    }

    public void deserializeNBT(CompoundNBT nbt) {
        if (!nbt.func_74764_b("chiselBlockData")) {
            ChunkSection legacyDataSection = LegacyLoadManager.getInstance().attemptLegacyBlockEntityLoad(nbt);
            if (ChunkSection.func_222628_a((ChunkSection)legacyDataSection)) {
                for (int x = 0; x < StateEntrySize.current().getBitsPerBlockSide(); ++x) {
                    for (int y = 0; y < StateEntrySize.current().getBitsPerBlockSide(); ++y) {
                        for (int z = 0; z < StateEntrySize.current().getBitsPerBlockSide(); ++z) {
                            this.compressedSection.func_177484_a(x, y, z, Blocks.field_150350_a.func_176223_P(), false);
                        }
                    }
                }
                this.mutableStatistics.recalculate(this.compressedSection, false);
                return;
            }
            MutableStatistics legacyStatistics = new MutableStatistics(() -> ((ChiseledBlockEntity)this).func_145831_w(), () -> ((ChiseledBlockEntity)this).func_174877_v());
            legacyStatistics.recalculate(legacyDataSection, false);
            CompoundNBT chiselBlockData = new CompoundNBT();
            CompoundNBT compressedSectionData = ChunkSectionUtils.serializeNBT(legacyDataSection);
            chiselBlockData.func_218657_a("compressedStorage", (INBT)compressedSectionData);
            chiselBlockData.func_218657_a("statistics", (INBT)legacyStatistics.serializeNBT());
            nbt.func_218657_a("chiselBlockData", (INBT)chiselBlockData);
        }
        CompoundNBT chiselBlockData = nbt.func_74775_l("chiselBlockData");
        CompoundNBT compressedSectionData = chiselBlockData.func_74775_l("compressedStorage");
        CompoundNBT statisticsData = chiselBlockData.func_74775_l("statistics");
        ChunkSectionUtils.deserializeNBT(this.compressedSection, compressedSectionData);
        this.mutableStatistics.deserializeNBT(statisticsData);
        ChiseledBlockModelDataManager.getInstance().updateModelData(this);
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = super.serializeNBT();
        return this.func_189515_b(nbt);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.handleUpdateTag(Objects.requireNonNull(this.func_145831_w()).func_180495_p(this.func_174877_v()), pkt.func_148857_g());
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        byte[] compressedStorageData = tag.func_74770_j("chiselBlockData");
        ByteBuf buffer = Unpooled.wrappedBuffer((byte[])compressedStorageData);
        this.deserializeFrom(new PacketBuffer(buffer));
        buffer.release();
    }

    @NotNull
    public CompoundNBT func_189515_b(@NotNull CompoundNBT compound) {
        CompoundNBT nbt = super.func_189515_b(compound);
        CompoundNBT chiselBlockData = new CompoundNBT();
        CompoundNBT compressedSectionData = ChunkSectionUtils.serializeNBT(this.compressedSection);
        chiselBlockData.func_218657_a("compressedStorage", (INBT)compressedSectionData);
        chiselBlockData.func_218657_a("statistics", (INBT)this.mutableStatistics.serializeNBT());
        nbt.func_218657_a("chiselBlockData", (INBT)chiselBlockData);
        return nbt;
    }

    public void func_70296_d() {
        if (this.func_145831_w() != null && this.batchMutations.isEmpty()) {
            this.mutableStatistics.recalculate(this.compressedSection, true);
            super.func_70296_d();
            this.func_145831_w().func_225524_e_().func_215568_a(this.func_174877_v());
            this.func_145831_w().func_184138_a(this.func_174877_v(), Blocks.field_150350_a.func_176223_P(), this.func_195044_w(), 3);
            if (!this.func_145831_w().func_201670_d()) {
                ChiselsAndBits.getInstance().getNetworkChannel().sendToTrackingChunk(new TileEntityUpdatedPacket(this), this.func_145831_w().func_175726_f(this.func_174877_v()));
                this.func_145831_w().func_195593_d(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()).func_177230_c());
            }
        }
    }

    private boolean shouldUpdateWorld() {
        return this.func_145831_w() != null && this.batchMutations.size() == 0 && this.func_145831_w() instanceof ServerWorld;
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 255, this.func_189517_E_());
    }

    @NotNull
    public CompoundNBT func_189517_E_() {
        CompoundNBT updateTag = super.func_189517_E_();
        ByteBuf buffer = Unpooled.buffer();
        PacketBuffer innerPacketBuffer = new PacketBuffer(buffer);
        this.serializeInto(innerPacketBuffer);
        byte[] data = buffer.array();
        buffer.release();
        updateTag.func_74773_a("chiselBlockData", data);
        return updateTag;
    }

    @Override
    public void serializeInto(@NotNull PacketBuffer packetBuffer) {
        this.compressedSection.func_222630_b(packetBuffer);
        this.mutableStatistics.serializeInto(packetBuffer);
    }

    @Override
    public void deserializeFrom(@NotNull PacketBuffer packetBuffer) {
        this.compressedSection.func_222634_a(packetBuffer);
        this.mutableStatistics.deserializeFrom(packetBuffer);
        ChiseledBlockModelDataManager.getInstance().updateModelData(this);
    }

    @Override
    public Stream<IMutableStateEntryInfo> mutableStream() {
        return BlockPosStreamProvider.getForRange(StateEntrySize.current().getBitsPerBlockSide()).map(blockPos -> new StateEntry(this.compressedSection.func_177485_a(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p()), (IWorld)this.func_145831_w(), this.func_174877_v(), (Vector3i)blockPos, this::setInAreaTarget, this::clearInAreaTarget));
    }

    @Override
    public void setInAreaTarget(BlockState blockState, Vector3d inAreaTarget) throws SpaceOccupiedException {
        if (inAreaTarget.func_82615_a() < 0.0 || inAreaTarget.func_82617_b() < 0.0 || inAreaTarget.func_82616_c() < 0.0 || inAreaTarget.func_82615_a() >= 1.0 || inAreaTarget.func_82617_b() >= 1.0 || inAreaTarget.func_82616_c() >= 1.0) {
            throw new IllegalArgumentException("Target is not in the current area.");
        }
        BlockPos inAreaPos = new BlockPos(inAreaTarget.func_216372_d((double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide()));
        BlockState currentState = this.compressedSection.func_177485_a(inAreaPos.func_177958_n(), inAreaPos.func_177956_o(), inAreaPos.func_177952_p());
        if (!currentState.isAir((IBlockReader)new SingleBlockBlockReader(currentState, this.func_174877_v(), (IBlockReader)this.func_145831_w()), this.func_174877_v())) {
            throw new SpaceOccupiedException();
        }
        if (this.func_145831_w() == null) {
            return;
        }
        this.compressedSection.func_177484_a(inAreaPos.func_177958_n(), inAreaPos.func_177956_o(), inAreaPos.func_177952_p(), blockState, true);
        if (blockState.func_196958_f() && !currentState.func_196958_f()) {
            this.mutableStatistics.onBlockStateRemoved(currentState, inAreaPos, this.shouldUpdateWorld());
        } else if (!blockState.func_196958_f() && currentState.func_196958_f()) {
            this.mutableStatistics.onBlockStateAdded(blockState, inAreaPos, this.shouldUpdateWorld());
        } else if (!blockState.func_196958_f() && !currentState.func_196958_f()) {
            this.mutableStatistics.onBlockStateReplaced(currentState, blockState, inAreaPos, this.shouldUpdateWorld());
        }
        if (this.func_145831_w() != null) {
            this.func_70296_d();
        }
    }

    @Override
    public IWorld getWorld() {
        return this.func_145831_w();
    }

    @Override
    public Vector3d getInWorldStartPoint() {
        return Vector3d.func_237491_b_((Vector3i)this.func_174877_v());
    }

    @Override
    public void setInBlockTarget(BlockState blockState, BlockPos inAreaBlockPosOffset, Vector3d inBlockTarget) throws SpaceOccupiedException {
        if (!inAreaBlockPosOffset.equals((Object)BlockPos.field_177992_a)) {
            throw new IllegalStateException(String.format("The given in area block pos offset is not inside the current block: %s", inAreaBlockPosOffset));
        }
        this.setInAreaTarget(blockState, inBlockTarget);
    }

    @Override
    public Vector3d getInWorldEndPoint() {
        return this.getInWorldStartPoint().func_72441_c(1.0, 1.0, 1.0).func_178786_a((double)0.001f, (double)0.001f, (double)0.001f);
    }

    @Override
    public void clearInAreaTarget(Vector3d inAreaTarget) {
        if (inAreaTarget.func_82615_a() < 0.0 || inAreaTarget.func_82617_b() < 0.0 || inAreaTarget.func_82616_c() < 0.0 || inAreaTarget.func_82615_a() >= 1.0 || inAreaTarget.func_82617_b() >= 1.0 || inAreaTarget.func_82616_c() >= 1.0) {
            throw new IllegalArgumentException("Target is not in the current area.");
        }
        BlockPos inAreaPos = new BlockPos(inAreaTarget.func_216372_d((double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide()));
        if (this.func_145831_w() == null) {
            return;
        }
        BlockState currentState = this.compressedSection.func_177485_a(inAreaPos.func_177958_n(), inAreaPos.func_177956_o(), inAreaPos.func_177952_p());
        if (!IEligibilityManager.getInstance().canBeChiseled(currentState)) {
            return;
        }
        BlockState blockState = Blocks.field_150350_a.func_176223_P();
        this.compressedSection.func_177484_a(inAreaPos.func_177958_n(), inAreaPos.func_177956_o(), inAreaPos.func_177952_p(), blockState, true);
        if (blockState.func_196958_f() && !currentState.func_196958_f()) {
            this.mutableStatistics.onBlockStateRemoved(currentState, inAreaPos, this.shouldUpdateWorld());
        } else if (!blockState.func_196958_f() && currentState.func_196958_f()) {
            this.mutableStatistics.onBlockStateAdded(blockState, inAreaPos, this.shouldUpdateWorld());
        } else if (!blockState.func_196958_f() && !currentState.func_196958_f()) {
            this.mutableStatistics.onBlockStateReplaced(currentState, blockState, inAreaPos, this.shouldUpdateWorld());
        }
        if (this.func_145831_w() != null) {
            this.func_70296_d();
        }
    }

    @Override
    public void clearInBlockTarget(BlockPos inAreaBlockPosOffset, Vector3d inBlockTarget) {
        if (!inAreaBlockPosOffset.equals((Object)BlockPos.field_177992_a)) {
            throw new IllegalStateException(String.format("The given in area block pos offset is not inside the current block: %s", inAreaBlockPosOffset));
        }
        this.clearInAreaTarget(inBlockTarget);
    }

    @Override
    public IMultiStateObjectStatistics getStatistics() {
        return this.mutableStatistics;
    }

    @Override
    public void rotate(Direction.Axis axis, int rotationCount) {
        if (this.func_145831_w() == null) {
            return;
        }
        try (IBatchMutation ignored = this.batch();){
            this.compressedSection = ChunkSectionUtils.rotate90Degrees(this.compressedSection, axis, rotationCount);
            this.mutableStatistics.clear();
            BlockPosStreamProvider.getForRange(StateEntrySize.current().getBitsPerBlockSide()).forEach(position -> this.mutableStatistics.onBlockStateAdded(this.compressedSection.func_177485_a(position.func_177958_n(), position.func_177956_o(), position.func_177952_p()), position, this.shouldUpdateWorld()));
        }
    }

    @Override
    public void initializeWith(BlockState currentState) {
        if (this.func_145831_w() == null) {
            return;
        }
        try (IBatchMutation batchMutation = this.batch();){
            BlockPosStreamProvider.getForRange(StateEntrySize.current().getBitsPerBlockSide()).forEach(blockPos -> this.compressedSection.func_222629_a(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p(), currentState));
            this.mutableStatistics.initializeWith(currentState);
        }
    }

    @Override
    public Stream<IInWorldMutableStateEntryInfo> inWorldMutableStream() {
        return BlockPosStreamProvider.getForRange(StateEntrySize.current().getBitsPerBlockSide()).map(blockPos -> new StateEntry(this.compressedSection.func_177485_a(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p()), (IWorld)this.func_145831_w(), this.func_174877_v(), (Vector3i)blockPos, this::setInAreaTarget, this::clearInAreaTarget));
    }

    @Override
    public Stream<IStateEntryInfo> streamWithPositionMutator(IPositionMutator positionMutator) {
        return BlockPosStreamProvider.getForRange(StateEntrySize.current().getBitsPerBlockSide()).map(blockPos -> {
            Vector3i pos = positionMutator.mutate((Vector3i)blockPos);
            return new StateEntry(this.compressedSection.func_177485_a(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()), (IWorld)this.func_145831_w(), this.func_174877_v(), pos, this::setInAreaTarget, this::clearInAreaTarget);
        });
    }

    @Override
    public IBatchMutation batch() {
        UUID id = UUID.randomUUID();
        this.batchMutations.put(id, new BatchMutationLock(() -> {
            this.batchMutations.remove(id);
            if (this.batchMutations.isEmpty()) {
                this.func_70296_d();
            }
        }));
        return this.batchMutations.get(id);
    }

    @Override
    public IBatchMutation batch(IChangeTracker changeTracker) {
        IBatchMutation innerMutation = this.batch();
        IMultiStateSnapshot before = this.createSnapshot();
        return () -> {
            IMultiStateSnapshot after = this.createSnapshot();
            innerMutation.close();
            changeTracker.onBlockUpdated(this.func_174877_v(), before, after);
        };
    }

    public void setModelData(IModelData modelData) {
        this.modelData = modelData;
    }

    @NotNull
    public IModelData getModelData() {
        return this.modelData;
    }

    private static final class BatchMutationLock
    implements IBatchMutation {
        private final Runnable closeCallback;

        private BatchMutationLock(Runnable closeCallback) {
            this.closeCallback = closeCallback;
        }

        @Override
        public void close() {
            this.closeCallback.run();
        }
    }

    private static final class Identifier
    implements ILongArrayBackedAreaShapeIdentifier {
        private final long[] identifyingPayload;

        private Identifier(ChunkSection section) {
            this.identifyingPayload = Arrays.copyOf(section.func_186049_g().field_186021_b.func_188143_a(), section.func_186049_g().field_186021_b.func_188143_a().length);
        }

        public int hashCode() {
            return Arrays.hashCode(this.identifyingPayload);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ILongArrayBackedAreaShapeIdentifier)) {
                return false;
            }
            ILongArrayBackedAreaShapeIdentifier that = (ILongArrayBackedAreaShapeIdentifier)o;
            return Arrays.equals(this.identifyingPayload, that.getBackingData());
        }

        public String toString() {
            return "Identifier{identifyingPayload=" + Arrays.toString(this.identifyingPayload) + '}';
        }

        @Override
        public long[] getBackingData() {
            return this.identifyingPayload;
        }
    }

    private static final class MutableStatistics
    implements IMultiStateObjectStatistics,
    INBTSerializable<CompoundNBT>,
    IPacketBufferSerializable {
        private final Supplier<IWorld> worldReaderSupplier;
        private final Supplier<BlockPos> positionSupplier;
        private final Map<BlockState, Integer> countMap = Maps.newConcurrentMap();
        private final Multimap<Vector2i, Integer> columnBlockedMap = HashMultimap.create();
        private BlockState primaryState = Blocks.field_150350_a.func_176223_P();
        private int totalUsedBlockCount = 0;
        private int totalUsedChecksWeakPowerCount = 0;
        private float totalUpperSurfaceSlipperiness = 0.0f;
        private int totalLightLevel = 0;

        private MutableStatistics(Supplier<IWorld> worldReaderSupplier, Supplier<BlockPos> positionSupplier) {
            this.worldReaderSupplier = worldReaderSupplier;
            this.positionSupplier = positionSupplier;
        }

        @Override
        public BlockState getPrimaryState() {
            return this.primaryState;
        }

        @Override
        public boolean isEmpty() {
            return this.countMap.size() == 1 && this.countMap.getOrDefault(Blocks.field_150350_a.func_176223_P(), 0) == 4096;
        }

        @Override
        public Map<BlockState, Integer> getStateCounts() {
            return Collections.unmodifiableMap(this.countMap);
        }

        @Override
        public boolean shouldCheckWeakPower() {
            return this.totalUsedChecksWeakPowerCount == StateEntrySize.current().getBitsPerBlock();
        }

        @Override
        public float getFullnessFactor() {
            return (float)this.totalUsedBlockCount / (float)StateEntrySize.current().getBitsPerBlock();
        }

        @Override
        public float getSlipperiness() {
            return this.totalUpperSurfaceSlipperiness / (float)StateEntrySize.current().getBitsPerLayer();
        }

        @Override
        public float getLightEmissionFactor() {
            return (float)this.totalLightLevel / (float)this.totalUsedBlockCount;
        }

        @Override
        public float getRelativeBlockHardness(PlayerEntity player) {
            double totalRelativeHardness = this.countMap.entrySet().stream().mapToDouble(entry -> (double)((BlockState)entry.getKey()).func_185903_a(player, (IBlockReader)new SingleBlockWorldReader((BlockState)entry.getKey(), this.positionSupplier.get(), (IWorldReader)this.worldReaderSupplier.get()), this.positionSupplier.get()) * (double)((Integer)entry.getValue()).intValue()).filter(Double::isFinite).sum();
            if (totalRelativeHardness == 0.0 || Double.isNaN(totalRelativeHardness) || Double.isInfinite(totalRelativeHardness)) {
                return 0.0f;
            }
            return (float)(totalRelativeHardness / (double)this.totalUsedBlockCount);
        }

        @Override
        public boolean canPropagateSkylight() {
            for (int x = 0; x < StateEntrySize.current().getBitsPerBlockSide(); ++x) {
                for (int y = 0; y < StateEntrySize.current().getBitsPerBlockSide(); ++y) {
                    Vector2i coordinate = new Vector2i(x, y);
                    if (this.columnBlockedMap.containsKey((Object)coordinate)) continue;
                    return true;
                }
            }
            return false;
        }

        private void onBlockStateAdded(BlockState blockState, BlockPos pos, boolean updateWorld) {
            this.countMap.putIfAbsent(blockState, 0);
            this.countMap.computeIfPresent(blockState, (state, currentCount) -> currentCount + 1);
            this.updatePrimaryState(updateWorld);
            ++this.totalUsedBlockCount;
            if (blockState.shouldCheckWeakPower((IWorldReader)new SingleBlockWorldReader(blockState, this.positionSupplier.get(), (IWorldReader)this.worldReaderSupplier.get()), this.positionSupplier.get(), Direction.NORTH)) {
                ++this.totalUsedChecksWeakPowerCount;
            }
            if (pos.func_177956_o() == 15) {
                this.totalUpperSurfaceSlipperiness += blockState.getSlipperiness((IWorldReader)new SingleBlockWorldReader(blockState, this.positionSupplier.get(), (IWorldReader)this.worldReaderSupplier.get()), this.positionSupplier.get(), null);
            }
            this.totalLightLevel += blockState.getLightValue((IBlockReader)new SingleBlockWorldReader(blockState, this.positionSupplier.get(), (IWorldReader)this.worldReaderSupplier.get()), this.positionSupplier.get());
            if (!blockState.func_200131_a((IBlockReader)new SingleBlockWorldReader(blockState, this.positionSupplier.get(), (IWorldReader)this.worldReaderSupplier.get()), this.positionSupplier.get())) {
                this.columnBlockedMap.put((Object)new Vector2i(pos.func_177958_n(), pos.func_177952_p()), (Object)pos.func_177956_o());
            }
        }

        private void updatePrimaryState(boolean updateWorld) {
            BlockState currentPrimary = this.primaryState;
            this.primaryState = this.countMap.entrySet().stream().filter(e -> !((BlockState)e.getKey()).isAir((IBlockReader)new SingleBlockBlockReader((BlockState)e.getKey(), this.positionSupplier.get(), (IBlockReader)this.worldReaderSupplier.get()), this.positionSupplier.get())).min((o1, o2) -> -1 * ((Integer)o1.getValue() - (Integer)o2.getValue())).map(Map.Entry::getKey).orElseGet(() -> ((Block)Blocks.field_150350_a).func_176223_P());
            boolean primaryIsAir = this.primaryState.isAir((IBlockReader)new SingleBlockBlockReader(this.primaryState, this.positionSupplier.get(), (IBlockReader)this.worldReaderSupplier.get()), this.positionSupplier.get());
            if ((this.countMap.getOrDefault(this.primaryState, 0).intValue() == StateEntrySize.current().getBitsPerBlock() || primaryIsAir || currentPrimary != this.primaryState) && updateWorld) {
                Optional<Block> optionalWithConvertedBlock;
                if (primaryIsAir) {
                    this.worldReaderSupplier.get().func_180501_a(this.positionSupplier.get(), Blocks.field_150350_a.func_176223_P(), 18);
                } else if (this.countMap.getOrDefault(this.primaryState, 0).intValue() == StateEntrySize.current().getBitsPerBlock()) {
                    this.worldReaderSupplier.get().func_180501_a(this.positionSupplier.get(), this.primaryState, 18);
                } else if (currentPrimary != this.primaryState && (optionalWithConvertedBlock = IConversionManager.getInstance().getChiseledVariantOf(this.primaryState)).isPresent()) {
                    Block convertedBlock = optionalWithConvertedBlock.get();
                    this.worldReaderSupplier.get().func_180501_a(this.positionSupplier.get(), convertedBlock.func_176223_P(), 18);
                }
            }
        }

        private void onBlockStateRemoved(BlockState blockState, BlockPos pos, boolean updateWorld) {
            this.countMap.computeIfPresent(blockState, (state, currentCount) -> currentCount - 1);
            this.countMap.remove(blockState, 0);
            this.updatePrimaryState(updateWorld);
            --this.totalUsedBlockCount;
            if (blockState.shouldCheckWeakPower((IWorldReader)new SingleBlockWorldReader(blockState, this.positionSupplier.get(), (IWorldReader)this.worldReaderSupplier.get()), this.positionSupplier.get(), Direction.NORTH)) {
                --this.totalUsedChecksWeakPowerCount;
            }
            if (pos.func_177956_o() == 15) {
                this.totalUpperSurfaceSlipperiness -= blockState.getSlipperiness((IWorldReader)new SingleBlockWorldReader(blockState, this.positionSupplier.get(), (IWorldReader)this.worldReaderSupplier.get()), this.positionSupplier.get(), null);
            }
            this.totalLightLevel -= blockState.getLightValue((IBlockReader)new SingleBlockWorldReader(blockState, this.positionSupplier.get(), (IWorldReader)this.worldReaderSupplier.get()), this.positionSupplier.get());
            this.columnBlockedMap.remove((Object)new Vector2i(pos.func_177958_n(), pos.func_177952_p()), (Object)pos.func_177956_o());
        }

        private void onBlockStateReplaced(BlockState currentState, BlockState newState, BlockPos pos, boolean updateWorld) {
            this.countMap.computeIfPresent(currentState, (state, currentCount) -> currentCount - 1);
            this.countMap.remove(currentState, 0);
            this.countMap.putIfAbsent(newState, 0);
            this.countMap.computeIfPresent(newState, (state, currentCount) -> currentCount + 1);
            this.updatePrimaryState(updateWorld);
            if (currentState.shouldCheckWeakPower((IWorldReader)new SingleBlockWorldReader(currentState, this.positionSupplier.get(), (IWorldReader)this.worldReaderSupplier.get()), this.positionSupplier.get(), Direction.NORTH)) {
                --this.totalUsedChecksWeakPowerCount;
            }
            if (newState.shouldCheckWeakPower((IWorldReader)new SingleBlockWorldReader(newState, this.positionSupplier.get(), (IWorldReader)this.worldReaderSupplier.get()), this.positionSupplier.get(), Direction.NORTH)) {
                ++this.totalUsedChecksWeakPowerCount;
            }
            if (pos.func_177956_o() == 15) {
                this.totalUpperSurfaceSlipperiness -= currentState.getSlipperiness((IWorldReader)new SingleBlockWorldReader(currentState, this.positionSupplier.get(), (IWorldReader)this.worldReaderSupplier.get()), this.positionSupplier.get(), null);
                this.totalUpperSurfaceSlipperiness += newState.getSlipperiness((IWorldReader)new SingleBlockWorldReader(newState, this.positionSupplier.get(), (IWorldReader)this.worldReaderSupplier.get()), this.positionSupplier.get(), null);
            }
            this.totalLightLevel -= currentState.getLightValue((IBlockReader)new SingleBlockWorldReader(currentState, this.positionSupplier.get(), (IWorldReader)this.worldReaderSupplier.get()), this.positionSupplier.get());
            this.totalLightLevel += newState.getLightValue((IBlockReader)new SingleBlockWorldReader(newState, this.positionSupplier.get(), (IWorldReader)this.worldReaderSupplier.get()), this.positionSupplier.get());
            if (currentState.func_200131_a((IBlockReader)new SingleBlockWorldReader(newState, this.positionSupplier.get(), (IWorldReader)this.worldReaderSupplier.get()), this.positionSupplier.get())) {
                if (!newState.func_200131_a((IBlockReader)new SingleBlockWorldReader(newState, this.positionSupplier.get(), (IWorldReader)this.worldReaderSupplier.get()), this.positionSupplier.get())) {
                    this.columnBlockedMap.remove((Object)new Vector2i(pos.func_177958_n(), pos.func_177952_p()), (Object)pos.func_177956_o());
                }
            } else if (newState.func_200131_a((IBlockReader)new SingleBlockWorldReader(newState, this.positionSupplier.get(), (IWorldReader)this.worldReaderSupplier.get()), this.positionSupplier.get())) {
                this.columnBlockedMap.put((Object)new Vector2i(pos.func_177958_n(), pos.func_177952_p()), (Object)pos.func_177956_o());
            }
        }

        @Override
        public void serializeInto(@NotNull PacketBuffer packetBuffer) {
            packetBuffer.func_150787_b(IBlockStateIdManager.getInstance().getIdFrom(this.primaryState));
            packetBuffer.func_150787_b(this.countMap.size());
            for (Map.Entry<BlockState, Integer> blockStateIntegerEntry : this.countMap.entrySet()) {
                packetBuffer.func_150787_b(IBlockStateIdManager.getInstance().getIdFrom(blockStateIntegerEntry.getKey()));
                packetBuffer.func_150787_b(blockStateIntegerEntry.getValue().intValue());
            }
            packetBuffer.func_150787_b(this.columnBlockedMap.size());
            for (Map.Entry<Object, Integer> vector2iIntegerEntry : this.columnBlockedMap.entries()) {
                packetBuffer.func_150787_b(((Vector2i)vector2iIntegerEntry.getKey()).getX());
                packetBuffer.func_150787_b(((Vector2i)vector2iIntegerEntry.getKey()).getY());
                packetBuffer.func_150787_b(vector2iIntegerEntry.getValue().intValue());
            }
            packetBuffer.func_150787_b(this.totalUsedBlockCount);
            packetBuffer.func_150787_b(this.totalUsedChecksWeakPowerCount);
            packetBuffer.writeFloat(this.totalUpperSurfaceSlipperiness);
            packetBuffer.func_150787_b(this.totalLightLevel);
        }

        @Override
        public void deserializeFrom(@NotNull PacketBuffer packetBuffer) {
            this.countMap.clear();
            this.columnBlockedMap.clear();
            this.primaryState = IBlockStateIdManager.getInstance().getBlockStateFrom(packetBuffer.func_150792_a());
            int stateCount = packetBuffer.func_150792_a();
            for (int i = 0; i < stateCount; ++i) {
                this.countMap.put(IBlockStateIdManager.getInstance().getBlockStateFrom(packetBuffer.func_150792_a()), packetBuffer.func_150792_a());
            }
            int columnBlockCount = packetBuffer.func_150792_a();
            for (int i = 0; i < columnBlockCount; ++i) {
                this.columnBlockedMap.put((Object)new Vector2i(packetBuffer.func_150792_a(), packetBuffer.func_150792_a()), (Object)packetBuffer.func_150792_a());
            }
            this.totalUsedBlockCount = packetBuffer.func_150792_a();
            this.totalUsedChecksWeakPowerCount = packetBuffer.func_150792_a();
            this.totalUpperSurfaceSlipperiness = packetBuffer.readFloat();
            this.totalLightLevel = packetBuffer.func_150792_a();
        }

        public CompoundNBT serializeNBT() {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_218657_a("primaryState", (INBT)NBTUtil.func_190009_a((BlockState)this.primaryState));
            ListNBT blockStateList = new ListNBT();
            for (Map.Entry<BlockState, Integer> blockStateIntegerEntry : this.countMap.entrySet()) {
                CompoundNBT stateNbt = new CompoundNBT();
                stateNbt.func_218657_a("blockState", (INBT)NBTUtil.func_190009_a((BlockState)blockStateIntegerEntry.getKey()));
                stateNbt.func_74768_a("count", blockStateIntegerEntry.getValue().intValue());
                blockStateList.add((Object)stateNbt);
            }
            ListNBT columnBlockList = new ListNBT();
            for (Map.Entry vector2iIntegerEntry : this.columnBlockedMap.entries()) {
                CompoundNBT columnBlockNbt = new CompoundNBT();
                CompoundNBT coordinateNbt = new CompoundNBT();
                coordinateNbt.func_74768_a("xCoordinate", ((Vector2i)vector2iIntegerEntry.getKey()).getX());
                coordinateNbt.func_74768_a("yCoordinate", ((Vector2i)vector2iIntegerEntry.getKey()).getY());
                columnBlockNbt.func_218657_a("coordinate", (INBT)coordinateNbt);
                columnBlockNbt.func_74768_a("value", ((Integer)vector2iIntegerEntry.getValue()).intValue());
                columnBlockList.add((Object)columnBlockNbt);
            }
            nbt.func_218657_a("blockStates", (INBT)blockStateList);
            nbt.func_218657_a("columnBlockList", (INBT)columnBlockList);
            nbt.func_74768_a("blockCount", this.totalUsedBlockCount);
            nbt.func_74768_a("blockShouldCheckWeakPowerCount", this.totalUsedChecksWeakPowerCount);
            nbt.func_74776_a("totalUpperLevelSlipperiness", this.totalUpperSurfaceSlipperiness);
            nbt.func_74768_a("totalLightLevel", this.totalLightLevel);
            return nbt;
        }

        public void deserializeNBT(CompoundNBT nbt) {
            this.countMap.clear();
            this.primaryState = NBTUtil.func_190008_d((CompoundNBT)nbt.func_74775_l("primaryState"));
            ListNBT blockStateList = nbt.func_150295_c("blockStates", 10);
            for (int i = 0; i < blockStateList.size(); ++i) {
                CompoundNBT stateNbt = blockStateList.func_150305_b(i);
                this.countMap.put(NBTUtil.func_190008_d((CompoundNBT)stateNbt.func_74775_l("blockState")), stateNbt.func_74762_e("count"));
            }
            ListNBT columnBlockList = nbt.func_150295_c("columnBlockList", 10);
            for (int i = 0; i < columnBlockList.size(); ++i) {
                CompoundNBT columnBlockNbt = columnBlockList.func_150305_b(i);
                CompoundNBT coordinateNbt = columnBlockNbt.func_74775_l("coordinate");
                this.columnBlockedMap.put((Object)new Vector2i(coordinateNbt.func_74762_e("xCoordinate"), coordinateNbt.func_74762_e("yCoordinate")), (Object)columnBlockNbt.func_74762_e("value"));
            }
            this.totalUsedBlockCount = nbt.func_74762_e("blockCount");
            this.totalUsedChecksWeakPowerCount = nbt.func_74762_e("blockShouldCheckWeakPowerCount");
            this.totalUpperSurfaceSlipperiness = nbt.func_74760_g("totalUpperLevelSlipperiness");
            this.totalLightLevel = nbt.func_74762_e("totalLightLevel");
        }

        public void initializeWith(BlockState blockState) {
            this.clear();
            boolean isAir = blockState.isAir((IBlockReader)new SingleBlockWorldReader(blockState, this.positionSupplier.get(), (IWorldReader)this.worldReaderSupplier.get()), this.positionSupplier.get());
            this.primaryState = blockState;
            if (!isAir) {
                this.countMap.put(blockState, StateEntrySize.current().getBitsPerBlock());
            }
            int n = this.totalUsedBlockCount = isAir ? 0 : StateEntrySize.current().getBitsPerBlock();
            if (blockState.shouldCheckWeakPower((IWorldReader)new SingleBlockWorldReader(blockState, this.positionSupplier.get(), (IWorldReader)this.worldReaderSupplier.get()), this.positionSupplier.get(), Direction.NORTH)) {
                this.totalUsedChecksWeakPowerCount = StateEntrySize.current().getBitsPerBlock();
            }
            this.totalLightLevel += blockState.getLightValue((IBlockReader)new SingleBlockWorldReader(blockState, this.positionSupplier.get(), (IWorldReader)this.worldReaderSupplier.get()), this.positionSupplier.get()) * StateEntrySize.current().getBitsPerBlock();
            this.totalUpperSurfaceSlipperiness += blockState.getSlipperiness((IWorldReader)new SingleBlockWorldReader(blockState, this.positionSupplier.get(), (IWorldReader)this.worldReaderSupplier.get()), this.positionSupplier.get(), null) * (float)StateEntrySize.current().getBitsPerBlock();
            if (!blockState.func_200131_a((IBlockReader)new SingleBlockWorldReader(blockState, this.positionSupplier.get(), (IWorldReader)this.worldReaderSupplier.get()), this.positionSupplier.get())) {
                BlockPosStreamProvider.getForRange(StateEntrySize.current().getBitsPerBlockSide()).forEach(pos -> this.columnBlockedMap.put((Object)new Vector2i(pos.func_177958_n(), pos.func_177952_p()), (Object)pos.func_177956_o()));
            }
        }

        private void clear() {
            this.primaryState = Blocks.field_150350_a.func_176223_P();
            this.countMap.clear();
            this.columnBlockedMap.clear();
            this.totalUsedBlockCount = 0;
            this.totalUsedChecksWeakPowerCount = 0;
            this.totalUpperSurfaceSlipperiness = 0.0f;
            this.totalLightLevel = 0;
        }

        private void recalculate(ChunkSection source, boolean updateWorld) {
            this.clear();
            source.func_186049_g().func_225497_a(this.countMap::put);
            this.countMap.remove(Blocks.field_150350_a.func_176223_P());
            this.updatePrimaryState(updateWorld);
            this.totalUsedBlockCount = this.countMap.values().stream().mapToInt(i -> i).sum();
            this.countMap.forEach((blockState, count) -> {
                if (blockState.shouldCheckWeakPower((IWorldReader)new SingleBlockWorldReader((BlockState)blockState, this.positionSupplier.get(), (IWorldReader)this.worldReaderSupplier.get()), this.positionSupplier.get(), Direction.NORTH)) {
                    this.totalUsedChecksWeakPowerCount += count.intValue();
                }
                this.totalLightLevel += blockState.getLightValue((IBlockReader)new SingleBlockWorldReader((BlockState)blockState, this.positionSupplier.get(), (IWorldReader)this.worldReaderSupplier.get()), this.positionSupplier.get()) * count;
            });
            BlockPosStreamProvider.getForRange(StateEntrySize.current().getBitsPerBlockSide()).forEach(pos -> {
                BlockState blockState = source.func_177485_a(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                if (pos.func_177956_o() == 15) {
                    this.totalUpperSurfaceSlipperiness += blockState.getSlipperiness((IWorldReader)new SingleBlockWorldReader(blockState, this.positionSupplier.get(), (IWorldReader)this.worldReaderSupplier.get()), this.positionSupplier.get(), null);
                }
                if (!blockState.func_200131_a((IBlockReader)new SingleBlockWorldReader(blockState, this.positionSupplier.get(), (IWorldReader)this.worldReaderSupplier.get()), this.positionSupplier.get())) {
                    this.columnBlockedMap.put((Object)new Vector2i(pos.func_177958_n(), pos.func_177952_p()), (Object)pos.func_177956_o());
                }
            });
        }
    }

    private static final class StateEntry
    implements IInWorldMutableStateEntryInfo {
        private final BlockState state;
        private final IWorld reader;
        private final BlockPos blockPos;
        private final Vector3d startPoint;
        private final Vector3d endPoint;
        private final StateSetter stateSetter;
        private final StateClearer stateClearer;

        public StateEntry(BlockState state, IWorld reader, BlockPos blockPos, Vector3i startPoint, StateSetter stateSetter, StateClearer stateClearer) {
            this(state, reader, blockPos, Vector3d.func_237491_b_((Vector3i)startPoint).func_216372_d((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit()), Vector3d.func_237491_b_((Vector3i)startPoint).func_216372_d((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit()).func_72441_c((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit()), stateSetter, stateClearer);
        }

        private StateEntry(BlockState state, IWorld reader, BlockPos blockPos, Vector3d startPoint, Vector3d endPoint, StateSetter stateSetter, StateClearer stateClearer) {
            this.state = state;
            this.reader = reader;
            this.blockPos = blockPos;
            this.startPoint = startPoint;
            this.endPoint = endPoint;
            this.stateSetter = stateSetter;
            this.stateClearer = stateClearer;
        }

        @Override
        public BlockState getState() {
            return this.state;
        }

        @Override
        public Vector3d getStartPoint() {
            return this.startPoint;
        }

        @Override
        public Vector3d getEndPoint() {
            return this.endPoint;
        }

        @Override
        public void setState(BlockState blockState) throws SpaceOccupiedException {
            this.stateSetter.accept(blockState, this.getStartPoint());
        }

        @Override
        public void clear() {
            this.stateClearer.accept(this.getStartPoint());
        }

        @Override
        public IWorld getWorld() {
            return this.reader;
        }

        @Override
        public BlockPos getBlockPos() {
            return this.blockPos;
        }
    }
}

