/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.change.changes;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import mod.chiselsandbits.api.block.entity.IMultiStateBlockEntity;
import mod.chiselsandbits.api.change.changes.IChange;
import mod.chiselsandbits.api.change.changes.IllegalChangeAttempt;
import mod.chiselsandbits.api.chiseling.conversion.IConversionManager;
import mod.chiselsandbits.api.exceptions.SpaceOccupiedException;
import mod.chiselsandbits.api.inventory.bit.IBitInventory;
import mod.chiselsandbits.api.inventory.management.IBitInventoryManager;
import mod.chiselsandbits.api.item.multistate.IMultiStateItem;
import mod.chiselsandbits.api.multistate.mutator.batched.IBatchMutation;
import mod.chiselsandbits.api.multistate.snapshot.IMultiStateSnapshot;
import mod.chiselsandbits.multistate.snapshot.EmptySnapshot;
import mod.chiselsandbits.utils.BitInventoryUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import org.apache.commons.lang3.Validate;

public class BitChange
implements IChange {
    private BlockPos blockPos;
    private IMultiStateSnapshot before;
    private IMultiStateSnapshot after;

    public BitChange(BlockPos blockPos, IMultiStateSnapshot before, IMultiStateSnapshot after) {
        this.blockPos = blockPos;
        this.before = before;
        this.after = after;
    }

    public BitChange(INBT tag) {
        Validate.isInstanceOf(CompoundNBT.class, (Object)tag);
        this.deserializeNBT((CompoundNBT)tag);
    }

    @Override
    public boolean canUndo(PlayerEntity player) {
        TileEntity tileEntity = player.field_70170_p.func_175625_s(this.blockPos);
        if (!(tileEntity instanceof IMultiStateBlockEntity)) {
            BlockState currentState = player.field_70170_p.func_180495_p(this.blockPos);
            return this.after.getStatics().getStateCounts().size() == 1 && this.after.getStatics().getStateCounts().getOrDefault(currentState, 0) == 4096;
        }
        IMultiStateBlockEntity multiStateBlockEntity = (IMultiStateBlockEntity)tileEntity;
        return this.after.createNewShapeIdentifier().equals(multiStateBlockEntity.createNewShapeIdentifier()) && this.hasRequiredUndoBits(player);
    }

    @Override
    public boolean canRedo(PlayerEntity player) {
        TileEntity tileEntity = player.field_70170_p.func_175625_s(this.blockPos);
        if (!(tileEntity instanceof IMultiStateBlockEntity)) {
            BlockState currentState = player.field_70170_p.func_180495_p(this.blockPos);
            return this.before.getStatics().getStateCounts().size() == 1 && this.before.getStatics().getStateCounts().getOrDefault(currentState, 0) == 4096;
        }
        IMultiStateBlockEntity multiStateBlockEntity = (IMultiStateBlockEntity)tileEntity;
        return this.before.createNewShapeIdentifier().equals(multiStateBlockEntity.createNewShapeIdentifier()) && this.hasRequiredRedoBits(player);
    }

    @Override
    public void undo(PlayerEntity player) throws IllegalChangeAttempt {
        if (!this.canUndo(player)) {
            throw new IllegalChangeAttempt();
        }
        TileEntity tileEntity = player.field_70170_p.func_175625_s(this.blockPos);
        if (!(tileEntity instanceof IMultiStateBlockEntity)) {
            BlockState currentState;
            BlockState initializationState = currentState = player.field_70170_p.func_180495_p(this.blockPos);
            Optional<Block> convertedState = IConversionManager.getInstance().getChiseledVariantOf(currentState);
            if (!convertedState.isPresent()) {
                throw new IllegalChangeAttempt();
            }
            player.field_70170_p.func_180501_a(this.blockPos, convertedState.get().func_176223_P(), 3);
            tileEntity = player.field_70170_p.func_175625_s(this.blockPos);
            if (!(tileEntity instanceof IMultiStateBlockEntity)) {
                throw new IllegalChangeAttempt();
            }
        }
        IMultiStateBlockEntity multiStateBlockEntity = (IMultiStateBlockEntity)tileEntity;
        Map<BlockState, Integer> afterStates = this.after.getStatics().getStateCounts();
        Map<BlockState, Integer> beforeStates = this.before.getStatics().getStateCounts();
        HashMap difference = Maps.newHashMap();
        beforeStates.forEach((state, count) -> difference.put(state, afterStates.getOrDefault(state, 0) - count));
        afterStates.forEach((state, count) -> {
            if (!difference.containsKey(state)) {
                difference.put(state, count);
            }
        });
        try (IBatchMutation batch = multiStateBlockEntity.batch();){
            multiStateBlockEntity.initializeWith(Blocks.field_150350_a.func_176223_P());
            this.before.stream().forEach(iStateEntryInfo -> {
                try {
                    multiStateBlockEntity.setInAreaTarget(iStateEntryInfo.getState(), iStateEntryInfo.getStartPoint());
                }
                catch (SpaceOccupiedException spaceOccupiedException) {
                    // empty catch block
                }
            });
        }
        if (!player.func_184812_l_()) {
            IBitInventory bitInventory = IBitInventoryManager.getInstance().create(player);
            difference.forEach((state, diff) -> {
                if (state.func_196958_f()) {
                    return;
                }
                if (diff < 0) {
                    bitInventory.extract((BlockState)state, -diff.intValue());
                } else {
                    BitInventoryUtils.insertIntoOrSpawn(player, state, diff);
                }
            });
        }
    }

    @Override
    public void redo(PlayerEntity player) throws IllegalChangeAttempt {
        if (!this.canRedo(player)) {
            throw new IllegalChangeAttempt();
        }
        TileEntity tileEntity = player.field_70170_p.func_175625_s(this.blockPos);
        if (!(tileEntity instanceof IMultiStateBlockEntity)) {
            Optional<Block> convertedState;
            BlockState currentState;
            BlockState initializationState = currentState = player.field_70170_p.func_180495_p(this.blockPos);
            if (currentState.func_196958_f()) {
                currentState = Blocks.field_150348_b.func_176223_P();
            }
            if (!(convertedState = IConversionManager.getInstance().getChiseledVariantOf(currentState)).isPresent()) {
                throw new IllegalChangeAttempt();
            }
            player.field_70170_p.func_180501_a(this.blockPos, convertedState.get().func_176223_P(), 3);
            tileEntity = player.field_70170_p.func_175625_s(this.blockPos);
            if (!(tileEntity instanceof IMultiStateBlockEntity)) {
                throw new IllegalChangeAttempt();
            }
        }
        IMultiStateBlockEntity multiStateBlockEntity = (IMultiStateBlockEntity)tileEntity;
        Map<BlockState, Integer> afterStates = this.after.getStatics().getStateCounts();
        Map<BlockState, Integer> beforeStates = this.before.getStatics().getStateCounts();
        HashMap difference = Maps.newHashMap();
        beforeStates.forEach((state, count) -> difference.put(state, count - afterStates.getOrDefault(state, 0)));
        afterStates.forEach((state, count) -> {
            if (!difference.containsKey(state)) {
                difference.put(state, -count.intValue());
            }
        });
        try (IBatchMutation batch = multiStateBlockEntity.batch();){
            multiStateBlockEntity.initializeWith(Blocks.field_150350_a.func_176223_P());
            this.after.stream().forEach(s -> {
                try {
                    multiStateBlockEntity.setInAreaTarget(s.getState(), s.getStartPoint());
                }
                catch (SpaceOccupiedException spaceOccupiedException) {
                    // empty catch block
                }
            });
        }
        if (!player.func_184812_l_()) {
            IBitInventory bitInventory = IBitInventoryManager.getInstance().create(player);
            difference.forEach((state, diff) -> {
                if (diff < 0) {
                    bitInventory.extract((BlockState)state, -diff.intValue());
                } else {
                    BitInventoryUtils.insertIntoOrSpawn(player, state, diff);
                }
            });
        }
    }

    private boolean hasRequiredUndoBits(PlayerEntity player) {
        if (player.func_184812_l_()) {
            return true;
        }
        Map<BlockState, Integer> afterStates = this.after.getStatics().getStateCounts();
        Map<BlockState, Integer> beforeStates = this.before.getStatics().getStateCounts();
        HashMap difference = Maps.newHashMap();
        beforeStates.forEach((state, count) -> difference.put(state, afterStates.getOrDefault(state, 0) - count));
        afterStates.forEach((state, count) -> {
            if (!difference.containsKey(state)) {
                difference.put(state, count);
            }
        });
        IBitInventory bitInventory = IBitInventoryManager.getInstance().create(player);
        return difference.entrySet().stream().filter(e -> (Integer)e.getValue() < 0).allMatch(e -> bitInventory.canExtract((BlockState)e.getKey(), -((Integer)e.getValue()).intValue()));
    }

    private boolean hasRequiredRedoBits(PlayerEntity player) {
        if (player.func_184812_l_()) {
            return true;
        }
        Map<BlockState, Integer> afterStates = this.after.getStatics().getStateCounts();
        Map<BlockState, Integer> beforeStates = this.before.getStatics().getStateCounts();
        HashMap difference = Maps.newHashMap();
        beforeStates.forEach((state, count) -> difference.put(state, count - afterStates.getOrDefault(state, 0)));
        afterStates.forEach((state, count) -> {
            if (!difference.containsKey(state)) {
                difference.put(state, -count.intValue());
            }
        });
        IBitInventory bitInventory = IBitInventoryManager.getInstance().create(player);
        return difference.entrySet().stream().filter(e -> (Integer)e.getValue() < 0).allMatch(e -> bitInventory.canExtract((BlockState)e.getKey(), -((Integer)e.getValue()).intValue()));
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_218657_a("pos", (INBT)NBTUtil.func_186859_a((BlockPos)this.blockPos));
        tag.func_218657_a("before", (INBT)this.before.toItemStack().toBlockStack().serializeNBT());
        tag.func_218657_a("after", (INBT)this.after.toItemStack().toBlockStack().serializeNBT());
        return tag;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.blockPos = NBTUtil.func_186861_c((CompoundNBT)nbt.func_74775_l("pos"));
        this.before = BitChange.deserializeSnapshot(nbt.func_74775_l("before"));
        this.after = BitChange.deserializeSnapshot(nbt.func_74775_l("after"));
    }

    private static IMultiStateSnapshot deserializeSnapshot(CompoundNBT nbt) {
        ItemStack stack = ItemStack.func_199557_a((CompoundNBT)nbt);
        if (stack.func_190926_b()) {
            return EmptySnapshot.INSTANCE;
        }
        if (!(stack.func_77973_b() instanceof IMultiStateItem)) {
            return EmptySnapshot.INSTANCE;
        }
        return ((IMultiStateItem)stack.func_77973_b()).createItemStack(stack).createSnapshot();
    }
}

