/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.chiseling.modes.plane;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import mod.chiselsandbits.api.change.IChangeTrackerManager;
import mod.chiselsandbits.api.chiseling.IChiselingContext;
import mod.chiselsandbits.api.chiseling.mode.IChiselMode;
import mod.chiselsandbits.api.inventory.bit.IBitInventory;
import mod.chiselsandbits.api.inventory.management.IBitInventoryManager;
import mod.chiselsandbits.api.item.click.ClickProcessingState;
import mod.chiselsandbits.api.item.withmode.group.IToolModeGroup;
import mod.chiselsandbits.api.multistate.StateEntrySize;
import mod.chiselsandbits.api.multistate.accessor.IAreaAccessor;
import mod.chiselsandbits.api.multistate.accessor.IStateEntryInfo;
import mod.chiselsandbits.api.multistate.mutator.IMutatorFactory;
import mod.chiselsandbits.api.multistate.mutator.batched.IBatchMutation;
import mod.chiselsandbits.api.multistate.mutator.world.IWorldAreaMutator;
import mod.chiselsandbits.api.util.RayTracingUtils;
import mod.chiselsandbits.api.util.SingleBlockBlockReader;
import mod.chiselsandbits.registrars.ModChiselModeGroups;
import mod.chiselsandbits.utils.BitInventoryUtils;
import mod.chiselsandbits.utils.ItemStackUtils;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;

public class PlaneChiseledMode
extends ForgeRegistryEntry<IChiselMode>
implements IChiselMode {
    private final int depth;
    private final IFormattableTextComponent displayName;
    private final ResourceLocation iconName;
    private final boolean filterOnTarget;

    PlaneChiseledMode(int depth, IFormattableTextComponent displayName, ResourceLocation iconName, boolean filterOnTarget) {
        this.depth = depth;
        this.displayName = displayName;
        this.iconName = iconName;
        this.filterOnTarget = filterOnTarget;
    }

    @Override
    public ClickProcessingState onLeftClickBy(PlayerEntity playerEntity, IChiselingContext context) {
        Optional<ClickProcessingState> rayTraceHandle = this.processRayTraceIntoContext(playerEntity, context, face -> Vector3d.func_237491_b_((Vector3i)face.func_176734_d().func_176730_m()), Direction::func_176734_d);
        if (context.isSimulation()) {
            return ClickProcessingState.DEFAULT;
        }
        return rayTraceHandle.orElseGet(() -> context.getMutator().map(mutator -> {
            try (IBatchMutation ignored = mutator.batch(IChangeTrackerManager.getInstance().getChangeTracker(playerEntity));){
                context.setComplete();
                HashMap resultingBitCount = Maps.newHashMap();
                Predicate<IStateEntryInfo> filter = context.getStateFilter().map(builder -> (Predicate)builder.apply(mutator)).orElse(state -> true);
                mutator.inWorldMutableStream().filter(filter).forEach(state -> {
                    BlockState currentState = state.getState();
                    if (context.tryDamageItem()) {
                        resultingBitCount.putIfAbsent(currentState, 0);
                        resultingBitCount.computeIfPresent(currentState, (s, currentCount) -> currentCount + 1);
                        state.clear();
                    }
                });
                resultingBitCount.forEach((blockState, count) -> BitInventoryUtils.insertIntoOrSpawn(playerEntity, blockState, count));
            }
            return new ClickProcessingState(true, Event.Result.ALLOW);
        }).orElse(ClickProcessingState.DEFAULT));
    }

    @Override
    public void onStoppedLeftClicking(PlayerEntity playerEntity, IChiselingContext context) {
    }

    @Override
    public ClickProcessingState onRightClickBy(PlayerEntity playerEntity, IChiselingContext context) {
        Optional<ClickProcessingState> rayTraceHandle = this.processRayTraceIntoContext(playerEntity, context, face -> Vector3d.func_237491_b_((Vector3i)face.func_176730_m()), Function.identity());
        if (context.isSimulation()) {
            return ClickProcessingState.DEFAULT;
        }
        return rayTraceHandle.orElseGet(() -> context.getMutator().map(mutator -> {
            BlockState heldBlockState = ItemStackUtils.getHeldBitBlockStateFromPlayer(playerEntity);
            if (heldBlockState.isAir((IBlockReader)new SingleBlockBlockReader(heldBlockState), BlockPos.field_177992_a)) {
                return ClickProcessingState.DEFAULT;
            }
            int missingBitCount = (int)mutator.stream().filter(state -> state.getState().isAir((IBlockReader)new SingleBlockBlockReader(state.getState()), BlockPos.field_177992_a)).count();
            IBitInventory playerBitInventory = IBitInventoryManager.getInstance().create(playerEntity);
            context.setComplete();
            if (playerBitInventory.canExtract(heldBlockState, missingBitCount) || playerEntity.func_184812_l_()) {
                if (!playerEntity.func_184812_l_()) {
                    playerBitInventory.extract(heldBlockState, missingBitCount);
                }
                try (IBatchMutation ignored = mutator.batch(IChangeTrackerManager.getInstance().getChangeTracker(playerEntity));){
                    mutator.inWorldMutableStream().filter(state -> state.getState().isAir((IBlockReader)new SingleBlockBlockReader(state.getState()), BlockPos.field_177992_a)).forEach(state -> state.overrideState(heldBlockState));
                }
            }
            return new ClickProcessingState(true, Event.Result.ALLOW);
        }).orElse(ClickProcessingState.DEFAULT));
    }

    @Override
    public void onStoppedRightClicking(PlayerEntity playerEntity, IChiselingContext context) {
    }

    @Override
    public Optional<IAreaAccessor> getCurrentAccessor(IChiselingContext context) {
        return context.getMutator().map(mutator -> mutator);
    }

    private Optional<ClickProcessingState> processRayTraceIntoContext(PlayerEntity playerEntity, IChiselingContext context, Function<Direction, Vector3d> placementFacingAdapter, Function<Direction, Direction> iterationAdaptor) {
        RayTraceResult rayTraceResult = RayTracingUtils.rayTracePlayer(playerEntity);
        if (rayTraceResult.func_216346_c() != RayTraceResult.Type.BLOCK || !(rayTraceResult instanceof BlockRayTraceResult)) {
            return Optional.of(ClickProcessingState.DEFAULT);
        }
        BlockRayTraceResult blockRayTraceResult = (BlockRayTraceResult)rayTraceResult;
        Vector3d hitVector = blockRayTraceResult.func_216347_e().func_178787_e(placementFacingAdapter.apply(blockRayTraceResult.func_216354_b()).func_216372_d((double)StateEntrySize.current().getSizePerHalfBit(), (double)StateEntrySize.current().getSizePerHalfBit(), (double)StateEntrySize.current().getSizePerHalfBit()));
        Vector3d hitBlockPosVector = Vector3d.func_237491_b_((Vector3i)new BlockPos(hitVector));
        Vector3d inBlockHitVector = hitVector.func_178788_d(hitBlockPosVector);
        Vector3d inBlockBitVector = inBlockHitVector.func_216372_d((double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide());
        if (context.getWorld() != null && this.filterOnTarget) {
            IWorldAreaMutator worldAreaAccessor = IMutatorFactory.getInstance().in(context.getWorld(), new BlockPos(hitBlockPosVector));
            BlockState filterState = worldAreaAccessor.getInAreaTarget(inBlockHitVector).map(IStateEntryInfo::getState).orElse(Blocks.field_150350_a.func_176223_P());
            context.setStateFilter(areaAccessor -> new BlockStateAreaFilter(filterState));
        }
        Direction iterationDirection = iterationAdaptor.apply(blockRayTraceResult.func_216354_b());
        switch (iterationDirection) {
            case DOWN: {
                this.includeDownAxis(context, hitBlockPosVector, inBlockBitVector);
                break;
            }
            case UP: {
                this.includeUpAxis(context, hitBlockPosVector, inBlockBitVector);
                break;
            }
            case NORTH: {
                this.includeNorthAxis(context, hitBlockPosVector, inBlockBitVector);
                break;
            }
            case SOUTH: {
                this.includeSouthAxis(context, hitBlockPosVector, inBlockBitVector);
                break;
            }
            case WEST: {
                this.includeWestAxis(context, hitBlockPosVector, inBlockBitVector);
                break;
            }
            case EAST: {
                this.includeEastAxis(context, hitBlockPosVector, inBlockBitVector);
            }
        }
        return Optional.empty();
    }

    private void includeDownAxis(IChiselingContext context, Vector3d hitBlockPosVector, Vector3d inBlockBitVector) {
        BlockPos position = new BlockPos(hitBlockPosVector);
        context.include(position, this.clampVectorToBlock(new Vector3d(0.0, inBlockBitVector.func_82617_b() - (double)this.depth, 0.0).func_178787_e(Vector3d.func_237491_b_((Vector3i)Direction.UP.func_176730_m())).func_216372_d((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())));
        context.include(position, this.clampVectorToBlock(new Vector3d(15.5, inBlockBitVector.func_82617_b() - (double)this.depth, 15.5).func_178787_e(Vector3d.func_237491_b_((Vector3i)Direction.UP.func_176730_m())).func_216372_d((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())));
        context.include(position, this.clampVectorToBlock(new Vector3d(0.0, inBlockBitVector.func_82617_b() - 0.5, 0.0).func_178787_e(Vector3d.func_237491_b_((Vector3i)Direction.UP.func_176730_m())).func_216372_d((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())));
        context.include(position, this.clampVectorToBlock(new Vector3d(15.5, inBlockBitVector.func_82617_b() - 0.5, 15.5).func_178787_e(Vector3d.func_237491_b_((Vector3i)Direction.UP.func_176730_m())).func_216372_d((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())));
    }

    private void includeUpAxis(IChiselingContext context, Vector3d hitBlockPosVector, Vector3d inBlockBitVector) {
        BlockPos position = new BlockPos(hitBlockPosVector);
        context.include(position, this.clampVectorToBlock(new Vector3d(0.0, inBlockBitVector.func_82617_b() + (double)this.depth, 0.0).func_178787_e(Vector3d.func_237491_b_((Vector3i)Direction.DOWN.func_176730_m())).func_216372_d((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())));
        context.include(position, this.clampVectorToBlock(new Vector3d(15.5, inBlockBitVector.func_82617_b() + (double)this.depth, 15.5).func_178787_e(Vector3d.func_237491_b_((Vector3i)Direction.DOWN.func_176730_m())).func_216372_d((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())));
        context.include(position, this.clampVectorToBlock(new Vector3d(0.0, inBlockBitVector.func_82617_b() + 0.5, 0.0).func_178787_e(Vector3d.func_237491_b_((Vector3i)Direction.DOWN.func_176730_m())).func_216372_d((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())));
        context.include(position, this.clampVectorToBlock(new Vector3d(15.5, inBlockBitVector.func_82617_b() + 0.5, 15.5).func_178787_e(Vector3d.func_237491_b_((Vector3i)Direction.DOWN.func_176730_m())).func_216372_d((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())));
    }

    private void includeNorthAxis(IChiselingContext context, Vector3d hitBlockPosVector, Vector3d inBlockBitVector) {
        BlockPos position = new BlockPos(hitBlockPosVector);
        context.include(position, this.clampVectorToBlock(new Vector3d(0.0, 0.0, inBlockBitVector.func_82616_c() - (double)this.depth).func_178787_e(Vector3d.func_237491_b_((Vector3i)Direction.SOUTH.func_176730_m())).func_216372_d((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())));
        context.include(position, this.clampVectorToBlock(new Vector3d(15.5, 15.5, inBlockBitVector.func_82616_c() - (double)this.depth).func_178787_e(Vector3d.func_237491_b_((Vector3i)Direction.SOUTH.func_176730_m())).func_216372_d((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())));
        context.include(position, this.clampVectorToBlock(new Vector3d(0.0, 0.0, inBlockBitVector.func_82616_c() - 0.5).func_178787_e(Vector3d.func_237491_b_((Vector3i)Direction.SOUTH.func_176730_m())).func_216372_d((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())));
        context.include(position, this.clampVectorToBlock(new Vector3d(15.5, 15.5, inBlockBitVector.func_82616_c() - 0.5).func_178787_e(Vector3d.func_237491_b_((Vector3i)Direction.SOUTH.func_176730_m())).func_216372_d((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())));
    }

    private void includeSouthAxis(IChiselingContext context, Vector3d hitBlockPosVector, Vector3d inBlockBitVector) {
        BlockPos position = new BlockPos(hitBlockPosVector);
        context.include(position, this.clampVectorToBlock(new Vector3d(0.0, 0.0, inBlockBitVector.func_82616_c() + (double)this.depth).func_178787_e(Vector3d.func_237491_b_((Vector3i)Direction.NORTH.func_176730_m())).func_216372_d((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())));
        context.include(position, this.clampVectorToBlock(new Vector3d(15.5, 15.5, inBlockBitVector.func_82616_c() + (double)this.depth).func_178787_e(Vector3d.func_237491_b_((Vector3i)Direction.NORTH.func_176730_m())).func_216372_d((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())));
        context.include(position, this.clampVectorToBlock(new Vector3d(0.0, 0.0, inBlockBitVector.func_82616_c() + 0.5).func_178787_e(Vector3d.func_237491_b_((Vector3i)Direction.NORTH.func_176730_m())).func_216372_d((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())));
        context.include(position, this.clampVectorToBlock(new Vector3d(15.5, 15.5, inBlockBitVector.func_82616_c() + 0.5).func_178787_e(Vector3d.func_237491_b_((Vector3i)Direction.NORTH.func_176730_m())).func_216372_d((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())));
    }

    private void includeWestAxis(IChiselingContext context, Vector3d hitBlockPosVector, Vector3d inBlockBitVector) {
        BlockPos position = new BlockPos(hitBlockPosVector);
        context.include(position, this.clampVectorToBlock(new Vector3d(inBlockBitVector.func_82615_a() - (double)this.depth, 0.0, 0.0).func_178787_e(Vector3d.func_237491_b_((Vector3i)Direction.EAST.func_176730_m())).func_216372_d((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())));
        context.include(position, this.clampVectorToBlock(new Vector3d(inBlockBitVector.func_82615_a() - (double)this.depth, 15.5, 15.5).func_178787_e(Vector3d.func_237491_b_((Vector3i)Direction.EAST.func_176730_m())).func_216372_d((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())));
        context.include(position, this.clampVectorToBlock(new Vector3d(inBlockBitVector.func_82615_a() - 0.5, 0.0, 0.0).func_178787_e(Vector3d.func_237491_b_((Vector3i)Direction.EAST.func_176730_m())).func_216372_d((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())));
        context.include(position, this.clampVectorToBlock(new Vector3d(inBlockBitVector.func_82615_a() - 0.5, 15.5, 15.5).func_178787_e(Vector3d.func_237491_b_((Vector3i)Direction.EAST.func_176730_m())).func_216372_d((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())));
    }

    private void includeEastAxis(IChiselingContext context, Vector3d hitBlockPosVector, Vector3d inBlockBitVector) {
        BlockPos position = new BlockPos(hitBlockPosVector);
        context.include(position, this.clampVectorToBlock(new Vector3d(inBlockBitVector.func_82615_a() + (double)this.depth, 0.0, 0.0).func_178787_e(Vector3d.func_237491_b_((Vector3i)Direction.WEST.func_176730_m())).func_216372_d((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())));
        context.include(position, this.clampVectorToBlock(new Vector3d(inBlockBitVector.func_82615_a() + (double)this.depth, 15.5, 15.5).func_178787_e(Vector3d.func_237491_b_((Vector3i)Direction.WEST.func_176730_m())).func_216372_d((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())));
        context.include(position, this.clampVectorToBlock(new Vector3d(inBlockBitVector.func_82615_a() + 0.5, 0.0, 0.0).func_178787_e(Vector3d.func_237491_b_((Vector3i)Direction.WEST.func_176730_m())).func_216372_d((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())));
        context.include(position, this.clampVectorToBlock(new Vector3d(inBlockBitVector.func_82615_a() + 0.5, 15.5, 15.5).func_178787_e(Vector3d.func_237491_b_((Vector3i)Direction.WEST.func_176730_m())).func_216372_d((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())));
    }

    private Vector3d clampVectorToBlock(Vector3d v) {
        return new Vector3d(v.func_82615_a() < 0.0 ? 0.0 : (v.func_82615_a() >= 1.0 ? (double)0.999f : v.func_82615_a()), v.func_82617_b() < 0.0 ? 0.0 : (v.func_82617_b() >= 1.0 ? (double)0.999f : v.func_82617_b()), v.func_82616_c() < 0.0 ? 0.0 : (v.func_82616_c() >= 1.0 ? (double)0.999f : v.func_82616_c()));
    }

    @Override
    @NotNull
    public ResourceLocation getIcon() {
        return this.iconName;
    }

    @Override
    public ITextComponent getDisplayName() {
        return this.displayName;
    }

    @Override
    @NotNull
    public Optional<IToolModeGroup> getGroup() {
        return Optional.of(this.filterOnTarget ? ModChiselModeGroups.PLANE_FILTERED : ModChiselModeGroups.PLANE);
    }

    private final class BlockStateAreaFilter
    implements Predicate<IStateEntryInfo> {
        private final BlockState targetState;
        private final int stateHash;

        private BlockStateAreaFilter(BlockState targetState) {
            this.targetState = targetState;
            this.stateHash = targetState.hashCode();
        }

        @Override
        public boolean test(IStateEntryInfo stateEntryInfo) {
            return this.stateHash == stateEntryInfo.getState().hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BlockStateAreaFilter)) {
                return false;
            }
            BlockStateAreaFilter that = (BlockStateAreaFilter)o;
            return this.targetState.equals(that.targetState);
        }

        public int hashCode() {
            return this.stateHash;
        }
    }
}

