/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.model.baked.chiseled;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import mod.chiselsandbits.api.multistate.StateEntrySize;
import mod.chiselsandbits.api.multistate.accessor.IAreaAccessor;
import mod.chiselsandbits.api.multistate.accessor.IStateEntryInfo;
import mod.chiselsandbits.api.multistate.accessor.sortable.IPositionMutator;
import mod.chiselsandbits.api.util.SingleBlockBlockReader;
import mod.chiselsandbits.client.culling.ICullTest;
import mod.chiselsandbits.client.model.baked.base.BaseBakedBlockModel;
import mod.chiselsandbits.client.model.baked.chiseled.ChiselRenderType;
import mod.chiselsandbits.client.model.baked.chiseled.ChiseledBlockModelBuilder;
import mod.chiselsandbits.client.model.baked.face.ChiselsAndBitsBakedQuad;
import mod.chiselsandbits.client.model.baked.face.FaceManager;
import mod.chiselsandbits.client.model.baked.face.FaceRegion;
import mod.chiselsandbits.client.model.baked.face.IFaceBuilder;
import mod.chiselsandbits.client.model.baked.face.model.ModelQuadLayer;
import mod.chiselsandbits.utils.ModelUtil;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockFaceUV;
import net.minecraft.client.renderer.model.BlockPartFace;
import net.minecraft.client.renderer.model.FaceBakery;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.client.model.data.IModelData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChiseledBlockBakedModel
extends BaseBakedBlockModel {
    public static final ChiseledBlockBakedModel EMPTY = new ChiseledBlockBakedModel(Blocks.field_150350_a.func_176223_P(), ChiselRenderType.SOLID, null, vector3d -> Blocks.field_150350_a.func_176223_P(), 0L);
    private static final int[][] faceVertMap = new int[6][4];
    private static final float[][][] quadMapping = new float[6][4][6];
    private static final Direction[] X_Faces = new Direction[]{Direction.EAST, Direction.WEST};
    private static final Direction[] Y_Faces = new Direction[]{Direction.UP, Direction.DOWN};
    private static final Direction[] Z_Faces = new Direction[]{Direction.SOUTH, Direction.NORTH};
    private final ChiselRenderType chiselRenderType;
    private BakedQuad[] up;
    private BakedQuad[] down;
    private BakedQuad[] north;
    private BakedQuad[] south;
    private BakedQuad[] east;
    private BakedQuad[] west;
    private BakedQuad[] generic;

    private List<BakedQuad> getList(Direction side) {
        if (side != null) {
            switch (side) {
                case DOWN: {
                    return this.asList(this.down);
                }
                case EAST: {
                    return this.asList(this.east);
                }
                case NORTH: {
                    return this.asList(this.north);
                }
                case SOUTH: {
                    return this.asList(this.south);
                }
                case UP: {
                    return this.asList(this.up);
                }
                case WEST: {
                    return this.asList(this.west);
                }
            }
        }
        return this.asList(this.generic);
    }

    private List<BakedQuad> asList(BakedQuad[] array) {
        if (array == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(array);
    }

    public ChiseledBlockBakedModel(BlockState state, ChiselRenderType layer, IAreaAccessor data, Function<Vector3d, BlockState> neighborStateSupplier, long primaryStateRenderSeed) {
        this.chiselRenderType = layer;
        IBakedModel originalModel = null;
        if (state != null && state.func_177230_c() != Blocks.field_150350_a) {
            originalModel = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b(state);
        }
        if (originalModel != null && data != null && layer.isRequiredForRendering(data)) {
            ChiseledBlockModelBuilder builder = new ChiseledBlockModelBuilder();
            this.generateFaces(builder, data, neighborStateSupplier, primaryStateRenderSeed);
            this.up = builder.getSide(Direction.UP);
            this.down = builder.getSide(Direction.DOWN);
            this.east = builder.getSide(Direction.EAST);
            this.west = builder.getSide(Direction.WEST);
            this.north = builder.getSide(Direction.NORTH);
            this.south = builder.getSide(Direction.SOUTH);
            this.generic = builder.getSide(null);
        }
    }

    public boolean isEmpty() {
        boolean trulyEmpty = this.getList(null).isEmpty();
        for (Direction e : Direction.values()) {
            trulyEmpty = trulyEmpty && this.getList(e).isEmpty();
        }
        return trulyEmpty;
    }

    IFaceBuilder getBuilder() {
        return new ChiselsAndBitsBakedQuad.Builder(DefaultVertexFormats.field_176600_a);
    }

    private void generateFaces(ChiseledBlockModelBuilder builder, IAreaAccessor accessor, Function<Vector3d, BlockState> neighborStateSupplier, long primaryStateRenderSeed) {
        ArrayList<List<FaceRegion>> resultingFaces = new ArrayList<List<FaceRegion>>();
        this.processFaces(accessor, resultingFaces, IPositionMutator.xzy(), X_Faces, Vector3d::func_82615_a, Vector3d::func_82616_c, neighborStateSupplier);
        this.processFaces(accessor, resultingFaces, IPositionMutator.zxy(), Y_Faces, Vector3d::func_82617_b, Vector3d::func_82616_c, neighborStateSupplier);
        this.processFaces(accessor, resultingFaces, IPositionMutator.zyx(), Z_Faces, Vector3d::func_82616_c, Vector3d::func_82617_b, neighborStateSupplier);
        double[] to = new double[3];
        double[] from = new double[3];
        float[] uvs = new float[8];
        float[] pos = new float[3];
        IFaceBuilder faceBuilder = this.getBuilder();
        for (List list : resultingFaces) {
            this.mergeFaces(list);
            for (FaceRegion region : list) {
                Direction myFace = region.getFace();
                ChiseledBlockBakedModel.offsetVec(to, region.getMaxX(), region.getMaxY(), region.getMaxZ());
                ChiseledBlockBakedModel.offsetVec(from, region.getMinX(), region.getMinY(), region.getMinZ());
                ModelQuadLayer[] mpc = FaceManager.getInstance().getCachedFace(region.getBlockState(), myFace, this.chiselRenderType.layer, primaryStateRenderSeed);
                if (mpc == null) continue;
                for (ModelQuadLayer pc : mpc) {
                    VertexFormat builderFormat = faceBuilder.getFormat();
                    faceBuilder.begin();
                    faceBuilder.setFace(myFace, pc.getTint());
                    float maxLightmap = 4.882887E-4f;
                    this.getFaceUvs(uvs, myFace, from, to, pc.getUvs());
                    for (int vertNum = 0; vertNum < 4; ++vertNum) {
                        block10: for (int elementIndex = 0; elementIndex < builderFormat.func_227894_c_().size(); ++elementIndex) {
                            VertexFormatElement element = (VertexFormatElement)builderFormat.func_227894_c_().get(elementIndex);
                            switch (element.func_177375_c()) {
                                case POSITION: {
                                    this.getVertexPos(pos, myFace, vertNum, to, from);
                                    faceBuilder.put(elementIndex, pos[0], pos[1], pos[2]);
                                    continue block10;
                                }
                                case COLOR: {
                                    int cb = pc.getColor();
                                    faceBuilder.put(elementIndex, this.byteToFloat(cb >> 16), this.byteToFloat(cb >> 8), this.byteToFloat(cb), this.NotZero(this.byteToFloat(cb >> 24)));
                                    continue block10;
                                }
                                case NORMAL: {
                                    float normalShift = 0.999f;
                                    faceBuilder.put(elementIndex, 0.999f * (float)myFace.func_82601_c(), 0.999f * (float)myFace.func_96559_d(), 0.999f * (float)myFace.func_82599_e());
                                    continue block10;
                                }
                                case UV: {
                                    if (element.func_177369_e() == 2) {
                                        float v = 4.882887E-4f * (float)Math.max(0, Math.min(15, pc.getLight()));
                                        faceBuilder.put(elementIndex, v, v);
                                        continue block10;
                                    }
                                    float u = uvs[faceVertMap[myFace.func_176745_a()][vertNum] * 2];
                                    float v = uvs[faceVertMap[myFace.func_176745_a()][vertNum] * 2 + 1];
                                    faceBuilder.put(elementIndex, pc.getSprite().func_94214_a((double)u), pc.getSprite().func_94207_b((double)v));
                                    continue block10;
                                }
                                default: {
                                    faceBuilder.put(elementIndex, new float[0]);
                                }
                            }
                        }
                    }
                    if (region.isEdge()) {
                        builder.getList(myFace).add(faceBuilder.create(pc.getSprite()));
                        continue;
                    }
                    builder.getList(null).add(faceBuilder.create(pc.getSprite()));
                }
            }
        }
    }

    private float NotZero(float byteToFloat) {
        if (byteToFloat < 1.0E-5f) {
            return 1.0f;
        }
        return byteToFloat;
    }

    private float byteToFloat(int i) {
        return (float)(i & 0xFF) / 255.0f;
    }

    private void mergeFaces(List<FaceRegion> src) {
        boolean restart;
        block0: do {
            restart = false;
            int size = src.size();
            int sizeMinusOne = size - 1;
            for (int x = 0; x < sizeMinusOne; ++x) {
                FaceRegion faceA = src.get(x);
                for (int y = x + 1; y < size; ++y) {
                    FaceRegion faceB = src.get(y);
                    if (!faceA.extend(faceB)) continue;
                    src.set(y, src.get(sizeMinusOne));
                    src.remove(sizeMinusOne);
                    restart = true;
                    continue block0;
                }
            }
        } while (restart);
    }

    private void processFaces(IAreaAccessor accessor, List<List<FaceRegion>> resultingRegions, IPositionMutator analysisOrder, Direction[] potentialDirections, Function<Vector3d, Double> regionBuildingAxisValueExtractor, Function<Vector3d, Double> faceBuildingAxisValueExtractor, Function<Vector3d, BlockState> neighborStateSupplier) {
        ArrayList regions = Lists.newArrayList();
        ICullTest test = this.chiselRenderType.getTest();
        for (Direction facing : potentialDirections) {
            FaceBuildingState state = new FaceBuildingState();
            accessor.streamWithPositionMutator(analysisOrder).filter(this.chiselRenderType::isRequiredForRendering).forEach(stateEntryInfo -> {
                if (state.getRegionBuildingAxisValue() != ((Double)regionBuildingAxisValueExtractor.apply(stateEntryInfo.getStartPoint())).doubleValue()) {
                    if (!regions.isEmpty()) {
                        resultingRegions.add(Lists.newArrayList((Iterable)regions));
                    }
                    regions.clear();
                    state.setCurrentRegion(null);
                }
                state.setRegionBuildingAxisValue((Double)regionBuildingAxisValueExtractor.apply(stateEntryInfo.getStartPoint()));
                if (state.getFaceBuildingAxisValue() != ((Double)faceBuildingAxisValueExtractor.apply(stateEntryInfo.getStartPoint())).doubleValue()) {
                    state.setCurrentRegion(null);
                }
                state.setFaceBuildingAxisValue((Double)faceBuildingAxisValueExtractor.apply(stateEntryInfo.getStartPoint()));
                Optional<FaceRegion> potentialRegionData = this.buildFaceRegion(accessor, facing, (IStateEntryInfo)stateEntryInfo, test, neighborStateSupplier);
                if (!potentialRegionData.isPresent()) {
                    state.setCurrentRegion(null);
                    return;
                }
                if (state.getCurrentRegion() != null && state.getCurrentRegion().extend(potentialRegionData.get())) {
                    return;
                }
                state.setCurrentRegion(potentialRegionData.get());
                regions.add(potentialRegionData.get());
            });
            if (!regions.isEmpty()) {
                resultingRegions.add(Lists.newArrayList((Iterable)regions));
            }
            regions.clear();
        }
    }

    private Optional<FaceRegion> buildFaceRegion(IAreaAccessor blob, Direction facing, IStateEntryInfo target, ICullTest test, Function<Vector3d, BlockState> neighborStateSupplier) {
        return Optional.of(target).filter(stateEntryInfo -> {
            Vector3d faceOffSet = Vector3d.func_237491_b_((Vector3i)facing.func_176730_m()).func_216372_d((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit());
            Vector3d offsetTarget = stateEntryInfo.getStartPoint().func_178787_e(faceOffSet);
            if (!blob.isInside(offsetTarget)) {
                BlockState externalNeighborState = (BlockState)neighborStateSupplier.apply(offsetTarget);
                return Optional.of(externalNeighborState).map(neighborState -> test.isVisible(stateEntryInfo.getState(), (BlockState)neighborState)).orElseGet(() -> !stateEntryInfo.getState().isAir((IBlockReader)new SingleBlockBlockReader(stateEntryInfo.getState()), BlockPos.field_177992_a));
            }
            return blob.getInAreaTarget(offsetTarget).map(IStateEntryInfo::getState).map(neighborState -> test.isVisible(stateEntryInfo.getState(), (BlockState)neighborState)).orElseGet(() -> !stateEntryInfo.getState().isAir((IBlockReader)new SingleBlockBlockReader(stateEntryInfo.getState()), BlockPos.field_177992_a));
        }).map(stateEntryInfo -> {
            Vector3d faceOffSet = Vector3d.func_237491_b_((Vector3i)facing.func_176730_m()).func_216372_d((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit());
            Vector3d offsetTarget = stateEntryInfo.getStartPoint().func_178787_e(faceOffSet);
            return FaceRegion.createFrom3DObjectWithFacing(stateEntryInfo.getStartPoint(), stateEntryInfo.getEndPoint(), facing, stateEntryInfo.getState(), !blob.isInside(offsetTarget));
        });
    }

    private void getVertexPos(float[] pos, Direction side, int vertNum, double[] to, double[] from) {
        float[] interpos = quadMapping[side.ordinal()][vertNum];
        pos[0] = (float)(to[0] * 16.0 * (double)interpos[0] + from[0] * 16.0 * (double)interpos[1]);
        pos[1] = (float)(to[1] * 16.0 * (double)interpos[2] + from[1] * 16.0 * (double)interpos[3]);
        pos[2] = (float)(to[2] * 16.0 * (double)interpos[4] + from[2] * 16.0 * (double)interpos[5]);
    }

    private void getFaceUvs(float[] uvs, Direction face, double[] from, double[] to, float[] quadsUV) {
        float to_u = 0.0f;
        float to_v = 0.0f;
        float from_u = 0.0f;
        float from_v = 0.0f;
        switch (face) {
            case DOWN: 
            case UP: {
                to_u = (float)to[0];
                to_v = (float)to[2];
                from_u = (float)from[0];
                from_v = (float)from[2];
                break;
            }
            case NORTH: 
            case SOUTH: {
                to_u = (float)to[0];
                to_v = (float)to[1];
                from_u = (float)from[0];
                from_v = (float)from[1];
                break;
            }
            case EAST: 
            case WEST: {
                to_u = (float)to[1];
                to_v = (float)to[2];
                from_u = (float)from[1];
                from_v = (float)from[2];
                break;
            }
        }
        uvs[0] = this.u(quadsUV, to_u, to_v) * 16.0f;
        uvs[1] = this.v(quadsUV, to_u, to_v) * 16.0f;
        uvs[2] = this.u(quadsUV, from_u, to_v) * 16.0f;
        uvs[3] = this.v(quadsUV, from_u, to_v) * 16.0f;
        uvs[4] = this.u(quadsUV, from_u, from_v) * 16.0f;
        uvs[5] = this.v(quadsUV, from_u, from_v) * 16.0f;
        uvs[6] = this.u(quadsUV, to_u, from_v) * 16.0f;
        uvs[7] = this.v(quadsUV, to_u, from_v) * 16.0f;
    }

    float u(float[] src, float inU, float inV) {
        float inv = 1.0f - inU;
        float u1 = src[0] * inU + inv * src[2];
        float u2 = src[4] * inU + inv * src[6];
        return u1 * inV + (1.0f - inV) * u2;
    }

    float v(float[] src, float inU, float inV) {
        float inv = 1.0f - inU;
        float v1 = src[1] * inU + inv * src[3];
        float v2 = src[5] * inU + inv * src[7];
        return v1 * inV + (1.0f - inV) * v2;
    }

    private static void offsetVec(double[] result, double toX, double toY, double toZ) {
        result[0] = toX;
        result[1] = toY;
        result[2] = toZ;
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull Random rand, @NotNull IModelData extraData) {
        return this.getList(side);
    }

    @NotNull
    public List<BakedQuad> func_200117_a(@Nullable BlockState state, @Nullable Direction side, @NotNull Random rand) {
        return this.getList(side);
    }

    public boolean func_230044_c_() {
        return true;
    }

    @NotNull
    public TextureAtlasSprite func_177554_e() {
        return (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_).apply(MissingTextureSprite.func_195675_b());
    }

    static {
        Vector3f to = new Vector3f(0.0f, 0.0f, 0.0f);
        Vector3f from = new Vector3f(16.0f, 16.0f, 16.0f);
        for (Direction myFace : Direction.values()) {
            FaceBakery faceBakery = new FaceBakery();
            ModelRotation mr = ModelRotation.X0_Y0;
            float[] defUVs = new float[]{0.0f, 0.0f, 1.0f, 1.0f};
            BlockFaceUV uv = new BlockFaceUV(defUVs, 0);
            BlockPartFace bpf = new BlockPartFace(myFace, 0, "", uv);
            TextureAtlasSprite texture = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_).apply(new ResourceLocation("missingno"));
            BakedQuad q = faceBakery.func_228824_a_(to, from, bpf, texture, myFace, (IModelTransform)mr, null, true, new ResourceLocation("chiselsandbits", "chiseled_block"));
            int[] vertData = q.func_178209_a();
            int a = 0;
            int b = 2;
            switch (myFace) {
                case NORTH: 
                case SOUTH: {
                    a = 0;
                    b = 1;
                    break;
                }
                case EAST: 
                case WEST: {
                    a = 1;
                    b = 2;
                    break;
                }
            }
            int p = vertData.length / 4;
            for (int vertNum = 0; vertNum < 4; ++vertNum) {
                float A = Float.intBitsToFloat(vertData[vertNum * p + a]);
                float B = Float.intBitsToFloat(vertData[vertNum * p + b]);
                for (int o = 0; o < 3; ++o) {
                    float v = Float.intBitsToFloat(vertData[vertNum * p + o]);
                    float scaler = 0.0625f;
                    ChiseledBlockBakedModel.quadMapping[myFace.ordinal()][vertNum][o * 2] = v * 0.0625f;
                    ChiseledBlockBakedModel.quadMapping[myFace.ordinal()][vertNum][o * 2 + 1] = (1.0f - v) * 0.0625f;
                }
                ChiseledBlockBakedModel.faceVertMap[myFace.func_176745_a()][vertNum] = ModelUtil.isZero(A) && ModelUtil.isZero(B) ? 0 : (ModelUtil.isZero(A) && ModelUtil.isOne(B) ? 3 : (ModelUtil.isOne(A) && ModelUtil.isZero(B) ? 1 : 2));
            }
        }
    }

    private static final class FaceBuildingState {
        private double regionBuildingAxis = -1.0;
        private double faceBuildingAxis = -1.0;
        private FaceRegion currentRegion;

        private FaceBuildingState() {
        }

        public double getRegionBuildingAxisValue() {
            return this.regionBuildingAxis;
        }

        public void setRegionBuildingAxisValue(double regionBuildingAxis) {
            this.regionBuildingAxis = regionBuildingAxis;
        }

        public double getFaceBuildingAxisValue() {
            return this.faceBuildingAxis;
        }

        public void setFaceBuildingAxisValue(double faceBuildingAxis) {
            this.faceBuildingAxis = faceBuildingAxis;
        }

        public FaceRegion getCurrentRegion() {
            return this.currentRegion;
        }

        public void setCurrentRegion(FaceRegion currentRegion) {
            this.currentRegion = currentRegion;
        }
    }
}

