/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.UUID;
import mod.chiselsandbits.api.measuring.IMeasurement;
import mod.chiselsandbits.api.measuring.MeasuringMode;
import mod.chiselsandbits.api.measuring.MeasuringType;
import mod.chiselsandbits.api.util.VectorUtils;
import mod.chiselsandbits.client.render.ModRenderTypes;
import mod.chiselsandbits.measures.MeasuringManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.network.play.NetworkPlayerInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;

public final class MeasurementRenderer {
    private static final MeasurementRenderer INSTANCE = new MeasurementRenderer();

    private MeasurementRenderer() {
    }

    public static MeasurementRenderer getInstance() {
        return INSTANCE;
    }

    public void renderMeasurements(RenderWorldLastEvent event) {
        if (Minecraft.func_71410_x().field_71441_e == null) {
            return;
        }
        Collection<? extends IMeasurement> measurements = MeasuringManager.getInstance().getInWorld((World)Minecraft.func_71410_x().field_71441_e);
        Vector3d vector3d = Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216785_c();
        double xView = vector3d.func_82615_a();
        double yView = vector3d.func_82617_b();
        double zView = vector3d.func_82616_c();
        measurements.forEach(measurement -> {
            Vector3d startPos = measurement.getFrom();
            AxisAlignedBB measurementBB = new AxisAlignedBB(Vector3d.field_186680_a, measurement.getSize());
            VoxelShape boundingShape = VoxelShapes.func_197881_a((AxisAlignedBB)measurementBB);
            if (measurement.getMode().getGroup().map(g -> g != MeasuringType.DISTANCE).orElse(false).booleanValue()) {
                WorldRenderer.func_228445_b_((MatrixStack)event.getMatrixStack(), (IVertexBuilder)Minecraft.func_71410_x().func_228019_au_().func_228487_b_().getBuffer(ModRenderTypes.MEASUREMENT_LINES.get()), (VoxelShape)boundingShape, (double)(startPos.func_82615_a() - xView), (double)(startPos.func_82617_b() - yView), (double)(startPos.func_82616_c() - zView), (float)((float)measurement.getMode().getColorVector().func_82615_a()), (float)((float)measurement.getMode().getColorVector().func_82617_b()), (float)((float)measurement.getMode().getColorVector().func_82616_c()), (float)1.0f);
                Vector3d lengths = VectorUtils.absolute(measurement.getTo().func_178788_d(measurement.getFrom()));
                Vector3d centerPos = measurement.getFrom().func_178787_e(measurement.getTo()).func_216372_d(0.5, 0.5, 0.5);
                if (lengths.func_82617_b() > 0.0625) {
                    this.renderMeasurementSize(event.getMatrixStack(), (IMeasurement)measurement, lengths.func_82617_b(), new Vector3d(measurement.getFrom().func_82615_a(), centerPos.func_82617_b(), measurement.getFrom().func_82616_c()));
                }
                if (lengths.func_82615_a() > 0.0625) {
                    this.renderMeasurementSize(event.getMatrixStack(), (IMeasurement)measurement, lengths.func_82615_a(), new Vector3d(centerPos.func_82615_a(), measurement.getFrom().func_82617_b(), measurement.getFrom().func_82616_c()));
                }
                if (lengths.func_82616_c() > 0.0625) {
                    this.renderMeasurementSize(event.getMatrixStack(), (IMeasurement)measurement, lengths.func_82616_c(), new Vector3d(measurement.getFrom().func_82615_a(), measurement.getFrom().func_82617_b(), centerPos.func_82616_c()));
                }
            } else if (measurement.getMode().getGroup().map(g -> g == MeasuringType.DISTANCE).orElse(false).booleanValue()) {
                IVertexBuilder bufferIn = Minecraft.func_71410_x().func_228019_au_().func_228487_b_().getBuffer(ModRenderTypes.MEASUREMENT_LINES.get());
                bufferIn.func_227888_a_(event.getMatrixStack().func_227866_c_().func_227870_a_(), (float)(measurement.getFrom().func_82615_a() - xView), (float)(measurement.getFrom().func_82617_b() - yView), (float)(measurement.getFrom().func_82616_c() - zView)).func_227885_a_((float)measurement.getMode().getColorVector().func_82615_a(), (float)measurement.getMode().getColorVector().func_82617_b(), (float)measurement.getMode().getColorVector().func_82616_c(), 1.0f).func_181675_d();
                bufferIn.func_227888_a_(event.getMatrixStack().func_227866_c_().func_227870_a_(), (float)(measurement.getTo().func_82615_a() - xView), (float)(measurement.getTo().func_82617_b() - yView), (float)(measurement.getTo().func_82616_c() - zView)).func_227885_a_((float)measurement.getMode().getColorVector().func_82615_a(), (float)measurement.getMode().getColorVector().func_82617_b(), (float)measurement.getMode().getColorVector().func_82616_c(), 1.0f).func_181675_d();
                Vector3d lengths = VectorUtils.absolute(measurement.getTo().func_178788_d(measurement.getFrom()));
                double totalLength = lengths.func_72433_c();
                Vector3d centerPos = measurement.getFrom().func_178787_e(measurement.getTo()).func_216372_d(0.5, 0.5, 0.5);
                if (totalLength > 0.0625) {
                    this.renderMeasurementSize(event.getMatrixStack(), (IMeasurement)measurement, totalLength, centerPos);
                }
            }
            Minecraft.func_71410_x().func_228019_au_().func_228487_b_().func_228462_a_(ModRenderTypes.MEASUREMENT_LINES.get());
        });
    }

    private void renderMeasurementSize(MatrixStack matrixStack, IMeasurement measurement, double length, Vector3d position) {
        double letterSize = 5.0;
        double zScale = 0.001;
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        ITextComponent size = this.formatLength(measurement.getMode(), length);
        ITextComponent owner = this.getOwnerName(measurement.getOwner());
        float scale = this.getScale(length);
        Vector3d vector3d = Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216785_c();
        double xView = vector3d.func_82615_a();
        double yView = vector3d.func_82617_b();
        double zView = vector3d.func_82616_c();
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(position.func_82615_a() - xView, position.func_82617_b() + (double)scale * 5.0 - yView, position.func_82616_c() - zView);
        this.performBillboardRotations(matrixStack);
        matrixStack.func_227862_a_(scale, -scale, 0.001f);
        matrixStack.func_227861_a_((double)(-fontRenderer.func_238414_a_((ITextProperties)size)) * 0.5, 0.0, 0.0);
        RenderSystem.disableDepthTest();
        IRenderTypeBuffer.Impl buffer = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        fontRenderer.func_228079_a_(size.getString(), 0.0f, 0.0f, measurement.getMode().getColor().getColorValue(), true, matrixStack.func_227866_c_().func_227870_a_(), (IRenderTypeBuffer)buffer, true, 0, 0xF000F0);
        double d = (double)(-fontRenderer.func_238414_a_((ITextProperties)owner)) * 0.5;
        fontRenderer.getClass();
        matrixStack.func_227861_a_(d, (double)(-9), 0.0);
        fontRenderer.func_228079_a_(owner.getString(), 0.0f, 0.0f, measurement.getMode().getColor().getColorValue(), true, matrixStack.func_227866_c_().func_227870_a_(), (IRenderTypeBuffer)buffer, true, 0, 0xF000F0);
        buffer.func_228461_a_();
        RenderSystem.enableDepthTest();
        matrixStack.func_227865_b_();
    }

    private ITextComponent formatLength(MeasuringMode mode, double length) {
        MeasuringType type = mode.getType();
        if (type == MeasuringType.DISTANCE) {
            return new StringTextComponent(new DecimalFormat("#.0#").format(length));
        }
        if (type == MeasuringType.BLOCK) {
            return new TranslationTextComponent("chiselsandbits.measurements.lengths.block", new Object[]{new DecimalFormat("#").format(Math.floor(length))});
        }
        return new TranslationTextComponent("chiselsandbits.measurements.lengths.bit", new Object[]{new DecimalFormat("#").format(Math.floor(length * 16.0))});
    }

    private float getScale(double maxLen) {
        double maxFontSize = 0.04;
        double minFontSize = 0.004;
        double delta = Math.min(1.0, maxLen / 4.0);
        double scale = 0.04 * delta + 0.004 * (1.0 - delta);
        if (maxLen < 0.25) {
            scale = 0.004;
        }
        return (float)Math.min(0.04, scale);
    }

    private void performBillboardRotations(MatrixStack matrixStack) {
        Entity view;
        Object object = view = Minecraft.func_71410_x().field_175622_Z != null ? Minecraft.func_71410_x().field_175622_Z : Minecraft.func_71410_x().field_71439_g;
        if (view != null) {
            float yaw = view.field_70126_B + (view.field_70177_z - view.field_70126_B) * Minecraft.func_71410_x().func_184121_ak();
            matrixStack.func_227863_a_(new Quaternion(Vector3f.field_229181_d_, 180.0f + -yaw, true));
            float pitch = view.field_70127_C + (view.field_70125_A - view.field_70127_C) * Minecraft.func_71410_x().func_184121_ak();
            matrixStack.func_227863_a_(new Quaternion(Vector3f.field_229179_b_, -pitch, true));
        }
    }

    private ITextComponent getOwnerName(UUID id) {
        NetworkPlayerInfo playerInfo;
        if (id == (Minecraft.func_71410_x().field_71439_g != null ? Minecraft.func_71410_x().field_71439_g.func_110124_au() : UUID.randomUUID())) {
            return new TranslationTextComponent("chiselsandbits.measurements.owners.you");
        }
        NetworkPlayerInfo networkPlayerInfo = playerInfo = Minecraft.func_71410_x().func_147114_u() != null ? Minecraft.func_71410_x().func_147114_u().func_175102_a(id) : null;
        if (playerInfo == null) {
            return new TranslationTextComponent("chiselsandbits.measurements.owners.unknown");
        }
        return new TranslationTextComponent("chiselsandbits.measurements.owners.by", new Object[]{playerInfo.func_178854_k() != null ? this.formatPlayerDisplayName(playerInfo, playerInfo.func_178854_k().func_230532_e_()) : this.formatPlayerDisplayName(playerInfo, ScorePlayerTeam.func_237500_a_((Team)playerInfo.func_178850_i(), (ITextComponent)new StringTextComponent(playerInfo.func_178845_a().getName())))});
    }

    private ITextComponent formatPlayerDisplayName(NetworkPlayerInfo p_238524_1_, IFormattableTextComponent p_238524_2_) {
        return p_238524_1_.func_178848_b() == GameType.SPECTATOR ? p_238524_2_.func_240699_a_(TextFormatting.ITALIC) : p_238524_2_;
    }
}

