/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.screens;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import mod.chiselsandbits.api.multistate.snapshot.IMultiStateSnapshot;
import mod.chiselsandbits.client.screens.widgets.MultiStateSnapshotWidget;
import mod.chiselsandbits.container.ModificationTableContainer;
import mod.chiselsandbits.multistate.snapshot.EmptySnapshot;
import mod.chiselsandbits.recipe.modificationtable.ModificationTableRecipe;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.NotNull;

public class ModificationTableScreen
extends ContainerScreen<ModificationTableContainer> {
    private static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("chiselsandbits", "textures/gui/container/modification_table.png");
    private float sliderProgress;
    private boolean clickedOnSroll;
    private int recipeIndexOffset;
    private boolean hasItemsInInputSlot;
    private MultiStateSnapshotWidget snapshotWidget;
    private int lastRenderedSelectedRecipeIndex = -1;

    public ModificationTableScreen(ModificationTableContainer containerIn, PlayerInventory playerInv, ITextComponent titleIn) {
        super((Container)containerIn, playerInv, titleIn);
        containerIn.setInventoryUpdateListener(this::onInventoryUpdate);
        --this.field_238743_q_;
        this.field_147000_g = 197;
        this.field_238745_s_ = this.field_147000_g - 94;
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.snapshotWidget = (MultiStateSnapshotWidget)this.func_230480_a_(new MultiStateSnapshotWidget(this.field_147003_i + 51, this.field_147009_r + 71, 66, 28, (ITextComponent)new TranslationTextComponent("chiselsandbits.screen.widgets.multistate.preview")));
    }

    public void func_230430_a_(@NotNull MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.func_230459_a_(matrixStack, mouseX, mouseY);
    }

    protected void func_230450_a_(@NotNull MatrixStack matrixStack, float partialTicks, int x, int y) {
        this.func_230446_a_(matrixStack);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.field_230706_i_ != null) {
            this.field_230706_i_.func_110434_K().func_110577_a(BACKGROUND_TEXTURE);
        }
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        this.func_238474_b_(matrixStack, i, j, 0, 0, this.field_146999_f, this.field_147000_g);
        int k = (int)(41.0f * this.sliderProgress);
        this.func_238474_b_(matrixStack, i + 119, j + 15 + k, this.field_146999_f + (this.canScroll() ? 0 : 12), 0, 12, 15);
        int l = this.field_147003_i + 52;
        int i1 = this.field_147009_r + 14;
        int j1 = this.recipeIndexOffset + 12;
        this.renderButtons(matrixStack, x, y, l, i1, j1);
        this.drawRecipesItems(l, i1, j1);
        if (this.lastRenderedSelectedRecipeIndex != ((ModificationTableContainer)this.field_147002_h).getSelectedRecipe() && this.hasItemsInInputSlot) {
            this.lastRenderedSelectedRecipeIndex = ((ModificationTableContainer)this.field_147002_h).getSelectedRecipe();
            IMultiStateSnapshot snapshot = ((ModificationTableContainer)this.field_147002_h).getRecipeList().get(this.lastRenderedSelectedRecipeIndex).getAppliedSnapshot(((ModificationTableContainer)this.field_147002_h).inputInventory);
            this.snapshotWidget.setSnapshot(snapshot);
        }
    }

    protected void func_230459_a_(@NotNull MatrixStack matrixStack, int x, int y) {
        super.func_230459_a_(matrixStack, x, y);
        if (this.hasItemsInInputSlot) {
            int i = this.field_147003_i + 52;
            int j = this.field_147009_r + 14;
            int k = this.recipeIndexOffset + 12;
            List<ModificationTableRecipe> list = ((ModificationTableContainer)this.field_147002_h).getRecipeList();
            for (int l = this.recipeIndexOffset; l < k && l < ((ModificationTableContainer)this.field_147002_h).getRecipeListSize(); ++l) {
                int i1 = l - this.recipeIndexOffset;
                int j1 = i + i1 % 4 * 16;
                int k1 = j + i1 / 4 * 18 + 2;
                if (x < j1 || x >= j1 + 16 || y < k1 || y >= k1 + 18) continue;
                this.renderWrappedToolTip(matrixStack, Lists.newArrayList((Object[])new ITextComponent[]{list.get(l).getDisplayName()}), x, y, this.field_230712_o_);
            }
        }
    }

    private void renderButtons(MatrixStack matrixStack, int x, int y, int p_238853_4_, int p_238853_5_, int p_238853_6_) {
        for (int i = this.recipeIndexOffset; i < p_238853_6_ && i < ((ModificationTableContainer)this.field_147002_h).getRecipeListSize(); ++i) {
            int j = i - this.recipeIndexOffset;
            int k = p_238853_4_ + j % 4 * 16;
            int l = j / 4;
            int i1 = p_238853_5_ + l * 18 + 2;
            int j1 = this.field_147000_g;
            if (i == ((ModificationTableContainer)this.field_147002_h).getSelectedRecipe()) {
                j1 += 18;
            } else if (x >= k && y >= i1 && x < k + 16 && y < i1 + 18) {
                j1 += 36;
            }
            this.func_238474_b_(matrixStack, k, i1 - 1, 0, j1, 16, 18);
        }
    }

    private void drawRecipesItems(int left, int top, int recipeIndexOffsetMax) {
        List<ModificationTableRecipe> list = ((ModificationTableContainer)this.field_147002_h).getRecipeList();
        for (int i = this.recipeIndexOffset; i < recipeIndexOffsetMax && i < ((ModificationTableContainer)this.field_147002_h).getRecipeListSize(); ++i) {
            int j = i - this.recipeIndexOffset;
            int k = left + j % 4 * 16;
            int l = j / 4;
            int i1 = top + l * 18 + 2;
            if (this.field_230706_i_ == null) continue;
            this.field_230706_i_.func_175599_af().func_180450_b(list.get(i).getCraftingBlockResult(((ModificationTableContainer)this.field_147002_h).inputInventory), k, i1);
        }
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        this.clickedOnSroll = false;
        if (this.hasItemsInInputSlot) {
            int i = this.field_147003_i + 52;
            int j = this.field_147009_r + 14;
            int k = this.recipeIndexOffset + 12;
            for (int l = this.recipeIndexOffset; l < k; ++l) {
                int i1 = l - this.recipeIndexOffset;
                double d0 = mouseX - (double)(i + i1 % 4 * 16);
                double d1 = mouseY - (double)(j + i1 / 4 * 18);
                if (this.field_230706_i_ == null || this.field_230706_i_.field_71439_g == null || !(d0 >= 0.0) || !(d1 >= 0.0) || !(d0 < 16.0) || !(d1 < 18.0) || !((ModificationTableContainer)this.field_147002_h).func_75140_a((PlayerEntity)this.field_230706_i_.field_71439_g, l)) continue;
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_219720_mm, (float)1.0f));
                if (this.field_230706_i_.field_71442_b != null) {
                    this.field_230706_i_.field_71442_b.func_78756_a(((ModificationTableContainer)this.field_147002_h).field_75152_c, l);
                }
                return true;
            }
            i = this.field_147003_i + 119;
            j = this.field_147009_r + 9;
            if (mouseX >= (double)i && mouseX < (double)(i + 12) && mouseY >= (double)j && mouseY < (double)(j + 54)) {
                this.clickedOnSroll = true;
            }
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.clickedOnSroll && this.canScroll()) {
            int i = this.field_147009_r + 14;
            int j = i + 54;
            this.sliderProgress = ((float)mouseY - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            this.sliderProgress = MathHelper.func_76131_a((float)this.sliderProgress, (float)0.0f, (float)1.0f);
            this.recipeIndexOffset = (int)((double)(this.sliderProgress * (float)this.getHiddenRows()) + 0.5) * 4;
            return true;
        }
        if (this.snapshotWidget.func_231047_b_(mouseX, mouseY)) {
            return this.snapshotWidget.func_231045_a_(mouseX, mouseY, button, dragX, dragY);
        }
        return super.func_231045_a_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double delta) {
        if (this.snapshotWidget.func_231047_b_(mouseX, mouseY)) {
            return this.snapshotWidget.func_231043_a_(mouseX, mouseY, delta);
        }
        if (this.canScroll()) {
            int i = this.getHiddenRows();
            this.sliderProgress = (float)((double)this.sliderProgress - delta / (double)i);
            this.sliderProgress = MathHelper.func_76131_a((float)this.sliderProgress, (float)0.0f, (float)1.0f);
            this.recipeIndexOffset = (int)((double)(this.sliderProgress * (float)i) + 0.5) * 4;
        }
        return true;
    }

    private boolean canScroll() {
        return this.hasItemsInInputSlot && ((ModificationTableContainer)this.field_147002_h).getRecipeListSize() > 12;
    }

    protected int getHiddenRows() {
        return (((ModificationTableContainer)this.field_147002_h).getRecipeListSize() + 4 - 1) / 4 - 3;
    }

    private void onInventoryUpdate() {
        this.hasItemsInInputSlot = ((ModificationTableContainer)this.field_147002_h).hasItemsInInputSlot();
        if (!this.hasItemsInInputSlot) {
            this.sliderProgress = 0.0f;
            this.recipeIndexOffset = 0;
            this.snapshotWidget.setSnapshot(EmptySnapshot.INSTANCE);
            this.lastRenderedSelectedRecipeIndex = -1;
        }
    }
}

