/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.item.multistate;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import mod.chiselsandbits.api.exceptions.SpaceOccupiedException;
import mod.chiselsandbits.api.item.multistate.IMultiStateItem;
import mod.chiselsandbits.api.item.multistate.IMultiStateItemStack;
import mod.chiselsandbits.api.item.multistate.IStatistics;
import mod.chiselsandbits.api.item.pattern.IPatternItem;
import mod.chiselsandbits.api.multistate.StateEntrySize;
import mod.chiselsandbits.api.multistate.accessor.IStateEntryInfo;
import mod.chiselsandbits.api.multistate.accessor.identifier.IAreaShapeIdentifier;
import mod.chiselsandbits.api.multistate.accessor.identifier.ILongArrayBackedAreaShapeIdentifier;
import mod.chiselsandbits.api.multistate.accessor.sortable.IPositionMutator;
import mod.chiselsandbits.api.multistate.mutator.IMutableStateEntryInfo;
import mod.chiselsandbits.api.multistate.mutator.callback.StateClearer;
import mod.chiselsandbits.api.multistate.mutator.callback.StateSetter;
import mod.chiselsandbits.api.multistate.snapshot.IMultiStateSnapshot;
import mod.chiselsandbits.api.util.BlockPosStreamProvider;
import mod.chiselsandbits.api.util.SingleBlockBlockReader;
import mod.chiselsandbits.item.ChiseledBlockItem;
import mod.chiselsandbits.materials.MaterialManager;
import mod.chiselsandbits.registrars.ModItems;
import mod.chiselsandbits.utils.ChunkSectionUtils;
import mod.chiselsandbits.utils.MultiStateSnapshotUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraftforge.fml.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class SingleBlockMultiStateItemStack
implements IMultiStateItemStack {
    private final ItemStack sourceStack;
    private final ChunkSection compressedSection;
    private final Statistics statistics = new Statistics();

    public SingleBlockMultiStateItemStack(ItemStack sourceStack) {
        this.sourceStack = sourceStack;
        this.compressedSection = new ChunkSection(0);
        this.deserializeNBT(sourceStack.func_190925_c("chiseledData"));
    }

    public SingleBlockMultiStateItemStack(Item item, ChunkSection compressedSection) {
        if (!(item instanceof IMultiStateItem)) {
            throw new IllegalArgumentException("The given item is not a MultiState Item");
        }
        this.sourceStack = new ItemStack((IItemProvider)item);
        this.compressedSection = compressedSection;
        this.statistics.initializeFrom(this.compressedSection);
        this.sourceStack.func_196082_o().func_218657_a("chiseledData", (INBT)this.serializeNBT());
    }

    @Override
    public IAreaShapeIdentifier createNewShapeIdentifier() {
        return new ShapeIdentifier(this.compressedSection);
    }

    @Override
    public Stream<IStateEntryInfo> stream() {
        return BlockPosStreamProvider.getForRange(StateEntrySize.current().getBitsPerBlockSide()).map(blockPos -> new StateEntry(this.compressedSection.func_177485_a(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p()), (Vector3i)blockPos, this::setInAreaTarget, this::clearInAreaTarget));
    }

    @Override
    public Optional<IStateEntryInfo> getInAreaTarget(Vector3d inAreaTarget) {
        if (inAreaTarget.func_82615_a() < 0.0 || inAreaTarget.func_82617_b() < 0.0 || inAreaTarget.func_82616_c() < 0.0 || inAreaTarget.func_82615_a() >= 1.0 || inAreaTarget.func_82617_b() >= 1.0 || inAreaTarget.func_82616_c() >= 1.0) {
            throw new IllegalArgumentException("Target is not in the current area.");
        }
        BlockPos inAreaPos = new BlockPos(inAreaTarget.func_216372_d((double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide()));
        BlockState currentState = this.compressedSection.func_177485_a(inAreaPos.func_177958_n(), inAreaPos.func_177956_o(), inAreaPos.func_177952_p());
        return currentState.func_196958_f() ? Optional.empty() : Optional.of(new StateEntry(currentState, (Vector3i)inAreaPos, this::setInAreaTarget, this::clearInAreaTarget));
    }

    @Override
    public Optional<IStateEntryInfo> getInBlockTarget(BlockPos inAreaBlockPosOffset, Vector3d inBlockTarget) {
        if (!inAreaBlockPosOffset.equals((Object)BlockPos.field_177992_a)) {
            throw new IllegalStateException(String.format("The given in area block pos offset is not inside the current block: %s", inAreaBlockPosOffset));
        }
        return this.getInAreaTarget(inBlockTarget);
    }

    @Override
    public boolean isInside(Vector3d inAreaTarget) {
        return !(inAreaTarget.func_82615_a() < 0.0 || inAreaTarget.func_82617_b() < 0.0 || inAreaTarget.func_82616_c() < 0.0 || inAreaTarget.func_82615_a() >= 1.0 || inAreaTarget.func_82617_b() >= 1.0 || inAreaTarget.func_82616_c() >= 1.0);
    }

    @Override
    public boolean isInside(BlockPos inAreaBlockPosOffset, Vector3d inBlockTarget) {
        if (!inAreaBlockPosOffset.equals((Object)BlockPos.field_177992_a)) {
            return false;
        }
        return this.isInside(inBlockTarget);
    }

    @Override
    public IMultiStateSnapshot createSnapshot() {
        return MultiStateSnapshotUtils.createFromSection(this.compressedSection);
    }

    @Override
    public Stream<IMutableStateEntryInfo> mutableStream() {
        return BlockPosStreamProvider.getForRange(StateEntrySize.current().getBitsPerBlockSide()).map(blockPos -> new StateEntry(this.compressedSection.func_177485_a(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p()), (Vector3i)blockPos, this::setInAreaTarget, this::clearInAreaTarget));
    }

    @Override
    public void setInAreaTarget(BlockState blockState, Vector3d inAreaTarget) throws SpaceOccupiedException {
        if (inAreaTarget.func_82615_a() < 0.0 || inAreaTarget.func_82617_b() < 0.0 || inAreaTarget.func_82616_c() < 0.0 || inAreaTarget.func_82615_a() >= 1.0 || inAreaTarget.func_82617_b() >= 1.0 || inAreaTarget.func_82616_c() >= 1.0) {
            throw new IllegalArgumentException("Target is not in the current area.");
        }
        BlockPos inAreaPos = new BlockPos(inAreaTarget.func_216372_d((double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide()));
        BlockState currentState = this.compressedSection.func_177485_a(inAreaPos.func_177958_n(), inAreaPos.func_177956_o(), inAreaPos.func_177952_p());
        if (!currentState.isAir((IBlockReader)new SingleBlockBlockReader(currentState), BlockPos.field_177992_a)) {
            throw new SpaceOccupiedException();
        }
        this.compressedSection.func_177484_a(inAreaPos.func_177958_n(), inAreaPos.func_177956_o(), inAreaPos.func_177952_p(), blockState, true);
        if (blockState.func_196958_f() && !currentState.func_196958_f()) {
            this.statistics.onBlockStateRemoved(currentState);
        } else if (!blockState.func_196958_f() && currentState.func_196958_f()) {
            this.statistics.onBlockStateAdded(blockState);
        } else if (!blockState.func_196958_f() && !currentState.func_196958_f()) {
            this.statistics.onBlockStateReplaced(currentState, blockState);
        }
        this.sourceStack.func_196082_o().func_218657_a("chiseledData", (INBT)this.serializeNBT());
    }

    @Override
    public void setInBlockTarget(BlockState blockState, BlockPos inAreaBlockPosOffset, Vector3d inBlockTarget) throws SpaceOccupiedException {
        if (!inAreaBlockPosOffset.equals((Object)BlockPos.field_177992_a)) {
            throw new IllegalStateException(String.format("The given in area block pos offset is not inside the current block: %s", inAreaBlockPosOffset));
        }
        this.setInAreaTarget(blockState, inBlockTarget);
    }

    @Override
    public void clearInAreaTarget(Vector3d inAreaTarget) {
        if (inAreaTarget.func_82615_a() < 0.0 || inAreaTarget.func_82617_b() < 0.0 || inAreaTarget.func_82616_c() < 0.0 || inAreaTarget.func_82615_a() >= 1.0 || inAreaTarget.func_82617_b() >= 1.0 || inAreaTarget.func_82616_c() >= 1.0) {
            throw new IllegalArgumentException("Target is not in the current area.");
        }
        BlockPos inAreaPos = new BlockPos(inAreaTarget.func_216372_d((double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide()));
        BlockState blockState = Blocks.field_150350_a.func_176223_P();
        BlockState currentState = this.compressedSection.func_177485_a(inAreaPos.func_177958_n(), inAreaPos.func_177956_o(), inAreaPos.func_177952_p());
        this.compressedSection.func_177484_a(inAreaPos.func_177958_n(), inAreaPos.func_177956_o(), inAreaPos.func_177952_p(), blockState, true);
        if (blockState.func_196958_f() && !currentState.func_196958_f()) {
            this.statistics.onBlockStateRemoved(currentState);
        } else if (!blockState.func_196958_f() && currentState.func_196958_f()) {
            this.statistics.onBlockStateAdded(blockState);
        } else if (!blockState.func_196958_f() && !currentState.func_196958_f()) {
            this.statistics.onBlockStateReplaced(currentState, blockState);
        }
        this.sourceStack.func_196082_o().func_218657_a("chiseledData", (INBT)this.serializeNBT());
    }

    @Override
    public void clearInBlockTarget(BlockPos inAreaBlockPosOffset, Vector3d inBlockTarget) {
        if (!inAreaBlockPosOffset.equals((Object)BlockPos.field_177992_a)) {
            throw new IllegalStateException(String.format("The given in area block pos offset is not inside the current block: %s", inAreaBlockPosOffset));
        }
        this.clearInAreaTarget(inBlockTarget);
    }

    @Override
    public void serializeInto(@NotNull PacketBuffer packetBuffer) {
        this.compressedSection.func_186049_g().func_186009_b(packetBuffer);
    }

    @Override
    public void deserializeFrom(@NotNull PacketBuffer packetBuffer) {
        this.compressedSection.func_186049_g().func_186010_a(packetBuffer);
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        CompoundNBT chiselBlockData = new CompoundNBT();
        CompoundNBT compressedSectionData = ChunkSectionUtils.serializeNBT(this.compressedSection);
        CompoundNBT statisticsData = this.statistics.serializeNBT();
        chiselBlockData.func_218657_a("compressedStorage", (INBT)compressedSectionData);
        chiselBlockData.func_218657_a("statistics", (INBT)statisticsData);
        nbt.func_218657_a("chiselBlockData", (INBT)chiselBlockData);
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        CompoundNBT chiselBlockData = nbt.func_74775_l("chiselBlockData");
        CompoundNBT compressedSectionData = chiselBlockData.func_74775_l("compressedStorage");
        CompoundNBT statisticsData = chiselBlockData.func_74775_l("statistics");
        ChunkSectionUtils.deserializeNBT(this.compressedSection, compressedSectionData);
        this.statistics.deserializeNBT(statisticsData);
    }

    @Override
    public IStatistics getStatistics() {
        return this.statistics;
    }

    @Override
    public ItemStack toBlockStack() {
        if (this.sourceStack.func_77973_b() instanceof IPatternItem) {
            BlockState primaryState = this.statistics.getPrimaryState();
            Material blockMaterial = primaryState.func_185904_a();
            Material conversionMaterial = MaterialManager.getInstance().remapMaterialIfNeeded(blockMaterial);
            RegistryObject<ChiseledBlockItem> convertedItemProvider = ModItems.MATERIAL_TO_ITEM_CONVERSIONS.get(conversionMaterial);
            ChiseledBlockItem chiseledBlockItem = (ChiseledBlockItem)convertedItemProvider.get();
            ItemStack blockStack = new ItemStack((IItemProvider)chiseledBlockItem);
            blockStack.func_77982_d(this.sourceStack.func_196082_o().func_74737_b());
            return blockStack;
        }
        return this.sourceStack.func_77946_l();
    }

    @Override
    public ItemStack toPatternStack() {
        if (this.sourceStack.func_77973_b() instanceof IPatternItem) {
            return this.sourceStack.func_77946_l();
        }
        ItemStack singleUsePatternStack = new ItemStack((IItemProvider)ModItems.SINGLE_USE_PATTERN_ITEM.get());
        singleUsePatternStack.func_77982_d(this.sourceStack.func_196082_o().func_74737_b());
        return singleUsePatternStack;
    }

    @Override
    public Stream<IStateEntryInfo> streamWithPositionMutator(IPositionMutator positionMutator) {
        return BlockPosStreamProvider.getForRange(StateEntrySize.current().getBitsPerBlockSide()).map(positionMutator::mutate).map(blockPos -> new StateEntry(this.compressedSection.func_177485_a(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p()), (Vector3i)blockPos, this::setInAreaTarget, this::clearInAreaTarget));
    }

    private static final class Statistics
    implements IStatistics {
        private BlockState primaryState = Blocks.field_150350_a.func_176223_P();
        private final Map<BlockState, Integer> countMap = Maps.newConcurrentMap();

        private Statistics() {
        }

        @Override
        public BlockState getPrimaryState() {
            return this.primaryState;
        }

        @Override
        public boolean isEmpty() {
            return this.countMap.isEmpty() || this.countMap.size() == 1 && this.countMap.containsKey(Blocks.field_150350_a.func_176223_P());
        }

        private void clear() {
            this.primaryState = Blocks.field_150350_a.func_176223_P();
            this.countMap.clear();
        }

        private void onBlockStateAdded(BlockState blockState) {
            this.countMap.putIfAbsent(blockState, 0);
            this.countMap.computeIfPresent(blockState, (state, currentCount) -> currentCount + 1);
            this.updatePrimaryState();
        }

        private void onBlockStateRemoved(BlockState blockState) {
            this.countMap.computeIfPresent(blockState, (state, currentCount) -> currentCount - 1);
            this.countMap.remove(blockState, 0);
            this.updatePrimaryState();
        }

        private void onBlockStateReplaced(BlockState currentState, BlockState newState) {
            this.countMap.computeIfPresent(currentState, (state, currentCount) -> currentCount - 1);
            this.countMap.remove(currentState, 0);
            this.countMap.putIfAbsent(newState, 0);
            this.countMap.computeIfPresent(newState, (state, currentCount) -> currentCount + 1);
            this.updatePrimaryState();
        }

        private void updatePrimaryState() {
            this.primaryState = this.countMap.entrySet().stream().filter(entry -> !((BlockState)entry.getKey()).func_196958_f()).min((o1, o2) -> -1 * ((Integer)o1.getValue() - (Integer)o2.getValue())).map(Map.Entry::getKey).orElseGet(() -> ((Block)Blocks.field_150350_a).func_176223_P());
        }

        public CompoundNBT serializeNBT() {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_218657_a("primaryState", (INBT)NBTUtil.func_190009_a((BlockState)this.primaryState));
            ListNBT blockStateList = new ListNBT();
            for (Map.Entry<BlockState, Integer> blockStateIntegerEntry : this.countMap.entrySet()) {
                CompoundNBT stateNbt = new CompoundNBT();
                stateNbt.func_218657_a("blockState", (INBT)NBTUtil.func_190009_a((BlockState)blockStateIntegerEntry.getKey()));
                stateNbt.func_74768_a("count", blockStateIntegerEntry.getValue().intValue());
                blockStateList.add((Object)stateNbt);
            }
            nbt.func_218657_a("blockStates", (INBT)blockStateList);
            return nbt;
        }

        public void deserializeNBT(CompoundNBT nbt) {
            this.countMap.clear();
            this.primaryState = NBTUtil.func_190008_d((CompoundNBT)nbt.func_74775_l("primaryState"));
            ListNBT blockStateList = nbt.func_150295_c("blockStates", 10);
            for (int i = 0; i < blockStateList.size(); ++i) {
                CompoundNBT stateNbt = blockStateList.func_150305_b(i);
                this.countMap.put(NBTUtil.func_190008_d((CompoundNBT)stateNbt.func_74775_l("blockState")), stateNbt.func_74762_e("count"));
            }
        }

        public void initializeFrom(ChunkSection compressedSection) {
            this.clear();
            compressedSection.func_186049_g().func_225497_a(this.countMap::putIfAbsent);
            this.updatePrimaryState();
        }
    }

    private static final class StateEntry
    implements IMutableStateEntryInfo {
        private final BlockState state;
        private final Vector3d startPoint;
        private final Vector3d endPoint;
        private final StateSetter stateSetter;
        private final StateClearer stateClearer;

        public StateEntry(BlockState state, Vector3i startPoint, StateSetter stateSetter, StateClearer stateClearer) {
            this(state, Vector3d.func_237491_b_((Vector3i)startPoint).func_216372_d((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit()), Vector3d.func_237491_b_((Vector3i)startPoint).func_216372_d((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit()).func_72441_c((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit()), stateSetter, stateClearer);
        }

        private StateEntry(BlockState state, Vector3d startPoint, Vector3d endPoint, StateSetter stateSetter, StateClearer stateClearer) {
            this.state = state;
            this.startPoint = startPoint;
            this.endPoint = endPoint;
            this.stateSetter = stateSetter;
            this.stateClearer = stateClearer;
        }

        @Override
        public BlockState getState() {
            return this.state;
        }

        @Override
        public Vector3d getStartPoint() {
            return this.startPoint;
        }

        @Override
        public Vector3d getEndPoint() {
            return this.endPoint;
        }

        @Override
        public void setState(BlockState blockState) throws SpaceOccupiedException {
            this.stateSetter.accept(blockState, this.getStartPoint());
        }

        @Override
        public void clear() {
            this.stateClearer.accept(this.getStartPoint());
        }
    }

    private static final class ShapeIdentifier
    implements ILongArrayBackedAreaShapeIdentifier {
        private final long[] dataArray;

        private ShapeIdentifier(ChunkSection chunkSection) {
            this.dataArray = Arrays.copyOf(chunkSection.func_186049_g().field_186021_b.func_188143_a(), chunkSection.func_186049_g().field_186021_b.func_188143_a().length);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ILongArrayBackedAreaShapeIdentifier)) {
                return false;
            }
            ILongArrayBackedAreaShapeIdentifier that = (ILongArrayBackedAreaShapeIdentifier)o;
            return Arrays.equals(this.dataArray, that.getBackingData());
        }

        public int hashCode() {
            return Arrays.hashCode(this.dataArray);
        }

        @Override
        public long[] getBackingData() {
            return this.dataArray;
        }
    }
}

