/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.multistate.snapshot;

import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mod.chiselsandbits.api.exceptions.SpaceOccupiedException;
import mod.chiselsandbits.api.item.multistate.IMultiStateItemStack;
import mod.chiselsandbits.api.multistate.StateEntrySize;
import mod.chiselsandbits.api.multistate.accessor.IAreaAccessor;
import mod.chiselsandbits.api.multistate.accessor.IStateEntryInfo;
import mod.chiselsandbits.api.multistate.accessor.identifier.IAreaShapeIdentifier;
import mod.chiselsandbits.api.multistate.accessor.sortable.IPositionMutator;
import mod.chiselsandbits.api.multistate.mutator.IAreaMutator;
import mod.chiselsandbits.api.multistate.mutator.IMutableStateEntryInfo;
import mod.chiselsandbits.api.multistate.snapshot.IMultiStateSnapshot;
import mod.chiselsandbits.api.multistate.statistics.IMultiStateObjectStatistics;
import mod.chiselsandbits.api.util.BlockPosStreamProvider;
import mod.chiselsandbits.api.util.VectorUtils;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import org.apache.commons.lang3.NotImplementedException;

public class MultiBlockMultiStateSnapshot
implements IMultiStateSnapshot {
    private Map<BlockPos, IMultiStateSnapshot> snapshots;
    private Vector3d startPoint;
    private Vector3d endPoint;

    public MultiBlockMultiStateSnapshot(Map<BlockPos, IMultiStateSnapshot> snapshots, Vector3d startPoint, Vector3d endPoint) {
        this.snapshots = snapshots;
        this.startPoint = startPoint;
        this.endPoint = endPoint;
        if (!BlockPosStreamProvider.getForRange(startPoint, endPoint).allMatch(snapshots::containsKey)) {
            throw new IllegalArgumentException("Not all required blockposes are part of the given range.");
        }
    }

    @Override
    public IAreaShapeIdentifier createNewShapeIdentifier() {
        return new Identifier(this.snapshots.values());
    }

    @Override
    public Stream<IStateEntryInfo> stream() {
        return this.snapshots.values().stream().flatMap(IAreaAccessor::stream);
    }

    @Override
    public boolean isInside(Vector3d inAreaTarget) {
        BlockPos inAreaOffset = new BlockPos(inAreaTarget);
        return this.isInside(inAreaOffset, inAreaTarget.func_178788_d(Vector3d.func_237491_b_((Vector3i)inAreaOffset)));
    }

    @Override
    public boolean isInside(BlockPos inAreaBlockPosOffset, Vector3d inBlockTarget) {
        BlockPos targetPos = new BlockPos(this.startPoint).func_177971_a((Vector3i)inAreaBlockPosOffset);
        return this.snapshots.containsKey(targetPos) && this.snapshots.get(targetPos).isInside(BlockPos.field_177992_a, inBlockTarget);
    }

    @Override
    public IMultiStateSnapshot createSnapshot() {
        Map<BlockPos, IMultiStateSnapshot> copiedSnapshots = this.snapshots.keySet().stream().collect(Collectors.toMap(Function.identity(), pos -> this.snapshots.get(pos).createSnapshot()));
        return new MultiBlockMultiStateSnapshot(copiedSnapshots, this.startPoint, this.endPoint);
    }

    @Override
    public Stream<IStateEntryInfo> streamWithPositionMutator(IPositionMutator positionMutator) {
        return BlockPosStreamProvider.getForRange(this.startPoint.func_216372_d((double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide()), this.endPoint.func_216372_d((double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide())).map(positionMutator::mutate).map(position -> Vector3d.func_237491_b_((Vector3i)position).func_216372_d((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())).map(position -> {
            BlockPos blockPos = new BlockPos(position);
            Vector3d inBlockOffset = position.func_178788_d(Vector3d.func_237491_b_((Vector3i)blockPos));
            return this.getInBlockTarget(blockPos, inBlockOffset);
        }).filter(Optional::isPresent).map(Optional::get);
    }

    @Override
    public Optional<IStateEntryInfo> getInAreaTarget(Vector3d inAreaTarget) {
        BlockPos inAreaOffset = new BlockPos(inAreaTarget);
        return this.getInBlockTarget(inAreaOffset, inAreaTarget.func_178788_d(Vector3d.func_237491_b_((Vector3i)inAreaOffset)));
    }

    @Override
    public Optional<IStateEntryInfo> getInBlockTarget(BlockPos inAreaBlockPosOffset, Vector3d inBlockTarget) {
        BlockPos targetPos = new BlockPos(this.startPoint).func_177971_a((Vector3i)inAreaBlockPosOffset);
        if (!this.snapshots.containsKey(targetPos)) {
            throw new IllegalArgumentException("The given position is not in the current snapshot!");
        }
        return this.snapshots.get(targetPos).getInBlockTarget(BlockPos.field_177992_a, inBlockTarget);
    }

    @Override
    public Stream<IMutableStateEntryInfo> mutableStream() {
        return this.snapshots.values().stream().flatMap(IAreaMutator::mutableStream);
    }

    @Override
    public void setInAreaTarget(BlockState blockState, Vector3d inAreaTarget) throws SpaceOccupiedException {
        Vector3d workingTarget = inAreaTarget.func_178787_e(this.startPoint);
        BlockPos offset = new BlockPos(workingTarget);
        Vector3d inBlockTarget = new Vector3d(workingTarget.func_82615_a() - (double)offset.func_177958_n(), workingTarget.func_82617_b() - (double)offset.func_177956_o(), workingTarget.func_82616_c() - (double)offset.func_177952_p());
        this.setInBlockTarget(blockState, offset, inBlockTarget);
    }

    @Override
    public void setInBlockTarget(BlockState blockState, BlockPos inAreaBlockPosOffset, Vector3d inBlockTarget) throws SpaceOccupiedException {
        Vector3d workingTarget = Vector3d.func_237491_b_((Vector3i)inAreaBlockPosOffset).func_178787_e(inBlockTarget);
        if (workingTarget.func_82615_a() < this.startPoint.func_82615_a() || workingTarget.func_82617_b() < this.startPoint.func_82617_b() || workingTarget.func_82616_c() < this.startPoint.func_82616_c() || workingTarget.func_82615_a() > this.endPoint.func_82615_a() || workingTarget.func_82617_b() > this.endPoint.func_82617_b() || workingTarget.func_82616_c() > this.endPoint.func_82616_c()) {
            throw new IllegalArgumentException("The given target is outside of the operating range of this snapshot!");
        }
        if (!this.snapshots.containsKey(inAreaBlockPosOffset)) {
            throw new IllegalArgumentException("The given in area block pos offset is outside of the target range!");
        }
        this.snapshots.get(inAreaBlockPosOffset).setInAreaTarget(blockState, inBlockTarget);
    }

    @Override
    public void clearInAreaTarget(Vector3d inAreaTarget) {
        Vector3d workingTarget = inAreaTarget.func_178787_e(this.startPoint);
        BlockPos offset = new BlockPos(workingTarget);
        Vector3d inBlockTarget = new Vector3d(workingTarget.func_82615_a() - (double)offset.func_177958_n(), workingTarget.func_82617_b() - (double)offset.func_177956_o(), workingTarget.func_82616_c() - (double)offset.func_177952_p());
        this.clearInBlockTarget(offset, inBlockTarget);
    }

    @Override
    public void clearInBlockTarget(BlockPos inAreaBlockPosOffset, Vector3d inBlockTarget) {
        Vector3d workingTarget = Vector3d.func_237491_b_((Vector3i)inAreaBlockPosOffset).func_178787_e(inBlockTarget);
        if (workingTarget.func_82615_a() < this.startPoint.func_82615_a() || workingTarget.func_82617_b() < this.startPoint.func_82617_b() || workingTarget.func_82616_c() < this.startPoint.func_82616_c() || workingTarget.func_82615_a() > this.endPoint.func_82615_a() || workingTarget.func_82617_b() > this.endPoint.func_82617_b() || workingTarget.func_82616_c() > this.endPoint.func_82616_c()) {
            throw new IllegalArgumentException("The given target is outside of the operating range of this snapshot!");
        }
        if (!this.snapshots.containsKey(inAreaBlockPosOffset)) {
            throw new IllegalArgumentException("The given in area block pos offset is outside of the target range!");
        }
        this.snapshots.get(inAreaBlockPosOffset).clearInAreaTarget(inBlockTarget);
    }

    @Override
    public IMultiStateItemStack toItemStack() {
        throw new NotImplementedException("Multi block snapshots can not be contained in an itemstack as of now.");
    }

    @Override
    public IMultiStateObjectStatistics getStatics() {
        return new IMultiStateObjectStatistics(){

            public CompoundNBT serializeNBT() {
                return new CompoundNBT();
            }

            public void deserializeNBT(CompoundNBT nbt) {
            }

            @Override
            public BlockState getPrimaryState() {
                return this.getStateCounts().entrySet().stream().max(Comparator.comparingInt(Map.Entry::getValue)).map(Map.Entry::getKey).orElse(Blocks.field_150350_a.func_176223_P());
            }

            @Override
            public boolean isEmpty() {
                Map<BlockState, Integer> stateMap = this.getStateCounts();
                return stateMap.size() == 1 && stateMap.getOrDefault(Blocks.field_150350_a.func_176223_P(), 0) > 0;
            }

            @Override
            public Map<BlockState, Integer> getStateCounts() {
                return MultiBlockMultiStateSnapshot.this.stream().collect(Collectors.toMap(IStateEntryInfo::getState, s -> 1, Integer::sum));
            }

            @Override
            public boolean shouldCheckWeakPower() {
                throw new NotImplementedException("Is a snapshot");
            }

            @Override
            public float getFullnessFactor() {
                throw new NotImplementedException("Is a snapshot");
            }

            @Override
            public float getSlipperiness() {
                throw new NotImplementedException("Is a snapshot");
            }

            @Override
            public float getLightEmissionFactor() {
                throw new NotImplementedException("Is a snapshot");
            }

            @Override
            public float getRelativeBlockHardness(PlayerEntity player) {
                throw new NotImplementedException("Is a snapshot");
            }

            @Override
            public boolean canPropagateSkylight() {
                throw new NotImplementedException("Is a snapshot");
            }
        };
    }

    @Override
    public void rotate(Direction.Axis axis, int rotationCount) {
        Vector3d center = this.startPoint.func_178787_e(this.endPoint).func_216372_d(0.5, 0.5, 0.5);
        Map<BlockPos, IMultiStateSnapshot> rotatedParts = this.snapshots.entrySet().stream().collect(Collectors.toMap(e -> {
            Vector3d offSetPos = Vector3d.func_237491_b_((Vector3i)((Vector3i)e.getKey())).func_178788_d(center);
            Vector3d rotatedOffset = VectorUtils.rotateMultipleTimes90Degrees(offSetPos, axis, rotationCount);
            return new BlockPos(this.startPoint.func_178787_e(rotatedOffset));
        }, e -> {
            IMultiStateSnapshot clone = ((IMultiStateSnapshot)e.getValue()).clone();
            clone.rotate(axis, rotationCount);
            return clone;
        }));
        Vector3d rotatedStartPoint = VectorUtils.rotateMultipleTimes90Degrees(this.startPoint.func_178788_d(center), axis, rotationCount).func_178787_e(center);
        Vector3d rotatedEndPoint = VectorUtils.rotateMultipleTimes90Degrees(this.endPoint.func_178788_d(center), axis, rotationCount).func_178787_e(center);
        Vector3d newStartPoint = VectorUtils.minimize(rotatedStartPoint, rotatedEndPoint);
        Vector3d newEndPoint = VectorUtils.maximize(rotatedStartPoint, rotatedEndPoint);
        this.snapshots = rotatedParts;
        this.startPoint = newStartPoint;
        this.endPoint = newEndPoint;
    }

    @Override
    public void mirror(Direction.Axis axis) {
        Vector3d center = this.startPoint.func_178787_e(this.endPoint).func_216372_d(0.5, 0.5, 0.5);
        this.snapshots = this.snapshots.entrySet().stream().collect(Collectors.toMap(e -> {
            int mirroredX = axis == Direction.Axis.X ? (int)(center.func_82615_a() - (double)((BlockPos)e.getKey()).func_177958_n()) : ((BlockPos)e.getKey()).func_177958_n();
            int mirroredY = axis == Direction.Axis.Y ? (int)(center.func_82617_b() - (double)((BlockPos)e.getKey()).func_177956_o()) : ((BlockPos)e.getKey()).func_177956_o();
            int mirroredZ = axis == Direction.Axis.Z ? (int)(center.func_82616_c() - (double)((BlockPos)e.getKey()).func_177952_p()) : ((BlockPos)e.getKey()).func_177952_p();
            return new BlockPos(mirroredX, mirroredY, mirroredZ);
        }, e -> {
            IMultiStateSnapshot clone = ((IMultiStateSnapshot)e.getValue()).clone();
            clone.mirror(axis);
            return clone;
        }));
    }

    @Override
    public IMultiStateSnapshot clone() {
        Map<BlockPos, IMultiStateSnapshot> clonedSnapshots = this.snapshots.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((IMultiStateSnapshot)e.getValue()).clone()));
        return new MultiBlockMultiStateSnapshot(clonedSnapshots, this.startPoint, this.endPoint);
    }

    private static final class Identifier
    implements IAreaShapeIdentifier {
        private final Collection<IAreaShapeIdentifier> inners;

        public Identifier(Collection<IMultiStateSnapshot> innerSnapshots) {
            this.inners = innerSnapshots.stream().map(IAreaAccessor::createNewShapeIdentifier).collect(Collectors.toList());
        }

        public int hashCode() {
            return Objects.hash(this.inners);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Identifier)) {
                return false;
            }
            Identifier that = (Identifier)o;
            return this.inners.equals(that.inners);
        }
    }
}

