/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.common.init;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.Locale;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="chisel")
@ParametersAreNonnullByDefault
public class ChiselSounds {
    @SoundName(value="block.metal.break")
    public static final SoundEvent metal_break = null;
    @SoundName(value="block.metal.fall")
    public static final SoundEvent metal_fall = null;
    @SoundName(value="block.metal.hit")
    public static final SoundEvent metal_hit = null;
    @SoundName(value="block.metal.place")
    public static final SoundEvent metal_place = null;
    @SoundName(value="block.metal.step")
    public static final SoundEvent metal_step = null;
    @SoundName(value="chisel.fallback")
    public static final SoundEvent fallback = null;
    @SoundName(value="chisel.wood")
    public static final SoundEvent wood_chisel = null;
    @SoundName(value="chisel.dirt")
    public static final SoundEvent dirt_chisel = null;

    public static void init() {
        for (Field f : ChiselSounds.class.getDeclaredFields()) {
            if (!f.isAnnotationPresent(SoundName.class)) continue;
            SoundEvent evt = (SoundEvent)new SoundEvent(new ResourceLocation("chisel", f.getAnnotation(SoundName.class).value())).setRegistryName(f.getName().toLowerCase(Locale.ROOT));
            ForgeRegistries.SOUND_EVENTS.register((IForgeRegistryEntry)evt);
            ObfuscationReflectionHelper.setPrivateValue(ChiselSounds.class, null, (Object)evt, (String)f.getName());
        }
    }

    private ChiselSounds() {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    private static @interface SoundName {
        public String value();
    }
}

