/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.api.coolant;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.zerono.mods.extremereactors.Log;
import it.zerono.mods.extremereactors.api.ExtremeReactorsAPI;
import it.zerono.mods.extremereactors.api.coolant.Coolant;
import it.zerono.mods.extremereactors.api.coolant.Vapor;
import it.zerono.mods.extremereactors.api.internal.InternalDispatcher;
import it.zerono.mods.extremereactors.api.internal.modpack.wrapper.AddRemoveSection;
import it.zerono.mods.extremereactors.api.internal.modpack.wrapper.ApiWrapper;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public final class FluidsRegistry {
    private static final Map<String, Coolant> s_coolants = new Object2ObjectArrayMap(2);
    private static final Map<String, Vapor> s_vapors = new Object2ObjectArrayMap(2);
    private static final Marker MARKER = MarkerManager.getMarker((String)"API/FluidsRegistry").addParents(new Marker[]{ExtremeReactorsAPI.MARKER});
    private static final Marker WRAPPER = MarkerManager.getMarker((String)"ModPack API Wrapper").addParents(new Marker[]{MARKER});

    public static boolean containsCoolant(String name) {
        return s_coolants.containsKey(name);
    }

    public static boolean containsVapor(String name) {
        return s_vapors.containsKey(name);
    }

    public static Optional<Coolant> getCoolant(String name) {
        return Optional.ofNullable(s_coolants.get(name));
    }

    public static Optional<Vapor> getVapor(String name) {
        return Optional.ofNullable(s_vapors.get(name));
    }

    public static void registerCoolant(String name, float boilingPoint, float enthalpyOfVaporization, String translationKey) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0);
        InternalDispatcher.dispatch("fluid-register", () -> {
            if (s_coolants.containsKey(name)) {
                ExtremeReactorsAPI.LOGGER.warn(MARKER, "Overwriting data for Coolant {}", (Object)name);
            }
            s_coolants.put(name, new Coolant(name, boilingPoint, enthalpyOfVaporization, translationKey));
        });
    }

    public static void removeCoolant(String name) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0);
        InternalDispatcher.dispatch("fluid-remove", () -> s_coolants.remove(name));
    }

    public static void registerVapor(String name, float fluidEnergyDensity, String translationKey) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0);
        InternalDispatcher.dispatch("fluid-register", () -> {
            if (s_vapors.containsKey(name)) {
                ExtremeReactorsAPI.LOGGER.warn(MARKER, "Overwriting data for Vapor {}", (Object)name);
            }
            s_vapors.put(name, new Vapor(name, fluidEnergyDensity, translationKey));
        });
    }

    public static void removeVapor(String name) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0);
        InternalDispatcher.dispatch("fluid-remove", () -> s_vapors.remove(name));
    }

    public static void processWrapper(ApiWrapper wrapper) {
        if (!wrapper.Enabled) {
            return;
        }
        FluidsRegistry.processWrapper("Coolants", wrapper.Coolants, s_coolants, FluidsRegistry::removeCoolant, w -> FluidsRegistry.registerCoolant(w.Name, w.BoilingPoint, w.EnthalpyOfVaporization, w.TranslationKey));
        FluidsRegistry.processWrapper("Vapors", wrapper.Vapors, s_vapors, FluidsRegistry::removeVapor, w -> FluidsRegistry.registerVapor(w.Name, w.FluidEnergyDensity, w.TranslationKey));
    }

    private FluidsRegistry() {
    }

    private static <X, XWrapper> void processWrapper(String objectName, AddRemoveSection<XWrapper> wrapperSection, Map<String, X> registry, Consumer<String> removeAction, Consumer<XWrapper> addAction) {
        if (wrapperSection.WipeExistingValuesBeforeAdding) {
            Log.LOGGER.info(WRAPPER, "Wiping all existing {} sources", (Object)objectName);
            registry.clear();
        } else {
            Arrays.stream(wrapperSection.Remove).filter(name -> !Strings.isNullOrEmpty((String)name)).forEach(removeAction);
        }
        Arrays.stream(wrapperSection.Add).filter(Objects::nonNull).forEach(addAction);
    }
}

