/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.api.reactor;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import it.zerono.mods.extremereactors.Log;
import it.zerono.mods.extremereactors.api.ExtremeReactorsAPI;
import it.zerono.mods.extremereactors.api.internal.InternalDispatcher;
import it.zerono.mods.extremereactors.api.internal.modpack.wrapper.AddRemoveSection;
import it.zerono.mods.extremereactors.api.internal.modpack.wrapper.ApiWrapper;
import it.zerono.mods.extremereactors.api.reactor.Moderator;
import it.zerono.mods.zerocore.lib.tag.CollectionProviders;
import it.zerono.mods.zerocore.lib.tag.TagList;
import it.zerono.mods.zerocore.lib.tag.TagsHelper;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.Item;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

@Mod.EventBusSubscriber(modid="bigreactors", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class ModeratorsRegistry {
    private static final TagList<Block> s_moderatorBlocksTags;
    private static final Map<ResourceLocation, Moderator> s_moderatorBlocksData;
    private static final Map<ResourceLocation, Moderator> s_moderatorFluidsData;
    private static final Marker MARKER;
    private static final Marker WRAPPER;
    private static final ITextComponent TOOLTIP_MODERATOR;

    public static Optional<Moderator> getFrom(BlockState state) {
        if (state.func_196958_f()) {
            return Optional.of(Moderator.AIR);
        }
        FluidState fs = state.func_204520_s();
        if (!fs.func_206888_e() && s_moderatorFluidsData.containsKey(ModeratorsRegistry.getFluidId(fs.func_206886_c()))) {
            return Optional.of(s_moderatorFluidsData.get(ModeratorsRegistry.getFluidId(fs.func_206886_c())));
        }
        return ModeratorsRegistry.getFromSolid(state.func_177230_c());
    }

    public static boolean isValid(BlockState state) {
        if (state.func_196958_f()) {
            return true;
        }
        FluidState fs = state.func_204520_s();
        if (!fs.func_206888_e() && s_moderatorFluidsData.containsKey(ModeratorsRegistry.getFluidId(fs.func_206886_c()))) {
            return true;
        }
        return s_moderatorBlocksTags.find(tag -> tag.func_230235_a_((Object)state.func_177230_c())).filter(t -> t instanceof ITag.INamedTag).map(t -> (ITag.INamedTag)t).map(t -> s_moderatorBlocksData.containsKey(t.func_230234_a_())).orElse(false);
    }

    @Deprecated
    public static Optional<Moderator> getFromSolid(BlockState state) {
        return ModeratorsRegistry.getFromSolid(state.func_177230_c());
    }

    public static Optional<Moderator> getFromSolid(Block block) {
        return s_moderatorBlocksTags.find(tag -> tag.func_230235_a_((Object)block)).filter(t -> t instanceof ITag.INamedTag).map(t -> (ITag.INamedTag)t).flatMap(ModeratorsRegistry::getFromSolid);
    }

    public static Optional<Moderator> getFromSolid(ITag.INamedTag<Block> tag) {
        return Optional.ofNullable(s_moderatorBlocksData.get(tag.func_230234_a_()));
    }

    @Deprecated
    public static Optional<Moderator> getFromFluid(ITag.INamedTag<Fluid> tag) {
        return Optional.empty();
    }

    public static void registerSolid(String tagId, float absorption, float heatEfficiency, float moderation, float heatConductivity) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)tagId) ? 1 : 0) != 0);
        InternalDispatcher.dispatch("moderator-s-register", () -> {
            ResourceLocation id = new ResourceLocation(tagId);
            if (s_moderatorBlocksData.containsKey(id)) {
                ExtremeReactorsAPI.LOGGER.warn(MARKER, "Overriding existing radiation moderator for {}", (Object)id);
            }
            Moderator m = new Moderator(absorption, heatEfficiency, moderation, heatConductivity);
            s_moderatorBlocksData.merge(id, m, (o, n) -> m);
        });
    }

    public static void registerFluid(Fluid fluid, float absorption, float heatEfficiency, float moderation, float heatConductivity) {
        ModeratorsRegistry.registerFluid(ModeratorsRegistry.getFluidIdString(fluid), absorption, heatEfficiency, moderation, heatConductivity);
    }

    public static void registerFluid(String fluidId, float absorption, float heatEfficiency, float moderation, float heatConductivity) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)fluidId) ? 1 : 0) != 0);
        InternalDispatcher.dispatch("moderator-f-register", () -> {
            ResourceLocation id = new ResourceLocation(fluidId);
            if (s_moderatorFluidsData.containsKey(id)) {
                ExtremeReactorsAPI.LOGGER.warn(MARKER, "Overriding existing radiation moderator for {}", (Object)id);
            }
            Moderator m = new Moderator(absorption, heatEfficiency, moderation, heatConductivity);
            s_moderatorFluidsData.merge(id, m, (o, n) -> m);
        });
    }

    public static void removeSolid(ITag.INamedTag<Block> tag) {
        Preconditions.checkNotNull(tag);
        ModeratorsRegistry.removeSolid(tag.func_230234_a_());
    }

    public static void removeSolid(ResourceLocation id) {
        Preconditions.checkNotNull((Object)id);
        InternalDispatcher.dispatch("moderator-s-remove", () -> s_moderatorBlocksData.remove(id));
    }

    public static void removeFluid(Fluid fluid) {
        Preconditions.checkNotNull((Object)fluid);
        ModeratorsRegistry.removeFluid(ModeratorsRegistry.getFluidId(fluid));
    }

    public static void removeFluid(ResourceLocation id) {
        Preconditions.checkNotNull((Object)id);
        InternalDispatcher.dispatch("moderator-f-remove", () -> s_moderatorFluidsData.remove(id));
    }

    public static void fillModeratorsTooltips(Map<Item, Set<ITextComponent>> tooltipsMap, NonNullSupplier<Set<ITextComponent>> setSupplier) {
        s_moderatorBlocksTags.tagStream().flatMap(blockTag -> blockTag.func_230236_b_().stream()).map(Block::func_199767_j).forEach(item -> tooltipsMap.computeIfAbsent((Item)item, k -> (Set)setSupplier.get()).add(TOOLTIP_MODERATOR));
        s_moderatorFluidsData.keySet().stream().filter(arg_0 -> ((IForgeRegistry)ForgeRegistries.FLUIDS).containsKey(arg_0)).map(arg_0 -> ((IForgeRegistry)ForgeRegistries.FLUIDS).getValue(arg_0)).filter(Objects::nonNull).map(Fluid::func_204524_b).forEach(item -> tooltipsMap.computeIfAbsent((Item)item, k -> (Set)setSupplier.get()).add(TOOLTIP_MODERATOR));
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onVanillaTagsUpdated(TagsUpdatedEvent.VanillaTagTypes event) {
        ModeratorsRegistry.updateTags(s_moderatorBlocksData.keySet(), s_moderatorBlocksTags, TagsHelper.BLOCKS);
    }

    public static void processWrapper(ApiWrapper wrapper) {
        if (!wrapper.Enabled) {
            return;
        }
        ModeratorsRegistry.processWrapper("solid", wrapper.ReactorSolidModerators, s_moderatorBlocksData, name -> ModeratorsRegistry.removeSolid(new ResourceLocation(name)), w -> ModeratorsRegistry.registerSolid(w.TagId, w.Absorption, w.HeatEfficiency, w.Moderation, w.HeatConductivity));
        ModeratorsRegistry.processWrapper("fluid", wrapper.ReactorFluidModerators, s_moderatorFluidsData, name -> ModeratorsRegistry.removeFluid(new ResourceLocation(name)), w -> ModeratorsRegistry.registerFluid(w.TagId, w.Absorption, w.HeatEfficiency, w.Moderation, w.HeatConductivity));
    }

    private ModeratorsRegistry() {
    }

    private static <T> void updateTags(Set<ResourceLocation> ids, TagList<T> tagList, TagsHelper<T> helper) {
        tagList.clear();
        ids.stream().filter(arg_0 -> helper.tagExist(arg_0)).map(arg_0 -> helper.createTag(arg_0)).forEach(arg_0 -> tagList.addTag(arg_0));
    }

    private static <X> void processWrapper(String objectName, AddRemoveSection<it.zerono.mods.extremereactors.api.internal.modpack.wrapper.Moderator> wrapperSection, Map<ResourceLocation, Moderator> registry, Consumer<String> removeAction, Consumer<it.zerono.mods.extremereactors.api.internal.modpack.wrapper.Moderator> addAction) {
        if (wrapperSection.WipeExistingValuesBeforeAdding) {
            Log.LOGGER.info(WRAPPER, "Wiping all existing {} Reactor Moderators", (Object)objectName);
            registry.clear();
        } else {
            Arrays.stream(wrapperSection.Remove).filter(name -> !Strings.isNullOrEmpty((String)name)).forEach(removeAction);
        }
        Arrays.stream(wrapperSection.Add).filter(Objects::nonNull).forEach(addAction);
    }

    private static ResourceLocation getFluidId(Fluid fluid) {
        return Objects.requireNonNull(fluid.getRegistryName());
    }

    private static String getFluidIdString(Fluid fluid) {
        return ModeratorsRegistry.getFluidId(fluid).toString();
    }

    static {
        MARKER = MarkerManager.getMarker((String)"API/ModeratorsRegistry").addParents(new Marker[]{ExtremeReactorsAPI.MARKER});
        WRAPPER = MarkerManager.getMarker((String)"ModPack API Wrapper").addParents(new Marker[]{MARKER});
        TOOLTIP_MODERATOR = new TranslationTextComponent("api.bigreactors.reactor.tooltip.moderator").func_230530_a_(ExtremeReactorsAPI.STYLE_TOOLTIP);
        s_moderatorBlocksTags = new TagList(CollectionProviders.BLOCKS_PROVIDER);
        s_moderatorBlocksData = Maps.newHashMap();
        s_moderatorFluidsData = Maps.newHashMap();
    }
}

