/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.config;

import it.zerono.mods.extremereactors.config.Client;
import it.zerono.mods.extremereactors.config.Common;
import it.zerono.mods.zerocore.lib.CodeHelper;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public final class Config {
    public static final Client CLIENT;
    public static final Common COMMON;
    private static final ForgeConfigSpec s_clientSpec;
    private static final ForgeConfigSpec s_commonSpec;

    public static void initialize() {
        Config.register(ModConfig.Type.CLIENT, s_clientSpec);
        Config.register(ModConfig.Type.COMMON, s_commonSpec);
    }

    private static void register(ModConfig.Type type, ForgeConfigSpec spec) {
        ModLoadingContext.get().registerConfig(type, spec, String.format("extremereactors/%s.toml", type.extension()));
    }

    static {
        if (!CodeHelper.ioCreateModConfigDirectory((String)"extremereactors")) {
            throw new RuntimeException("Unable to create a directory for the Extreme Reactors config files");
        }
        Pair pair1 = new ForgeConfigSpec.Builder().configure(Client::new);
        Pair pair2 = new ForgeConfigSpec.Builder().configure(Common::new);
        CLIENT = (Client)pair1.getLeft();
        s_clientSpec = (ForgeConfigSpec)pair1.getRight();
        COMMON = (Common)pair2.getLeft();
        s_commonSpec = (ForgeConfigSpec)pair2.getRight();
    }
}

