/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.datagen.recipes;

import it.zerono.mods.extremereactors.ExtremeReactors;
import it.zerono.mods.extremereactors.datagen.recipes.AbstractRecipeGenerator;
import it.zerono.mods.extremereactors.gamecontent.Content;
import it.zerono.mods.extremereactors.gamecontent.ContentTags;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.variant.IMultiblockGeneratorVariant;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.variant.ReactorVariant;
import it.zerono.mods.zerocore.lib.compat.Mods;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.data.ShapelessRecipeBuilder;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.ConditionalRecipe;
import net.minecraftforge.fml.RegistryObject;

public class ReactorRecipeGenerator
extends AbstractRecipeGenerator {
    public ReactorRecipeGenerator(DataGenerator generatorIn) {
        super(generatorIn);
    }

    public String func_200397_b() {
        return "Extreme Reactors 2 Reactor recipes";
    }

    protected void func_200404_a(Consumer<IFinishedRecipe> c) {
        ReactorVariant variant = ReactorVariant.Basic;
        RegistryObject<BlockItem> casing = Content.Items.REACTOR_CASING_BASIC;
        Tags.IOptionalNamedTag core = Tags.Items.SAND;
        Tags.IOptionalNamedTag metal = Tags.Items.INGOTS_IRON;
        Tags.IOptionalNamedTag alternativeMetal = null;
        this.reactorCasing(c, variant, (Supplier<? extends IItemProvider>)Content.Items.REACTOR_CASING_BASIC, (ITag<Item>)core, (ITag.INamedTag<Item>)metal, (ITag.INamedTag<Item>)alternativeMetal);
        this.reactorGlass(c, variant, (Supplier<? extends IItemProvider>)Content.Items.REACTOR_GLASS_BASIC, (Supplier<? extends IItemProvider>)casing, (ITag<Item>)Tags.Items.GLASS);
        this.reactorController(c, variant, (Supplier<? extends IItemProvider>)Content.Items.REACTOR_CONTROLLER_BASIC, (Supplier<? extends IItemProvider>)casing, (ITag<Item>)Tags.Items.GEMS_DIAMOND);
        this.reactorFuelRod(c, variant, (Supplier<? extends IItemProvider>)Content.Items.REACTOR_FUELROD_BASIC, (ITag.INamedTag<Item>)metal, (ITag.INamedTag<Item>)alternativeMetal, (ITag<Item>)Tags.Items.GLASS);
        this.reactorControlRod(c, variant, (Supplier<? extends IItemProvider>)Content.Items.REACTOR_CONTROLROD_BASIC, (Supplier<? extends IItemProvider>)casing, (ITag.INamedTag<Item>)metal, (ITag.INamedTag<Item>)alternativeMetal);
        this.reactorSolidAccessPort(c, variant, (Supplier<? extends IItemProvider>)Content.Items.REACTOR_SOLID_ACCESSPORT_BASIC, (Supplier<? extends IItemProvider>)casing, (ITag.INamedTag<Item>)metal, (ITag.INamedTag<Item>)alternativeMetal);
        this.reactorPowerTap(c, variant, "fe", (Supplier<? extends IItemProvider>)Content.Items.REACTOR_POWERTAP_FE_PASSIVE_BASIC, (Supplier<? extends IItemProvider>)Content.Items.REACTOR_POWERTAP_FE_ACTIVE_BASIC, (Supplier<? extends IItemProvider>)casing, (Supplier<? extends IItemProvider>)((Supplier<IItemProvider>)() -> Items.field_221858_em), (Supplier<? extends IItemProvider>)((Supplier<IItemProvider>)() -> Items.field_151137_ax));
        this.reactorRedstonePort(c, variant, (Supplier<? extends IItemProvider>)Content.Items.REACTOR_REDSTONEPORT_BASIC, (Supplier<? extends IItemProvider>)casing, (ITag.INamedTag<Item>)metal, (ITag.INamedTag<Item>)alternativeMetal, (ITag<Item>)Tags.Items.INGOTS_GOLD);
        this.generatorChargingPort(c, variant, "chargingfe", "bigreactors:reactor", ReactorRecipeGenerator::reactorRecipeName, (Supplier<? extends IItemProvider>)Content.Items.REACTOR_CHARGINGPORT_FE_BASIC, (Supplier<? extends IItemProvider>)Content.Items.REACTOR_POWERTAP_FE_ACTIVE_BASIC, (IItemProvider)Items.field_196128_bn, (IItemProvider)Items.field_151137_ax);
        this.reactorCasingRecycle(c, variant, (Supplier<? extends IItemProvider>)Content.Items.REACTOR_CASING_BASIC, ContentTags.Items.USING_REACTOR_CASING_BASIC, (Supplier<? extends IItemProvider>)Content.Items.REACTOR_GLASS_BASIC);
        variant = ReactorVariant.Reinforced;
        casing = Content.Items.REACTOR_CASING_REINFORCED;
        core = Tags.Items.STORAGE_BLOCKS_IRON;
        metal = TAG_INGOTS_STEEL;
        alternativeMetal = Tags.Items.STORAGE_BLOCKS_IRON;
        this.reactorCasing(c, variant, (Supplier<? extends IItemProvider>)Content.Items.REACTOR_CASING_REINFORCED, (ITag<Item>)core, (ITag.INamedTag<Item>)metal, (ITag.INamedTag<Item>)alternativeMetal);
        this.reactorCasingUpgrade(c, variant, (Supplier<? extends IItemProvider>)Content.Items.REACTOR_CASING_REINFORCED, (ITag.INamedTag<Item>)metal, (ITag.INamedTag<Item>)alternativeMetal);
        this.reactorGlass(c, variant, (Supplier<? extends IItemProvider>)Content.Items.REACTOR_GLASS_REINFORCED, (Supplier<? extends IItemProvider>)casing, (ITag<Item>)Tags.Items.GLASS);
        this.reactorController(c, variant, (Supplier<? extends IItemProvider>)Content.Items.REACTOR_CONTROLLER_REINFORCED, (Supplier<? extends IItemProvider>)casing, (ITag<Item>)Tags.Items.STORAGE_BLOCKS_DIAMOND);
        this.reactorFuelRod(c, variant, (Supplier<? extends IItemProvider>)Content.Items.REACTOR_FUELROD_REINFORCED, (ITag.INamedTag<Item>)metal, (ITag.INamedTag<Item>)alternativeMetal, (ITag<Item>)Tags.Items.GLASS);
        this.reactorControlRod(c, variant, (Supplier<? extends IItemProvider>)Content.Items.REACTOR_CONTROLROD_REINFORCED, (Supplier<? extends IItemProvider>)casing, (ITag.INamedTag<Item>)metal, (ITag.INamedTag<Item>)alternativeMetal);
        this.reactorSolidAccessPort(c, variant, (Supplier<? extends IItemProvider>)Content.Items.REACTOR_SOLID_ACCESSPORT_REINFORCED, (Supplier<? extends IItemProvider>)casing, (ITag.INamedTag<Item>)metal, (ITag.INamedTag<Item>)alternativeMetal);
        this.reactorPowerTap(c, variant, "fe", (Supplier<? extends IItemProvider>)Content.Items.REACTOR_POWERTAP_FE_PASSIVE_REINFORCED, (Supplier<? extends IItemProvider>)Content.Items.REACTOR_POWERTAP_FE_ACTIVE_REINFORCED, (Supplier<? extends IItemProvider>)casing, (Supplier<? extends IItemProvider>)((Supplier<IItemProvider>)() -> Items.field_221858_em), (Supplier<? extends IItemProvider>)((Supplier<IItemProvider>)() -> Items.field_151137_ax));
        this.reactorRedstonePort(c, variant, (Supplier<? extends IItemProvider>)Content.Items.REACTOR_REDSTONEPORT_REINFORCED, (Supplier<? extends IItemProvider>)casing, (ITag.INamedTag<Item>)metal, (ITag.INamedTag<Item>)alternativeMetal, (ITag<Item>)Tags.Items.STORAGE_BLOCKS_GOLD);
        this.reactorComputerPort(c, variant, (Supplier<? extends IItemProvider>)Content.Items.REACTOR_COMPUTERPORT_REINFORCED, (Supplier<? extends IItemProvider>)casing, (ITag.INamedTag<Item>)metal, (ITag.INamedTag<Item>)alternativeMetal);
        this.reactorFluidPort(c, variant, "forge", (Supplier<? extends IItemProvider>)Content.Items.REACTOR_FLUIDPORT_FORGE_PASSIVE_REINFORCED, (Supplier<? extends IItemProvider>)Content.Items.REACTOR_FLUIDPORT_FORGE_ACTIVE_REINFORCED, (Supplier<? extends IItemProvider>)casing, (Supplier<? extends IItemProvider>)((Supplier<IItemProvider>)() -> Items.field_151129_at), (Supplier<? extends IItemProvider>)((Supplier<IItemProvider>)() -> Items.field_151131_as));
        this.reactorMekFluidPort(c, variant, (Supplier<? extends IItemProvider>)Content.Items.REACTOR_FLUIDPORT_MEKANISM_PASSIVE_REINFORCED, (Supplier<? extends IItemProvider>)casing, (Supplier<? extends IItemProvider>)((Supplier<IItemProvider>)() -> Items.field_151129_at), (Supplier<? extends IItemProvider>)((Supplier<IItemProvider>)() -> Items.field_151131_as));
        this.generatorChargingPort(c, variant, "chargingfe", "bigreactors:reactor", ReactorRecipeGenerator::reactorRecipeName, (Supplier<? extends IItemProvider>)Content.Items.REACTOR_CHARGINGPORT_FE_REINFORCED, (Supplier<? extends IItemProvider>)Content.Items.REACTOR_POWERTAP_FE_ACTIVE_REINFORCED, (IItemProvider)Items.field_221654_ao, (IItemProvider)Items.field_221858_em);
        this.reactorCasingRecycle(c, variant, (Supplier<? extends IItemProvider>)Content.Items.REACTOR_CASING_REINFORCED, ContentTags.Items.USING_REACTOR_CASING_REINFORCED, (Supplier<? extends IItemProvider>)Content.Items.REACTOR_GLASS_REINFORCED);
    }

    private void reactorCasing(Consumer<IFinishedRecipe> c, ReactorVariant variant, Supplier<? extends IItemProvider> result, ITag<Item> core, ITag.INamedTag<Item> metal, @Nullable ITag.INamedTag<Item> alternativeMetal) {
        ReactorRecipeGenerator.recipeWithAlternativeTag(c, (ResourceLocation)ReactorRecipeGenerator.reactorRecipeName(variant, "casing"), (ResourceLocation)ReactorRecipeGenerator.reactorRecipeName(variant, "casing_alt"), metal, alternativeMetal, metalTag -> ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)result.get())).func_200469_a(Character.valueOf('I'), (ITag)metalTag).func_200469_a(Character.valueOf('C'), core).func_200469_a(Character.valueOf('G'), ContentTags.Items.INGOTS_GRAPHITE).func_200472_a("IGI").func_200472_a("GCG").func_200472_a("IGI").func_200473_b("bigreactors:reactor").func_200465_a("has_item", (ICriterionInstance)ReactorRecipeGenerator.func_200409_a(ContentTags.Items.INGOTS_GRAPHITE)));
    }

    private void reactorCasingUpgrade(Consumer<IFinishedRecipe> c, ReactorVariant variant, Supplier<? extends IItemProvider> result, ITag.INamedTag<Item> metal, @Nullable ITag.INamedTag<Item> alternativeMetal) {
        ReactorRecipeGenerator.recipeWithAlternativeTag(c, (ResourceLocation)ReactorRecipeGenerator.reactorRecipeName(variant, "casing_upgrade"), (ResourceLocation)ReactorRecipeGenerator.reactorRecipeName(variant, "casing_upgrade_alt"), metal, alternativeMetal, metalTag -> ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)result.get())).func_200469_a(Character.valueOf('I'), (ITag)metalTag).func_200462_a(Character.valueOf('C'), (IItemProvider)Content.Blocks.REACTOR_CASING_BASIC.get()).func_200469_a(Character.valueOf('G'), ContentTags.Items.INGOTS_GRAPHITE).func_200472_a("IGI").func_200472_a("GCG").func_200472_a("IGI").func_200473_b("bigreactors:reactor").func_200465_a("has_item", (ICriterionInstance)ReactorRecipeGenerator.func_200403_a((IItemProvider)((IItemProvider)Content.Blocks.REACTOR_CASING_BASIC.get()))));
    }

    private void reactorCasingRecycle(Consumer<IFinishedRecipe> c, ReactorVariant variant, Supplier<? extends IItemProvider> casingResult, ITag.INamedTag<Item> casingSourceTag, Supplier<? extends IItemProvider> glassSourceItem) {
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)casingResult.get(), (int)1).func_200487_b(glassSourceItem.get()).func_200490_a("bigreactors:reactor").func_200483_a("has_item", (ICriterionInstance)ReactorRecipeGenerator.func_200403_a((IItemProvider)glassSourceItem.get())).func_200485_a(c, ReactorRecipeGenerator.reactorRecipeName(variant, "casing_recycle_glass"));
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)casingResult.get(), (int)4).func_203221_a(casingSourceTag).func_200490_a("bigreactors:reactor").func_200483_a("has_item", (ICriterionInstance)ReactorRecipeGenerator.func_200409_a(casingSourceTag)).func_200485_a(c, ReactorRecipeGenerator.reactorRecipeName(variant, "casing_recycle"));
    }

    private void reactorGlass(Consumer<IFinishedRecipe> c, ReactorVariant variant, Supplier<? extends IItemProvider> result, Supplier<? extends IItemProvider> casing, ITag<Item> glass) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)result.get()).func_200462_a(Character.valueOf('C'), casing.get()).func_200469_a(Character.valueOf('G'), glass).func_200472_a("GCG").func_200473_b("bigreactors:reactor").func_200465_a("has_item", (ICriterionInstance)ReactorRecipeGenerator.func_200403_a((IItemProvider)casing.get())).func_200467_a(c, ReactorRecipeGenerator.reactorRecipeName(variant, "glass"));
    }

    private void reactorController(Consumer<IFinishedRecipe> c, ReactorVariant variant, Supplier<? extends IItemProvider> result, Supplier<? extends IItemProvider> casing, ITag<Item> diamond) {
        TAGS_YELLORIUM_INGOTS.forEach(yellorium -> ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)result.get())).func_200462_a(Character.valueOf('C'), (IItemProvider)casing.get()).func_200469_a(Character.valueOf('Y'), (ITag)yellorium).func_200469_a(Character.valueOf('R'), (ITag)Tags.Items.DUSTS_REDSTONE).func_200469_a(Character.valueOf('D'), diamond).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_222029_iU).func_200472_a("CXC").func_200472_a("YDY").func_200472_a("CRC").func_200473_b("bigreactors:reactor").func_200465_a("has_item", (ICriterionInstance)ReactorRecipeGenerator.func_200403_a((IItemProvider)((IItemProvider)casing.get()))).func_200465_a("has_item2", (ICriterionInstance)ReactorRecipeGenerator.func_200409_a((ITag)yellorium)).func_200467_a(c, ReactorRecipeGenerator.reactorRecipeName(variant, "controller", (ITag.INamedTag<Item>)yellorium)));
    }

    private void reactorFuelRod(Consumer<IFinishedRecipe> c, ReactorVariant variant, Supplier<? extends IItemProvider> result, ITag.INamedTag<Item> metal, @Nullable ITag.INamedTag<Item> alternativeMetal, ITag<Item> glass) {
        TAGS_YELLORIUM_INGOTS.forEach(yellorium -> ReactorRecipeGenerator.recipeWithAlternativeTag((Consumer)c, (ResourceLocation)ReactorRecipeGenerator.reactorRecipeName(variant, "fuelrod", (ITag.INamedTag<Item>)yellorium), (ResourceLocation)ReactorRecipeGenerator.reactorRecipeName(variant, "fuelrod_alt", (ITag.INamedTag<Item>)yellorium), (ITag.INamedTag)metal, (ITag.INamedTag)alternativeMetal, arg_0 -> ReactorRecipeGenerator.lambda$null$11((Supplier)result, yellorium, glass, arg_0)));
    }

    private void reactorControlRod(Consumer<IFinishedRecipe> c, ReactorVariant variant, Supplier<? extends IItemProvider> result, Supplier<? extends IItemProvider> casing, ITag.INamedTag<Item> metal, @Nullable ITag.INamedTag<Item> alternativeMetal) {
        ReactorRecipeGenerator.recipeWithAlternativeTag(c, (ResourceLocation)ReactorRecipeGenerator.reactorRecipeName(variant, "controlrod"), (ResourceLocation)ReactorRecipeGenerator.reactorRecipeName(variant, "controlrod_alt"), metal, alternativeMetal, metalTag -> ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)result.get())).func_200462_a(Character.valueOf('C'), (IItemProvider)casing.get()).func_200469_a(Character.valueOf('M'), (ITag)metalTag).func_200469_a(Character.valueOf('R'), (ITag)Tags.Items.DUSTS_REDSTONE).func_200469_a(Character.valueOf('G'), ContentTags.Items.INGOTS_GRAPHITE).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_221602_aD).func_200472_a("CRC").func_200472_a("MXM").func_200472_a("CGC").func_200473_b("bigreactors:reactor").func_200465_a("has_item", (ICriterionInstance)ReactorRecipeGenerator.func_200403_a((IItemProvider)((IItemProvider)casing.get()))));
    }

    private void reactorPowerTap(Consumer<IFinishedRecipe> c, ReactorVariant variant, String name, Supplier<? extends IItemProvider> passiveResult, Supplier<? extends IItemProvider> activeResult, Supplier<? extends IItemProvider> casing, Supplier<? extends IItemProvider> energyBig, Supplier<? extends IItemProvider> energySmall) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)passiveResult.get()).func_200462_a(Character.valueOf('C'), casing.get()).func_200462_a(Character.valueOf('B'), energyBig.get()).func_200462_a(Character.valueOf('S'), energySmall.get()).func_200472_a("CSC").func_200472_a("SBS").func_200472_a("CSC").func_200473_b("bigreactors:reactor").func_200465_a("has_item", (ICriterionInstance)ReactorRecipeGenerator.func_200403_a((IItemProvider)casing.get())).func_200465_a("has_item2", (ICriterionInstance)ReactorRecipeGenerator.func_200403_a((IItemProvider)energySmall.get())).func_200467_a(c, ReactorRecipeGenerator.reactorRecipeName(variant, "passivetap_" + name));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)activeResult.get()).func_200462_a(Character.valueOf('C'), casing.get()).func_200462_a(Character.valueOf('B'), energyBig.get()).func_200462_a(Character.valueOf('S'), energySmall.get()).func_200472_a("CBC").func_200472_a("BSB").func_200472_a("CBC").func_200473_b("bigreactors:reactor").func_200465_a("has_item", (ICriterionInstance)ReactorRecipeGenerator.func_200403_a((IItemProvider)casing.get())).func_200465_a("has_item2", (ICriterionInstance)ReactorRecipeGenerator.func_200403_a((IItemProvider)energyBig.get())).func_200467_a(c, ReactorRecipeGenerator.reactorRecipeName(variant, "activetap_" + name));
    }

    private void reactorFluidPort(Consumer<IFinishedRecipe> c, ReactorVariant variant, String name, Supplier<? extends IItemProvider> passiveResult, Supplier<? extends IItemProvider> activeResult, Supplier<? extends IItemProvider> casing, Supplier<? extends IItemProvider> lava, Supplier<? extends IItemProvider> water) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)passiveResult.get()).func_200462_a(Character.valueOf('C'), casing.get()).func_200462_a(Character.valueOf('B'), lava.get()).func_200462_a(Character.valueOf('S'), water.get()).func_200472_a("CSC").func_200472_a("SBS").func_200472_a("CSC").func_200473_b("bigreactors:reactor").func_200465_a("has_item", (ICriterionInstance)ReactorRecipeGenerator.func_200403_a((IItemProvider)casing.get())).func_200465_a("has_item2", (ICriterionInstance)ReactorRecipeGenerator.func_200403_a((IItemProvider)water.get())).func_200467_a(c, ReactorRecipeGenerator.reactorRecipeName(variant, "passivefluidport_" + name));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)activeResult.get()).func_200462_a(Character.valueOf('C'), casing.get()).func_200462_a(Character.valueOf('B'), lava.get()).func_200462_a(Character.valueOf('S'), water.get()).func_200472_a("CBC").func_200472_a("BSB").func_200472_a("CBC").func_200473_b("bigreactors:reactor").func_200465_a("has_item", (ICriterionInstance)ReactorRecipeGenerator.func_200403_a((IItemProvider)casing.get())).func_200465_a("has_item2", (ICriterionInstance)ReactorRecipeGenerator.func_200403_a((IItemProvider)lava.get())).func_200467_a(c, ReactorRecipeGenerator.reactorRecipeName(variant, "activefluidport_" + name));
    }

    private void reactorMekFluidPort(Consumer<IFinishedRecipe> c, ReactorVariant variant, Supplier<? extends IItemProvider> passiveResult, Supplier<? extends IItemProvider> casing, Supplier<? extends IItemProvider> lava, Supplier<? extends IItemProvider> water) {
        ConditionalRecipe.builder().addCondition(ReactorRecipeGenerator.modLoaded((String)Mods.MEKANISM.id())).addRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200470_a((IItemProvider)passiveResult.get()).func_200462_a(Character.valueOf('C'), casing.get()).func_200462_a(Character.valueOf('B'), lava.get()).func_200462_a(Character.valueOf('S'), water.get()).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_221739_dF).func_200472_a("CSC").func_200472_a("BXB").func_200472_a("CSC").func_200473_b("bigreactors:reactor").func_200465_a("has_item", (ICriterionInstance)ReactorRecipeGenerator.func_200403_a((IItemProvider)casing.get())).func_200465_a("has_item2", (ICriterionInstance)ReactorRecipeGenerator.func_200403_a((IItemProvider)water.get()))).func_200464_a(arg_0)).build(c, ReactorRecipeGenerator.reactorRecipeName(variant, "passivefluidport_mekanism"));
    }

    private void reactorSolidAccessPort(Consumer<IFinishedRecipe> c, ReactorVariant variant, Supplier<? extends IItemProvider> result, Supplier<? extends IItemProvider> casing, ITag.INamedTag<Item> metal, @Nullable ITag.INamedTag<Item> alternativeMetal) {
        ReactorRecipeGenerator.recipeWithAlternativeTag(c, (ResourceLocation)ReactorRecipeGenerator.reactorRecipeName(variant, "solidaccessport"), (ResourceLocation)ReactorRecipeGenerator.reactorRecipeName(variant, "solidaccessport_alt"), metal, alternativeMetal, metalTag -> ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)result.get())).func_200462_a(Character.valueOf('C'), (IItemProvider)casing.get()).func_200469_a(Character.valueOf('M'), (ITag)metalTag).func_200462_a(Character.valueOf('H'), (IItemProvider)Items.field_221862_eo).func_200469_a(Character.valueOf('W'), (ITag)Tags.Items.CHESTS_WOODEN).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_221602_aD).func_200472_a("CHC").func_200472_a("MWM").func_200472_a("CXC").func_200473_b("bigreactors:reactor").func_200465_a("has_item", (ICriterionInstance)ReactorRecipeGenerator.func_200403_a((IItemProvider)((IItemProvider)casing.get()))));
    }

    private void reactorRedstonePort(Consumer<IFinishedRecipe> c, ReactorVariant variant, Supplier<? extends IItemProvider> result, Supplier<? extends IItemProvider> casing, ITag.INamedTag<Item> metal, @Nullable ITag.INamedTag<Item> alternativeMetal, ITag<Item> gold) {
        ReactorRecipeGenerator.recipeWithAlternativeTag(c, (ResourceLocation)ReactorRecipeGenerator.reactorRecipeName(variant, "redstoneport"), (ResourceLocation)ReactorRecipeGenerator.reactorRecipeName(variant, "redstoneport_alt"), metal, alternativeMetal, metalTag -> ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)result.get())).func_200462_a(Character.valueOf('C'), (IItemProvider)casing.get()).func_200469_a(Character.valueOf('M'), (ITag)metalTag).func_200469_a(Character.valueOf('G'), gold).func_200462_a(Character.valueOf('Z'), (IItemProvider)Items.field_222029_iU).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_222027_iT).func_200472_a("CZC").func_200472_a("MGM").func_200472_a("CXC").func_200473_b("bigreactors:reactor").func_200465_a("has_item", (ICriterionInstance)ReactorRecipeGenerator.func_200403_a((IItemProvider)((IItemProvider)casing.get()))));
    }

    private void reactorComputerPort(Consumer<IFinishedRecipe> c, ReactorVariant variant, Supplier<? extends IItemProvider> result, Supplier<? extends IItemProvider> casing, ITag.INamedTag<Item> metal, @Nullable ITag.INamedTag<Item> alternativeMetal) {
        ReactorRecipeGenerator.recipeWithAlternativeTag(c, (ResourceLocation)ReactorRecipeGenerator.reactorRecipeName(variant, "computerport"), (ResourceLocation)ReactorRecipeGenerator.reactorRecipeName(variant, "computerport_alt"), metal, alternativeMetal, metalTag -> ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)result.get())).func_200462_a(Character.valueOf('C'), (IItemProvider)casing.get()).func_200469_a(Character.valueOf('M'), (ITag)metalTag).func_200469_a(Character.valueOf('G'), (ITag)Tags.Items.STORAGE_BLOCKS_GOLD).func_200469_a(Character.valueOf('Z'), (ITag)Tags.Items.GEMS_LAPIS).func_200469_a(Character.valueOf('X'), (ITag)Tags.Items.DUSTS_GLOWSTONE).func_200472_a("CZC").func_200472_a("MGM").func_200472_a("CXC").func_200473_b("bigreactors:reactor").func_200465_a("has_item", (ICriterionInstance)ReactorRecipeGenerator.func_200403_a((IItemProvider)((IItemProvider)casing.get()))));
    }

    private static ResourceLocation reactorRecipeName(IMultiblockGeneratorVariant variant, String name) {
        return ExtremeReactors.newID("reactor/" + variant.getName() + "/" + name);
    }

    private static ResourceLocation reactorRecipeName(IMultiblockGeneratorVariant variant, String name, ITag.INamedTag<Item> tag) {
        return ExtremeReactors.newID("reactor/" + variant.getName() + "/" + name + "_" + tag.func_230234_a_().func_110623_a().replace('/', '_'));
    }

    private static /* synthetic */ ShapedRecipeBuilder lambda$null$11(Supplier result, ITag.INamedTag yellorium, ITag glass, ITag.INamedTag metalTag) {
        return ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)result.get())).func_200469_a(Character.valueOf('M'), (ITag)metalTag).func_200469_a(Character.valueOf('Y'), (ITag)yellorium).func_200469_a(Character.valueOf('G'), ContentTags.Items.INGOTS_GRAPHITE).func_200469_a(Character.valueOf('L'), glass).func_200472_a("MGM").func_200472_a("LYL").func_200472_a("MGM").func_200473_b("bigreactors:reactor").func_200465_a("has_item", (ICriterionInstance)ReactorRecipeGenerator.func_200409_a((ITag)yellorium));
    }
}

