/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.common.client.screen;

import com.google.common.collect.Lists;
import it.zerono.mods.extremereactors.gamecontent.CommonConstants;
import it.zerono.mods.extremereactors.gamecontent.multiblock.IMachineReader;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.client.screen.AbstractMultiblockScreen;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.client.screen.CommonIcons;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.client.screen.RedstonePortSettingControlsMap;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.part.AbstractMultiblockEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.sensor.AbstractSensorSetting;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.sensor.ISensorSettingFactory;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.sensor.ISensorType;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.sensor.SensorBehavior;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.client.gui.ButtonState;
import it.zerono.mods.zerocore.lib.client.gui.IControl;
import it.zerono.mods.zerocore.lib.client.gui.ModContainerScreen;
import it.zerono.mods.zerocore.lib.client.gui.control.AbstractButtonControl;
import it.zerono.mods.zerocore.lib.client.gui.control.Button;
import it.zerono.mods.zerocore.lib.client.gui.control.ChoiceText;
import it.zerono.mods.zerocore.lib.client.gui.control.Label;
import it.zerono.mods.zerocore.lib.client.gui.control.Panel;
import it.zerono.mods.zerocore.lib.client.gui.control.PanelGroup;
import it.zerono.mods.zerocore.lib.client.gui.control.Static;
import it.zerono.mods.zerocore.lib.client.gui.control.SwitchPictureButton;
import it.zerono.mods.zerocore.lib.client.gui.control.TextConstraints;
import it.zerono.mods.zerocore.lib.client.gui.control.TextInput;
import it.zerono.mods.zerocore.lib.client.gui.databind.BindingGroup;
import it.zerono.mods.zerocore.lib.client.gui.databind.IBinding;
import it.zerono.mods.zerocore.lib.client.gui.databind.MonoConsumerBinding;
import it.zerono.mods.zerocore.lib.client.gui.layout.FixedLayoutEngine;
import it.zerono.mods.zerocore.lib.client.gui.layout.HorizontalAlignment;
import it.zerono.mods.zerocore.lib.client.gui.layout.ILayoutEngine;
import it.zerono.mods.zerocore.lib.client.gui.layout.VerticalLayoutEngine;
import it.zerono.mods.zerocore.lib.client.gui.sprite.ISprite;
import it.zerono.mods.zerocore.lib.client.gui.sprite.SpriteTextureMap;
import it.zerono.mods.zerocore.lib.data.gfx.Colour;
import it.zerono.mods.zerocore.lib.item.inventory.PlayerInventoryUsage;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModTileContainer;
import it.zerono.mods.zerocore.lib.multiblock.cuboid.AbstractCuboidMultiblockController;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.util.NonNullSupplier;

public abstract class AbstractRedstonePortScreen<Controller extends AbstractCuboidMultiblockController<Controller>, T extends AbstractMultiblockEntity<Controller>, C extends ModTileContainer<T>, Reader extends IMachineReader, Writer, SensorType extends Enum<SensorType>, SensorSetting extends AbstractSensorSetting<Reader, Writer, SensorType>>
extends AbstractMultiblockScreen<Controller, T, C> {
    private static final ITextComponent TEXT_DIRECTION_INPUT = new TranslationTextComponent("gui.bigreactors.generator.redstoneport.sensortype.input").func_230530_a_(STYLE_TOOLTIP_INFO);
    private static final ITextComponent TEXT_DIRECTION_OUTPUT = new TranslationTextComponent("gui.bigreactors.generator.redstoneport.sensortype.output").func_230530_a_(STYLE_TOOLTIP_INFO);
    private final BindingGroup _bindings;
    private final RedstonePortSettingControlsMap<Reader, Writer, SensorType, SensorSetting> _guiMap;
    private final Panel _sensorButtonsPanel;
    private final PanelGroup<SensorType> _sensorsGroup;
    private final Label _activeSensorName;
    private final Button _disableButton;
    private final Button _saveButton;
    private final Button _resetButton;

    @SafeVarargs
    protected AbstractRedstonePortScreen(C container, PlayerInventory inventory, PlayerInventoryUsage inventoryUsage, ITextComponent title, NonNullSupplier<SpriteTextureMap> mainTextureSupplier, ISensorSettingFactory<Reader, Writer, SensorType, SensorSetting> sensorSettingFactory, SensorType ... validSensors) {
        super(container, inventory, inventoryUsage, title, mainTextureSupplier);
        this.ignoreCloseOnInventoryKey(true);
        this._bindings = new BindingGroup();
        this._sensorButtonsPanel = new Panel((ModContainerScreen)this, "sensorButtonsPanel");
        this._activeSensorName = new Label((ModContainerScreen)this, "activename", "");
        this._sensorsGroup = new PanelGroup((ModContainerScreen)this, "behaviors", validSensors);
        this._guiMap = new RedstonePortSettingControlsMap<Reader, Writer, SensorType, SensorSetting>(this._activeSensorName, this._sensorsGroup, sensorSettingFactory);
        this._disableButton = new Button((ModContainerScreen)this, "disable", (ITextComponent)new TranslationTextComponent("gui.bigreactors.generic.disable"));
        this._saveButton = new Button((ModContainerScreen)this, "save", (ITextComponent)new TranslationTextComponent("gui.bigreactors.generic.save"));
        this._resetButton = new Button((ModContainerScreen)this, "reset", (ITextComponent)new TranslationTextComponent("gui.bigreactors.generic.reset"));
    }

    protected abstract SensorSetting getDefaultSettings();

    protected abstract SensorSetting getDisabledSettings();

    @Override
    protected void onScreenCreate() {
        super.onScreenCreate();
        Label c = new Label((ModContainerScreen)this, "sensorlistlabel", (ITextComponent)new TranslationTextComponent("gui.bigreactors.generator.redstoneport.sensortype.sensorlistlabel"));
        c.setPadding(0);
        c.setLayoutEngineHint(FixedLayoutEngine.hint((int)13, (int)4, (int)(this.getGuiWidth() - 36), (int)10));
        this.addControl((IControl)c);
        this._sensorButtonsPanel.setPadding(0);
        this._sensorButtonsPanel.setLayoutEngineHint(FixedLayoutEngine.hint((int)13, (int)18, (int)62, (int)96));
        this.addControl((IControl)this._sensorButtonsPanel);
        int behaviorPanelWidth = this.getBehaviorPanelWidth();
        int behaviorPanelHeight = this.getBehaviorPanelHeight();
        this._activeSensorName.setLayoutEngineHint(FixedLayoutEngine.hint((int)80, (int)4, (int)behaviorPanelWidth, (int)10));
        this.addControl((IControl)this._activeSensorName);
        this._sensorsGroup.setLayoutEngineHint(FixedLayoutEngine.hint((int)78, (int)18, (int)behaviorPanelWidth, (int)behaviorPanelHeight));
        this.addControl((IControl)this._sensorsGroup);
        int sensorButtonRowY = this.getGuiHeight() - 46;
        this._disableButton.setLayoutEngineHint(FixedLayoutEngine.hint((int)13, (int)sensorButtonRowY, (int)62, (int)16));
        this._disableButton.Clicked.subscribe(this::onDisable);
        this.addControl((IControl)this._disableButton);
        this._saveButton.setLayoutEngineHint(FixedLayoutEngine.hint((int)109, (int)sensorButtonRowY, (int)50, (int)16));
        this._saveButton.Clicked.subscribe(this::onSave);
        this.addControl((IControl)this._saveButton);
        this._resetButton.setLayoutEngineHint(FixedLayoutEngine.hint((int)161, (int)sensorButtonRowY, (int)50, (int)16));
        this._resetButton.Clicked.subscribe(this::onReset);
        this.addControl((IControl)this._resetButton);
        this.setActionButtonsVisibility(false);
    }

    @Override
    protected void onDataUpdated() {
        super.onDataUpdated();
        this._bindings.update();
    }

    public boolean func_231178_ax__() {
        return true;
    }

    protected int getBehaviorPanelWidth() {
        return this.getGuiWidth() - 91;
    }

    protected int getBehaviorPanelHeight() {
        return 88;
    }

    protected TextInput inputText(String name, String suffix) {
        TextInput t = new TextInput((ModContainerScreen)this, name, "0");
        t.setDesiredDimension(70, 14);
        t.setFilter(TextConstraints.FILTER_NUMBERS);
        t.setDisplaySuffix(suffix);
        return t;
    }

    protected TextInput inputTextPercentage(String name) {
        TextInput t = this.inputText(name, "%");
        t.setMaxLength(3);
        t.setDesiredDimension(40, 14);
        t.addConstraint(TextConstraints.CONSTRAINT_PERCENTAGE);
        return t;
    }

    protected TextInput inputTextNumber(String name, String suffix) {
        TextInput t = this.inputText(name, suffix);
        t.setMaxLength(10);
        t.addConstraint(TextConstraints.CONSTRAINT_POSITIVE_INTEGER_NUMBER);
        return t;
    }

    protected TextInput inputTextNumber(String name, String suffix, Function<String, Optional<String>> constraint) {
        TextInput t = this.inputTextNumber(name, suffix);
        t.addConstraint(constraint);
        return t;
    }

    protected void addSensorButtonsSeparator(int sensorButtonRowY) {
        Static s = new Static((ModContainerScreen)this, 62, 1);
        s.setColor(Colour.BLACK);
        s.setLayoutEngineHint(FixedLayoutEngine.hint((int)0, (int)(sensorButtonRowY - 8), (int)62, (int)1));
        this._sensorButtonsPanel.addControl((IControl)s);
    }

    protected void applySettings(SensorSetting setting) {
        this._guiMap.setSettings(setting);
    }

    private void onDisable(Button btn, int mouseButton) {
        this.sendCommandToServer(CommonConstants.COMMAND_DISABLE_REDSTONE_SENSOR);
    }

    private void onSave(Button btn, int mouseButton) {
        if (this.isValid()) {
            this.sendCommandToServer(CommonConstants.COMMAND_SET_REDSTONE_SENSOR, ((AbstractSensorSetting)this._guiMap.getSettings(this.getDisabledSettings())).syncDataTo(new CompoundNBT()));
        }
    }

    private void onReset(Button btn, int mouseButton) {
        this._guiMap.setSettings(this.getDefaultSettings());
    }

    private static void onBehaviorChanged(ChoiceText<SensorBehavior> choice, SensorBehavior behavior) {
        choice.getTag().ifPresent(group -> group.setActivePanel((Enum)behavior));
    }

    protected void addBinding(Function<T, SensorSetting> supplier, Consumer<SensorSetting> consumer) {
        this._bindings.addBinding((IBinding)new MonoConsumerBinding((Object)this.getTileEntity(), supplier, consumer));
    }

    private void setActionButtonsVisibility(boolean visible) {
        this._saveButton.setVisible(visible);
        this._resetButton.setVisible(visible);
    }

    private SwitchPictureButton createSensorButton(int x, int y, SensorType sensor, NonNullSupplier<ISprite> defaultSprite, NonNullSupplier<ISprite> activeSprite) {
        SwitchPictureButton button = new SwitchPictureButton((ModContainerScreen)this, ((Enum)sensor).name(), false, "sensortype");
        String tooltipBaseName = ((ISensorType)sensor).getTranslationBaseName();
        button.setTag(sensor);
        button.setTooltips(new ITextComponent[]{new TranslationTextComponent(tooltipBaseName + "1").func_230530_a_(STYLE_TOOLTIP_TITLE), ((ISensorType)sensor).isInput() ? TEXT_DIRECTION_INPUT : TEXT_DIRECTION_OUTPUT, CodeHelper.TEXT_EMPTY_LINE, new TranslationTextComponent(tooltipBaseName + "2"), new TranslationTextComponent(tooltipBaseName + "3")});
        this.setButtonSpritesAndOverlayForState((AbstractButtonControl)button, ButtonState.Default, (ISprite)defaultSprite.get());
        this.setButtonSpritesAndOverlayForState((AbstractButtonControl)button, ButtonState.Active, (ISprite)activeSprite.get());
        button.setLayoutEngineHint(FixedLayoutEngine.hint((int)x, (int)y, (int)18, (int)18));
        button.setBackground(CommonIcons.ImageButtonBackground.get());
        button.enablePaintBlending(true);
        button.setPadding(1);
        button.Activated.subscribe(spb -> spb.getTag().ifPresent(st -> {
            this._sensorsGroup.setActivePanel(st);
            this._activeSensorName.setText((ITextComponent)new TranslationTextComponent(((ISensorType)((Object)st)).getTranslationBaseName() + "1"));
            this.setActionButtonsVisibility(true);
        }));
        button.Deactivated.subscribe(spb -> {
            this._sensorsGroup.clearActivePanel();
            this.setActionButtonsVisibility(false);
        });
        return button;
    }

    protected SensorPanelBuilder<Controller, T, C, Reader, Writer, SensorType, SensorSetting> sensorPanelBuilder(SensorType sensorType, int buttonX, int buttonY, NonNullSupplier<ISprite> buttonDefaultIcon, NonNullSupplier<ISprite> buttonActiveIcon) {
        return new SensorPanelBuilder(this, sensorType, buttonX, buttonY, buttonDefaultIcon, buttonActiveIcon);
    }

    private void addBuiltSensorPanel(SensorType sensor, Panel panel, SwitchPictureButton button, ChoiceText<SensorBehavior> behaviorChoice, List<RedstonePortSettingControlsMap.BehaviorEntry> behaviorEntries) {
        this._sensorsGroup.setPanel(sensor, panel);
        this._sensorButtonsPanel.addControl((IControl)button);
        this._guiMap.add(sensor, new RedstonePortSettingControlsMap.SensorEntry(button, behaviorChoice, behaviorEntries));
    }

    protected static class SensorPanelBuilder<Controller extends AbstractCuboidMultiblockController<Controller>, T extends AbstractMultiblockEntity<Controller>, C extends ModTileContainer<T>, Reader extends IMachineReader, Writer, SensorType extends Enum<SensorType>, SensorSetting extends AbstractSensorSetting<Reader, Writer, SensorType>> {
        private final AbstractRedstonePortScreen<Controller, T, C, Reader, Writer, SensorType, SensorSetting> _gui;
        private final SensorType _sensor;
        private final SwitchPictureButton _sensorButton;
        private final Panel _sensorPanel;
        private final ChoiceText<SensorBehavior> _behaviorChoice;
        private final int _behaviorPanelWidth;
        private PanelGroup<SensorBehavior> _behaviorDataGroup;
        private List<RedstonePortSettingControlsMap.BehaviorEntry> _mapBehaviorDataEntries;

        public void build() {
            this.setupBehaviorChoiceControl(this._sensor, this._behaviorChoice, this._behaviorDataGroup, this._behaviorPanelWidth);
            if (null != this._behaviorDataGroup) {
                this._behaviorDataGroup.setActivePanel((Enum)this._behaviorChoice.getValidIndices().get(0));
            }
            ((AbstractRedstonePortScreen)this._gui).addBuiltSensorPanel(this._sensor, this._sensorPanel, this._sensorButton, (ChoiceText<SensorBehavior>)this._behaviorChoice, null != this._mapBehaviorDataEntries ? this._mapBehaviorDataEntries : Collections.emptyList());
        }

        public SensorPanelBuilder<Controller, T, C, Reader, Writer, SensorType, SensorSetting> addBehaviorDataInput(SensorBehavior behavior) {
            this.createBehaviorDataGroup();
            this.createBehaviorDataPanel(behavior);
            return this;
        }

        public SensorPanelBuilder<Controller, T, C, Reader, Writer, SensorType, SensorSetting> addBehaviorDataInput(SensorBehavior behavior, TextInput inputA, String inputALabelKey) {
            return this.addBehaviorSingleDataInput(behavior, inputA, inputALabelKey, null);
        }

        public SensorPanelBuilder<Controller, T, C, Reader, Writer, SensorType, SensorSetting> addBehaviorDataInput(SensorBehavior behavior, TextInput inputA, String inputALabelKey, BehaviorSingleDataValidator validator) {
            return this.addBehaviorSingleDataInput(behavior, inputA, inputALabelKey, validator);
        }

        public SensorPanelBuilder<Controller, T, C, Reader, Writer, SensorType, SensorSetting> addBehaviorDataInput(SensorBehavior behavior, TextInput inputA, String inputALabelKey, TextInput inputB, String inputBLabelKey) {
            return this.addBehaviorDoubleDataInput(behavior, inputA, inputALabelKey, inputB, inputBLabelKey, null);
        }

        public SensorPanelBuilder<Controller, T, C, Reader, Writer, SensorType, SensorSetting> addBehaviorDataInput(SensorBehavior behavior, TextInput inputA, String inputALabelKey, TextInput inputB, String inputBLabelKey, BehaviorDoubleDataValidator validator) {
            return this.addBehaviorDoubleDataInput(behavior, inputA, inputALabelKey, inputB, inputBLabelKey, validator);
        }

        public SensorPanelBuilder<Controller, T, C, Reader, Writer, SensorType, SensorSetting> addStandardOutputBehaviorPanel(TextInput inputAbove, String inputAboveLabelKey, TextInput inputBelow, String inputBelowLabelKey, TextInput inputBetweenMin, String inputBetweenMinLabelKey, TextInput inputBetweenMax, String inputBetweenMaxLabelKey) {
            this.addBehaviorDataInput(SensorBehavior.ActiveWhileAbove, inputAbove, inputAboveLabelKey);
            this.addBehaviorDataInput(SensorBehavior.ActiveWhileBelow, inputBelow, inputBelowLabelKey);
            this.addBehaviorDataInput(SensorBehavior.ActiveWhileBetween, inputBetweenMin, inputBetweenMinLabelKey, inputBetweenMax, inputBetweenMaxLabelKey, (min, max, errorReport) -> {
                if (min.intValue() >= max.intValue()) {
                    errorReport.accept(new TranslationTextComponent("gui.bigreactors.generator.validation.redstoneport.invalidminmax.line1"));
                }
            });
            return this;
        }

        protected SensorPanelBuilder(AbstractRedstonePortScreen<Controller, T, C, Reader, Writer, SensorType, SensorSetting> gui, SensorType sensorType, int buttonX, int buttonY, NonNullSupplier<ISprite> buttonDefaultIcon, NonNullSupplier<ISprite> buttonActiveIcon) {
            this._gui = gui;
            this._behaviorPanelWidth = gui.getBehaviorPanelWidth();
            this._sensor = sensorType;
            this._sensorButton = ((AbstractRedstonePortScreen)this._gui).createSensorButton(buttonX, buttonY, sensorType, (NonNullSupplier<ISprite>)buttonDefaultIcon, (NonNullSupplier<ISprite>)buttonActiveIcon);
            this._sensorPanel = this.createSensorPanel(sensorType, this._behaviorPanelWidth);
            this._behaviorChoice = new ChoiceText(this._gui, ((Enum)sensorType).name() + "Behavior", ((ISensorType)sensorType).getBehaviors());
            this._sensorPanel.addControl(this._behaviorChoice);
        }

        private void createBehaviorDataGroup() {
            if (null == this._behaviorDataGroup) {
                this._behaviorDataGroup = new PanelGroup(this._gui, "dg", (Iterable)this._behaviorChoice.getValidIndices());
                this._sensorPanel.addControl(this._behaviorDataGroup);
            }
            if (null == this._mapBehaviorDataEntries) {
                this._mapBehaviorDataEntries = Lists.newLinkedList();
            }
        }

        private SensorPanelBuilder<Controller, T, C, Reader, Writer, SensorType, SensorSetting> addBehaviorSingleDataInput(SensorBehavior behavior, TextInput inputA, String inputALabelKey, @Nullable BehaviorSingleDataValidator validator) {
            this.createBehaviorDataGroup();
            Panel p = this.createBehaviorDataPanel(behavior);
            p.addControl((IControl)this.behaviorLabel(behavior.name() + "Label", inputALabelKey, this._behaviorPanelWidth));
            p.addControl((IControl)inputA);
            if (null != validator) {
                p.setValidator((cnt, report) -> validator.validate(inputA, report));
            }
            this._mapBehaviorDataEntries.add(new RedstonePortSettingControlsMap.BehaviorEntry(behavior, inputA));
            return this;
        }

        private SensorPanelBuilder<Controller, T, C, Reader, Writer, SensorType, SensorSetting> addBehaviorDoubleDataInput(SensorBehavior behavior, TextInput inputA, String inputALabelKey, TextInput inputB, String inputBLabelKey, @Nullable BehaviorDoubleDataValidator validator) {
            this.createBehaviorDataGroup();
            Panel p = this.createBehaviorDataPanel(behavior);
            p.addControl((IControl)this.behaviorLabel(behavior.name() + "LabelA", inputALabelKey, this._behaviorPanelWidth));
            p.addControl((IControl)inputA);
            p.addControl((IControl)this.behaviorLabel(behavior.name() + "LabelB", inputBLabelKey, this._behaviorPanelWidth));
            p.addControl((IControl)inputB);
            if (null != validator) {
                p.setValidator((cnt, report) -> validator.validate(inputA, inputB, report));
            }
            this._mapBehaviorDataEntries.add(new RedstonePortSettingControlsMap.BehaviorEntry(behavior, inputA, inputB));
            return this;
        }

        private Panel createSensorPanel(SensorType sensor, int width) {
            Panel p = new Panel(this._gui, ((Enum)sensor).name());
            p.setLayoutEngineHint(FixedLayoutEngine.hint((int)0, (int)0, (int)width, (int)88));
            p.setLayoutEngine((ILayoutEngine)((VerticalLayoutEngine)((VerticalLayoutEngine)new VerticalLayoutEngine().setVerticalMargin(0)).setHorizontalMargin(2)).setHorizontalAlignment(HorizontalAlignment.Left));
            return p;
        }

        private Panel createBehaviorDataPanel(SensorBehavior behavior) {
            Panel p = new Panel(this._gui, behavior.name());
            p.setLayoutEngineHint(FixedLayoutEngine.hint((int)0, (int)0, (int)this._behaviorPanelWidth, (int)200));
            p.setLayoutEngine((ILayoutEngine)((VerticalLayoutEngine)((VerticalLayoutEngine)((VerticalLayoutEngine)new VerticalLayoutEngine().setVerticalMargin(0)).setHorizontalMargin(4)).setControlsSpacing(4)).setHorizontalAlignment(HorizontalAlignment.Left));
            this._behaviorDataGroup.setPanel((Enum)behavior, p);
            return p;
        }

        private Label behaviorLabel(String name, String translationKey, int width) {
            Label l = new Label(this._gui, name, (ITextComponent)new TranslationTextComponent(translationKey));
            l.setPadding(0);
            l.setDesiredDimension(width, 10);
            return l;
        }

        private void setupBehaviorChoiceControl(SensorType sensor, ChoiceText<SensorBehavior> choice, @Nullable PanelGroup<SensorBehavior> behaviorGroup, int width) {
            List<SensorBehavior> behaviors = ((ISensorType)sensor).getBehaviors();
            behaviors.forEach(b -> choice.addText((Enum)b, (ITextComponent)new TranslationTextComponent("gui.bigreactors.generator.redstoneport.sensorbehavior." + CodeHelper.neutralLowercase((String)b.name()) + ".line1")));
            choice.setSelectedIndex((Enum)behaviors.get(0));
            choice.setDesiredDimension(width, 16);
            if (behaviors.size() == 1) {
                choice.setEnabled(false);
            }
            if (null != behaviorGroup) {
                choice.setTag(behaviorGroup);
                choice.Changed.subscribe((x$0, x$1) -> AbstractRedstonePortScreen.onBehaviorChanged((ChoiceText<SensorBehavior>)x$0, x$1));
            }
        }
    }

    @FunctionalInterface
    public static interface BehaviorDoubleDataValidator {
        public void validate(TextInput var1, TextInput var2, Consumer<ITextComponent> var3);
    }

    @FunctionalInterface
    public static interface BehaviorSingleDataValidator {
        public void validate(TextInput var1, Consumer<ITextComponent> var2);
    }
}

