/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.reactor;

import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.IHeat;
import it.zerono.mods.zerocore.lib.data.nbt.IMergeableEntity;
import it.zerono.mods.zerocore.lib.data.nbt.ISyncableEntity;
import net.minecraft.nbt.CompoundNBT;

class Heat
implements IHeat,
ISyncableEntity,
IMergeableEntity {
    private double _heat = 0.0;

    @Override
    public void set(double value) {
        this._heat = Double.isNaN(value) ? 0.0 : value;
    }

    @Override
    public void add(double amount) {
        if (!Double.isNaN(amount)) {
            this._heat += amount;
            if (-1.0E-5 < this._heat && this._heat < 1.0E-5) {
                this._heat = 0.0;
            }
        }
    }

    @Override
    public void resetIfNegative() {
        if (this.getAsDouble() < 0.0) {
            this.set(0.0);
        }
    }

    @Override
    public double getAsDouble() {
        return this._heat;
    }

    public void syncDataFrom(CompoundNBT data, ISyncableEntity.SyncReason syncReason) {
        if (data.func_74764_b("heat")) {
            this.set(data.func_74769_h("heat"));
        }
    }

    public CompoundNBT syncDataTo(CompoundNBT data, ISyncableEntity.SyncReason syncReason) {
        data.func_74780_a("heat", this.getAsDouble());
        return data;
    }

    public void syncDataFrom(IMergeableEntity other) {
        Heat heat;
        if (other instanceof Heat && (heat = (Heat)other).getAsDouble() > this.getAsDouble()) {
            this.set(heat.getAsDouble());
        }
    }

    public String toString() {
        return Double.toString(this._heat);
    }
}

