/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.reactor;

import it.zerono.mods.extremereactors.config.Config;
import it.zerono.mods.extremereactors.gamecontent.Content;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.part.ComputerPortBlock;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.part.GenericDeviceBlock;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.part.GlassBlock;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.part.IOPortBlock;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.part.PassiveFluidPortBlock;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.part.PowerTapBlock;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.MultiblockReactor;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.part.ReactorFuelRodBlock;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.part.ReactorRedstonePortBlock;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.variant.ReactorVariant;
import it.zerono.mods.zerocore.lib.block.multiblock.IMultiblockPartType;
import it.zerono.mods.zerocore.lib.block.multiblock.MultiblockPartBlock;
import it.zerono.mods.zerocore.lib.multiblock.variant.IMultiblockVariant;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.world.IBlockReader;

public enum ReactorPartType implements IMultiblockPartType
{
    Casing(() -> () -> Content.TileEntityTypes.REACTOR_CASING.get(), MultiblockPartBlock::new, "part.bigreactors.reactor.casing"),
    Glass(() -> () -> Content.TileEntityTypes.REACTOR_GLASS.get(), GlassBlock::new, "part.bigreactors.reactor.glass", ReactorPartType::notOpaqueBlock),
    Controller(() -> () -> Content.TileEntityTypes.REACTOR_CONTROLLER.get(), GenericDeviceBlock::new, "part.bigreactors.reactor.controller"),
    FuelRod(() -> () -> Content.TileEntityTypes.REACTOR_FUELROD.get(), ReactorFuelRodBlock::new, "part.bigreactors.reactor.fuelrod", bp -> ReactorPartType.notOpaqueBlock(bp).func_235838_a_(state -> (Integer)Config.COMMON.reactor.fuelRodLightValue.get())),
    ControlRod(() -> () -> Content.TileEntityTypes.REACTOR_CONTROLROD.get(), GenericDeviceBlock::new, "part.bigreactors.reactor.controlrod"),
    SolidAccessPort(() -> () -> Content.TileEntityTypes.REACTOR_SOLID_ACCESSPORT.get(), IOPortBlock::new, "part.bigreactors.reactor.solidaccessport"),
    ActiveFluidPortForge(() -> () -> Content.TileEntityTypes.REACTOR_FLUIDPORT_FORGE_ACTIVE.get(), IOPortBlock::new, "part.bigreactors.reactor.fluidport_forge_active"),
    PassiveFluidPortForge(() -> () -> Content.TileEntityTypes.REACTOR_FLUIDPORT_FORGE_PASSIVE.get(), PassiveFluidPortBlock::new, "part.bigreactors.reactor.fluidport_forge_passive"),
    PassiveFluidPortMekanism(() -> () -> Content.TileEntityTypes.REACTOR_FLUIDPORT_MEKANISM_PASSIVE.get(), PassiveFluidPortBlock::new, "part.bigreactors.reactor.fluidport_mekanism_passive"),
    CreativeWaterGenerator(() -> () -> Content.TileEntityTypes.REACTOR_CREATIVE_WATER_GENERATOR.get(), GenericDeviceBlock::new, "part.bigreactors.reactor.creativewatergenerator"),
    ActivePowerTapFE(() -> () -> Content.TileEntityTypes.REACTOR_POWERTAP_FE_ACTIVE.get(), PowerTapBlock::new, "part.bigreactors.reactor.powertap_fe_active"),
    PassivePowerTapFE(() -> () -> Content.TileEntityTypes.REACTOR_POWERTAP_FE_PASSIVE.get(), PowerTapBlock::new, "part.bigreactors.reactor.powertap_fe_passive"),
    ComputerPort(() -> () -> Content.TileEntityTypes.REACTOR_COMPUTERPORT.get(), ComputerPortBlock::new, "part.bigreactors.reactor.computerport"),
    RedstonePort(() -> () -> Content.TileEntityTypes.REACTOR_REDSTONEPORT.get(), ReactorRedstonePortBlock::new, "part.bigreactors.reactor.redstoneport"),
    ChargingPortFE(() -> () -> Content.TileEntityTypes.REACTOR_CHARGINGPORT_FE.get(), GenericDeviceBlock::new, "part.bigreactors.reactor.chargingport_fe");

    private final Supplier<Supplier<TileEntityType<?>>> _tileTypeSupplier;
    private final Function<MultiblockPartBlock.MultiblockPartProperties<ReactorPartType>, MultiblockPartBlock<MultiblockReactor, ReactorPartType>> _blockFactory;
    private final String _translationKey;
    private final Function<AbstractBlock.Properties, AbstractBlock.Properties> _blockPropertiesFixer;

    private ReactorPartType(Supplier<Supplier<TileEntityType<?>>> tileTypeSupplier, Function<MultiblockPartBlock.MultiblockPartProperties<ReactorPartType>, MultiblockPartBlock<MultiblockReactor, ReactorPartType>> blockFactory, String translationKey) {
        this(tileTypeSupplier, blockFactory, translationKey, bp -> bp);
    }

    private ReactorPartType(Supplier<Supplier<TileEntityType<?>>> tileTypeSupplier, Function<MultiblockPartBlock.MultiblockPartProperties<ReactorPartType>, MultiblockPartBlock<MultiblockReactor, ReactorPartType>> blockFactory, String translationKey, Function<AbstractBlock.Properties, AbstractBlock.Properties> blockPropertiesFixer) {
        this._tileTypeSupplier = tileTypeSupplier;
        this._blockFactory = blockFactory;
        this._translationKey = translationKey;
        this._blockPropertiesFixer = blockPropertiesFixer;
    }

    public MultiblockPartBlock<MultiblockReactor, ReactorPartType> createBlock(ReactorVariant variant) {
        return this._blockFactory.apply((MultiblockPartBlock.MultiblockPartProperties<ReactorPartType>)MultiblockPartBlock.MultiblockPartProperties.create((Enum)this, (AbstractBlock.Properties)this._blockPropertiesFixer.apply(variant.getDefaultBlockProperties())).variant((IMultiblockVariant)variant));
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return this._tileTypeSupplier.get().get().func_200968_a();
    }

    public String getTranslationKey() {
        return this._translationKey;
    }

    public String func_176610_l() {
        return this.name();
    }

    private static AbstractBlock.Properties notOpaqueBlock(AbstractBlock.Properties originals) {
        return originals.func_200947_a(SoundType.field_185853_f).func_226896_b_().func_235828_a_((blockState, blockReader, pos) -> false).func_235847_c_((blockState, blockReader, pos) -> false);
    }
}

