/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.client.screen;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import it.zerono.mods.extremereactors.api.reactor.ReactantType;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.client.screen.AbstractMultiblockScreen;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.client.screen.CachedSprites;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.MultiblockReactor;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.client.gui.ModContainerScreen;
import it.zerono.mods.zerocore.lib.client.gui.control.MultiValueGaugeBar;
import it.zerono.mods.zerocore.lib.data.geometry.Rectangle;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import java.util.List;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class FuelGaugeBar
extends MultiValueGaugeBar<ReactantType> {
    private static final IFormattableTextComponent EMPTY = new TranslationTextComponent("gui.bigreactors.generic.empty");
    private final MultiblockReactor _reactor;
    private final List<ITextComponent> _tooltipsLines;
    private final List<Object> _tooltipsObjects;

    public FuelGaugeBar(ModContainerScreen<? extends ModContainer> gui, String name, MultiblockReactor reactor) {
        super(gui, name, (double)reactor.getCapacity(), (Enum)ReactantType.Waste, (Enum)ReactantType.Fuel, (Enum[])new ReactantType[0]);
        this.setBarSprite(ReactantType.Fuel, CachedSprites.REACTOR_FUEL_COLUMN_FLOWING);
        this.setBarSprite(ReactantType.Waste, CachedSprites.REACTOR_FUEL_COLUMN_FLOWING);
        this._reactor = reactor;
        this._tooltipsLines = ImmutableList.of((Object)new TranslationTextComponent("gui.bigreactors.reactor.controller.fuelbar.line1").func_230530_a_(AbstractMultiblockScreen.STYLE_TOOLTIP_TITLE), (Object)new TranslationTextComponent("gui.bigreactors.reactor.controller.fuelbar.line2"), (Object)new TranslationTextComponent("gui.bigreactors.reactor.controller.fuelbar.line3"), (Object)CodeHelper.TEXT_EMPTY_LINE, (Object)new TranslationTextComponent("gui.bigreactors.reactor.controller.fuelbar.line4", new Object[]{String.format(TextFormatting.DARK_AQUA + "" + TextFormatting.BOLD + "%d", this._reactor.getFuelRodsCount())}), (Object)new TranslationTextComponent("gui.bigreactors.reactor.controller.fuelbar.line5", new Object[]{TextFormatting.DARK_AQUA + "" + TextFormatting.BOLD + CodeHelper.formatAsMillibuckets((float)this._reactor.getCapacity())}), (Object)new TranslationTextComponent("gui.bigreactors.reactor.controller.fuelbar.line6"), (Object)new TranslationTextComponent("gui.bigreactors.reactor.controller.fuelbar.line7"), (Object)new TranslationTextComponent("gui.bigreactors.reactor.controller.fuelbar.line8"));
        this._tooltipsObjects = ImmutableList.of(() -> new StringTextComponent(String.format("%.2f%%", this.getFillRatio() * 100.0)).func_230530_a_(AbstractMultiblockScreen.STYLE_TOOLTIP_VALUE), () -> new StringTextComponent(String.format("%.2f%%", Float.valueOf(this._reactor.getFuelContainer().isEmpty() ? 0.0f : (float)this._reactor.getFuelContainer().getWasteAmount() / (float)(this.getFuelAmount() + this.getWasteAmount()) * 100.0f))).func_230530_a_(AbstractMultiblockScreen.STYLE_TOOLTIP_VALUE), () -> (this.getFuelAmount() > 0 ? new StringTextComponent(CodeHelper.formatAsMillibuckets((float)this.getFuelAmount())) : EMPTY).func_230530_a_(AbstractMultiblockScreen.STYLE_TOOLTIP_VALUE), () -> (this.getWasteAmount() > 0 ? new StringTextComponent(CodeHelper.formatAsMillibuckets((float)this.getWasteAmount())) : EMPTY).func_230530_a_(AbstractMultiblockScreen.STYLE_TOOLTIP_VALUE), () -> new StringTextComponent(CodeHelper.formatAsMillibuckets((float)(this.getFuelAmount() + this.getWasteAmount()))).func_230530_a_(AbstractMultiblockScreen.STYLE_TOOLTIP_VALUE));
    }

    public List<ITextComponent> getTooltips() {
        return this._tooltipsLines;
    }

    public List<Object> getTooltipsObjects() {
        return this._tooltipsObjects;
    }

    protected int paintValueRect(MatrixStack matrix, ReactantType reactantType, Rectangle rect, int skip) {
        RenderSystem.enableBlend();
        int r = super.paintValueRect(matrix, (Enum)reactantType, rect, skip);
        RenderSystem.disableBlend();
        return r;
    }

    private int getFuelAmount() {
        return this._reactor.getFuelContainer().getFuelAmount();
    }

    private int getWasteAmount() {
        return this._reactor.getFuelContainer().getWasteAmount();
    }
}

