/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.client.render.rotor;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.client.render.rotor.BladeSpan;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.client.render.rotor.RotorDescriptor;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.client.render.rotor.ShaftSection;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.part.TurbineRotorBearingEntity;
import it.zerono.mods.zerocore.lib.client.render.ModRenderHelper;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraftforge.client.model.data.IModelData;

public class RotorBearingEntityRenderer
extends TileEntityRenderer<TurbineRotorBearingEntity> {
    public RotorBearingEntityRenderer(TileEntityRendererDispatcher rendererDispatcher) {
        super(rendererDispatcher);
    }

    public boolean shouldRenderOffScreen(TurbineRotorBearingEntity te) {
        return true;
    }

    public void render(TurbineRotorBearingEntity bearing, float partialTicks, MatrixStack stack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        if (!bearing.isMachineAssembled() || bearing.isTurbineInteriorInvisible()) {
            return;
        }
        RotorDescriptor descriptor = bearing.getRotorDescriptor();
        if (null == descriptor) {
            return;
        }
        IBakedModel shaft = descriptor.ShaftModel.get();
        IBakedModel blade = descriptor.BladeModel.get();
        IVertexBuilder builder = buffer.getBuffer(Atlases.func_228782_g_());
        stack.func_227860_a_();
        descriptor.InitMatrix.accept(stack, Float.valueOf(RotorBearingEntityRenderer.getRotorAngle(bearing)));
        for (ShaftSection section : descriptor.Sections) {
            descriptor.accept(stack);
            ModRenderHelper.renderModel((IBakedModel)shaft, (IModelData)section.ShaftModelData, (MatrixStack)stack, (IVertexBuilder)builder, (int)combinedLight, (int)combinedOverlay);
            for (BladeSpan bladeSpan : section.Blades) {
                stack.func_227860_a_();
                for (int i = 0; i < bladeSpan.Length; ++i) {
                    bladeSpan.accept(stack);
                    ModRenderHelper.renderModel((IBakedModel)blade, (IModelData)bladeSpan.BladeModelData, (MatrixStack)stack, (IVertexBuilder)builder, (int)combinedLight, (int)combinedOverlay);
                }
                stack.func_227865_b_();
            }
        }
        stack.func_227865_b_();
    }

    private static float getRotorAngle(TurbineRotorBearingEntity bearing) {
        long elapsedTime = System.currentTimeMillis() - ModRenderHelper.getLastRenderTime();
        float speed = ((Float)bearing.evalOnController(turbine -> Float.valueOf(turbine.getRotorSpeed() / 10.0f), Float.valueOf(0.0f))).floatValue();
        float angle = bearing.getRotorAngle();
        if (speed > 0.001f) {
            angle += speed * ((float)elapsedTime / 60000.0f) * 360.0f;
            bearing.setRotorAngle(angle %= 360.0f);
        }
        return angle;
    }
}

