/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.part;

import it.zerono.mods.extremereactors.gamecontent.CommonConstants;
import it.zerono.mods.extremereactors.gamecontent.Content;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.part.fluidport.FluidPortType;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.part.fluidport.IFluidPort;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.part.fluidport.IFluidPortHandler;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.MultiblockTurbine;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.part.AbstractTurbineEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.variant.IMultiblockTurbineVariant;
import it.zerono.mods.zerocore.lib.block.AbstractModBlockEntity;
import it.zerono.mods.zerocore.lib.block.INeighborChangeListener;
import it.zerono.mods.zerocore.lib.block.TileCommandDispatcher;
import it.zerono.mods.zerocore.lib.data.IoDirection;
import it.zerono.mods.zerocore.lib.data.IoMode;
import it.zerono.mods.zerocore.lib.data.nbt.ISyncableEntity;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModTileContainer;
import it.zerono.mods.zerocore.lib.multiblock.IMultiblockController;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class TurbineFluidPortEntity
extends AbstractTurbineEntity
implements IFluidPort<MultiblockTurbine, IMultiblockTurbineVariant>,
INeighborChangeListener,
INamedContainerProvider {
    private final IFluidPortHandler<MultiblockTurbine, IMultiblockTurbineVariant> _handler;
    private IoDirection _direction;

    public TurbineFluidPortEntity(FluidPortType type, IoMode mode, TileEntityType<?> entityType) {
        super(entityType);
        this._handler = IFluidPortHandler.create(type, mode, this);
        this.setIoDirection(IoDirection.Input);
        this.setCommandDispatcher(TileCommandDispatcher.builder().addServerHandler(CommonConstants.COMMAND_SET_INPUT, tile -> tile.setIoDirection(IoDirection.Input)).addServerHandler(CommonConstants.COMMAND_SET_OUTPUT, tile -> tile.setIoDirection(IoDirection.Output)).build((AbstractModBlockEntity)this));
    }

    @Override
    public IFluidPortHandler<MultiblockTurbine, IMultiblockTurbineVariant> getFluidPortHandler() {
        return this._handler;
    }

    public void onNeighborBlockChanged(BlockState state, BlockPos neighborPosition, boolean isMoving) {
        if (this.isConnected()) {
            this.getFluidPortHandler().checkConnections((IWorldReader)this.func_145831_w(), this.getWorldPosition());
        }
        this.requestClientRenderUpdate();
    }

    public void onNeighborTileChanged(BlockState state, BlockPos neighborPosition) {
        if (this.isConnected()) {
            this.getFluidPortHandler().checkConnections((IWorldReader)this.func_145831_w(), this.getWorldPosition());
        }
        this.requestClientRenderUpdate();
    }

    public IoDirection getIoDirection() {
        return this._direction;
    }

    public void setIoDirection(IoDirection direction) {
        if (this.getIoDirection() == direction) {
            return;
        }
        this._direction = direction;
        this.getFluidPortHandler().update();
        this.executeOnController(MultiblockTurbine::onFluidPortChanged);
        this.notifyBlockUpdate();
        this.callOnLogicalSide(() -> {
            this.notifyOutwardNeighborsOfStateChange();
            this.func_70296_d();
        }, this::markForRenderUpdate);
    }

    public void syncDataFrom(CompoundNBT data, ISyncableEntity.SyncReason syncReason) {
        super.syncDataFrom(data, syncReason);
        this.setIoDirection(IoDirection.read((CompoundNBT)data, (String)"iodir", (IoDirection)IoDirection.Input));
    }

    public CompoundNBT syncDataTo(CompoundNBT data, ISyncableEntity.SyncReason syncReason) {
        super.syncDataTo(data, syncReason);
        IoDirection.write((CompoundNBT)data, (String)"iodir", (IoDirection)this.getIoDirection());
        return data;
    }

    @Nullable
    public Container createMenu(int windowId, PlayerInventory inventory, PlayerEntity player) {
        return ModTileContainer.empty((ContainerType)((ContainerType)Content.ContainerTypes.TURBINE_FLUIDPORT.get()), (int)windowId, (AbstractModBlockEntity)this);
    }

    public ITextComponent func_145748_c_() {
        return super.getPartDisplayName();
    }

    @Override
    protected int getUpdatedModelVariantIndex() {
        int connectedOffset = this.isMachineAssembled() && this.getFluidPortHandler().isConnected() ? 1 : 0;
        return this.getIoDirection().isInput() ? 2 + connectedOffset : 0 + connectedOffset;
    }

    public boolean canOpenGui(World world, BlockPos position, BlockState state) {
        return this.isMachineAssembled();
    }

    @Override
    public void onPostMachineAssembled(MultiblockTurbine controller) {
        super.onPostMachineAssembled(controller);
        this.getFluidPortHandler().update();
        this.notifyOutwardNeighborsOfStateChange();
    }

    @Override
    public void onPostMachineBroken() {
        super.onPostMachineBroken();
        this.getFluidPortHandler().update();
        this.notifyOutwardNeighborsOfStateChange();
    }

    public void onAttached(MultiblockTurbine newController) {
        super.onAttached((IMultiblockController)newController);
        this.getFluidPortHandler().update();
    }

    public void onAssimilated(MultiblockTurbine newController) {
        super.onAssimilated((IMultiblockController)newController);
        this.getFluidPortHandler().update();
    }

    public void onDetached(MultiblockTurbine oldController) {
        super.onDetached((IMultiblockController)oldController);
        this.getFluidPortHandler().update();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
        LazyOptional cap = this.getFluidPortHandler().getCapability(capability, side);
        return null != cap ? cap : super.getCapability(capability, side);
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.getFluidPortHandler().invalidate();
    }
}

