/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.debug;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IJeiRuntime;
import mezz.jei.config.ClientConfig;
import mezz.jei.plugins.debug.DebugGhostIngredientHandler;
import mezz.jei.plugins.debug.DebugRecipe;
import mezz.jei.plugins.debug.DebugRecipeCategory;
import mezz.jei.plugins.debug.FluidSubtypeHandlerTest;
import mezz.jei.plugins.jei.ingredients.DebugIngredient;
import mezz.jei.plugins.jei.ingredients.DebugIngredientHelper;
import mezz.jei.plugins.jei.ingredients.DebugIngredientListFactory;
import mezz.jei.plugins.jei.ingredients.DebugIngredientRenderer;
import net.minecraft.block.Blocks;
import net.minecraft.client.gui.screen.inventory.BrewingStandScreen;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

@JeiPlugin
public class JeiDebugPlugin
implements IModPlugin {
    @Nullable
    public static IIngredientManager ingredientManager;
    @Nullable
    public static IJeiRuntime jeiRuntime;

    @Override
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("jei", "debug");
    }

    @Override
    public void registerIngredients(IModIngredientRegistration registration) {
        if (ClientConfig.getInstance().isDebugModeEnabled()) {
            DebugIngredientHelper ingredientHelper = new DebugIngredientHelper();
            DebugIngredientRenderer ingredientRenderer = new DebugIngredientRenderer(ingredientHelper);
            registration.register(DebugIngredient.TYPE, Collections.emptyList(), ingredientHelper, ingredientRenderer);
        }
    }

    @Override
    public void registerCategories(IRecipeCategoryRegistration registration) {
        if (ClientConfig.getInstance().isDebugModeEnabled()) {
            IJeiHelpers jeiHelpers = registration.getJeiHelpers();
            IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
            registration.addRecipeCategories(new DebugRecipeCategory(guiHelper));
        }
    }

    @Override
    public void registerRecipes(IRecipeRegistration registration) {
        ingredientManager = registration.getIngredientManager();
        if (ClientConfig.getInstance().isDebugModeEnabled()) {
            registration.addIngredientInfo(Arrays.asList(new ItemStack((IItemProvider)Blocks.field_180413_ao), new ItemStack((IItemProvider)Blocks.field_180414_ap), new ItemStack((IItemProvider)Blocks.field_180412_aq), new ItemStack((IItemProvider)Blocks.field_180411_ar), new ItemStack((IItemProvider)Blocks.field_180410_as), new ItemStack((IItemProvider)Blocks.field_180409_at)), VanillaTypes.ITEM, new ITextComponent[]{new TranslationTextComponent("description.jei.wooden.door.1"), new TranslationTextComponent("description.jei.wooden.door.2"), new TranslationTextComponent("description.jei.wooden.door.3")});
            registration.addIngredientInfo(new FluidStack((Fluid)Fluids.field_204546_a, 1000), VanillaTypes.FLUID, new ITextComponent[]{new StringTextComponent("water")});
            registration.addIngredientInfo(new DebugIngredient(1), DebugIngredient.TYPE, new ITextComponent[]{new StringTextComponent("debug")});
            registration.addIngredientInfo(new DebugIngredient(2), DebugIngredient.TYPE, new ITextComponent[]{new StringTextComponent("debug colored").func_240699_a_(TextFormatting.AQUA), new StringTextComponent("debug\\nSplit and colored").func_240699_a_(TextFormatting.LIGHT_PURPLE), new TranslationTextComponent("description.jei.debug.formatting.1", new Object[]{"various"}), new TranslationTextComponent("description.jei.debug.formatting.1", new Object[]{"various\\nsplit"}), new TranslationTextComponent("description.jei.debug.formatting.1", new Object[]{new StringTextComponent("various colored").func_240699_a_(TextFormatting.RED)}), new TranslationTextComponent("description.jei.debug.formatting.1", new Object[]{new StringTextComponent("various\\nsplit colored").func_240699_a_(TextFormatting.DARK_AQUA)}), new TranslationTextComponent("description.jei.debug.formatting.1", new Object[]{"\\nSplitting at the start"}), new TranslationTextComponent("description.jei.debug.formatting.1", new Object[]{"various all colored"}).func_240699_a_(TextFormatting.RED), new TranslationTextComponent("description.jei.debug.formatting.1", new Object[]{new TranslationTextComponent("description.jei.debug.formatting.3", new Object[]{"various"}).func_240699_a_(TextFormatting.DARK_AQUA)}), new TranslationTextComponent("description.jei.debug.formatting.2", new Object[]{new StringTextComponent("multiple").func_240699_a_(TextFormatting.GOLD).func_240699_a_(TextFormatting.ITALIC), new StringTextComponent("various").func_240699_a_(TextFormatting.RED)}).func_240699_a_(TextFormatting.BLUE), new TranslationTextComponent("description.jei.debug.formatting.1", new Object[]{new TranslationTextComponent("description.jei.debug.formatting.3", new Object[]{new TranslationTextComponent("description.jei.debug.formatting.2", new Object[]{new StringTextComponent("multiple").func_240699_a_(TextFormatting.GOLD).func_240699_a_(TextFormatting.ITALIC), new StringTextComponent("various").func_240699_a_(TextFormatting.RED)}).func_240699_a_(TextFormatting.DARK_AQUA)})})});
            registration.addRecipes(Arrays.asList(new DebugRecipe(), new DebugRecipe()), DebugRecipeCategory.UID);
        }
    }

    @Override
    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        if (ClientConfig.getInstance().isDebugModeEnabled()) {
            registration.addGuiContainerHandler(BrewingStandScreen.class, new IGuiContainerHandler<BrewingStandScreen>(){

                @Override
                public List<Rectangle2d> getGuiExtraAreas(BrewingStandScreen containerScreen) {
                    int widthMovement = (int)(System.currentTimeMillis() / 100L % 100L);
                    int size = 25 + widthMovement;
                    return Collections.singletonList(new Rectangle2d(containerScreen.getGuiLeft() + containerScreen.getXSize(), containerScreen.getGuiTop() + 40, size, size));
                }

                @Override
                @Nullable
                public Object getIngredientUnderMouse(BrewingStandScreen containerScreen, double mouseX, double mouseY) {
                    if (mouseX < 10.0 && mouseY < 10.0) {
                        return new FluidStack((Fluid)Fluids.field_204546_a, 1000);
                    }
                    return null;
                }
            });
            registration.addGhostIngredientHandler(BrewingStandScreen.class, new DebugGhostIngredientHandler());
        }
    }

    @Override
    public void registerFluidSubtypes(ISubtypeRegistration registration) {
        FlowingFluid water = Fluids.field_204546_a;
        FluidSubtypeHandlerTest subtype = new FluidSubtypeHandlerTest();
        registration.registerSubtypeInterpreter((Fluid)water, subtype);
    }

    @Override
    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        if (ClientConfig.getInstance().isDebugModeEnabled()) {
            registration.addRecipeCatalyst(new DebugIngredient(7), DebugRecipeCategory.UID);
            registration.addRecipeCatalyst(new FluidStack((Fluid)Fluids.field_204546_a, 1000), DebugRecipeCategory.UID);
            registration.addRecipeCatalyst(new ItemStack((IItemProvider)Items.field_151055_y), DebugRecipeCategory.UID);
            int i = 0;
            for (Item item : ForgeRegistries.ITEMS.getValues()) {
                ItemStack catalystIngredient = new ItemStack((IItemProvider)item);
                if (!catalystIngredient.func_190926_b()) {
                    registration.addRecipeCatalyst(catalystIngredient, DebugRecipeCategory.UID);
                }
                if (++i <= 30) continue;
                break;
            }
        }
    }

    @Override
    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        JeiDebugPlugin.jeiRuntime = jeiRuntime;
        if (ClientConfig.getInstance().isDebugModeEnabled()) {
            IIngredientManager ingredientManager = jeiRuntime.getIngredientManager();
            ingredientManager.addIngredientsAtRuntime(DebugIngredient.TYPE, DebugIngredientListFactory.create());
        }
    }
}

