/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalcustomization.loader;

import com.blakebr0.mysticalagriculture.api.MysticalAgricultureAPI;
import com.blakebr0.mysticalagriculture.api.crop.CropTier;
import com.blakebr0.mysticalcustomization.create.CropTierCreator;
import com.blakebr0.mysticalcustomization.modify.CropTierModifier;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.FarmlandBlock;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class CropTierLoader {
    private static final Logger LOGGER = LogManager.getLogger((String)"Mystical Customization");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final Map<CropTier, ResourceLocation> FARMLAND_MAP = new HashMap<CropTier, ResourceLocation>();
    public static final Map<CropTier, ResourceLocation> ESSENCE_MAP = new HashMap<CropTier, ResourceLocation>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onRegisterCrops() {
        File[] files;
        File dir = FMLPaths.CONFIGDIR.get().resolve("mysticalcustomization/tiers/").toFile();
        if (!dir.exists() && dir.mkdirs()) {
            LOGGER.info("Created /config/mysticalcustomization/tiers/ directory");
        }
        if ((files = dir.listFiles((FileFilter)FileFilterUtils.suffixFileFilter((String)".json"))) == null) {
            return;
        }
        for (File file : files) {
            FileReader reader = null;
            ResourceLocation id = null;
            try {
                JsonParser parser = new JsonParser();
                reader = new FileReader(file);
                JsonObject json = parser.parse((Reader)reader).getAsJsonObject();
                String name = file.getName().replace(".json", "");
                id = new ResourceLocation("mysticalcustomization", name);
                CropTierCreator.create(id, json);
                reader.close();
            }
            catch (Exception e) {
                try {
                    LOGGER.error("An error occurred while creating crop tier with id {}", id, (Object)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(reader);
                    throw throwable;
                }
                IOUtils.closeQuietly((Reader)reader);
                continue;
            }
            IOUtils.closeQuietly((Reader)reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onPostRegisterCrops() {
        block19: {
            File file;
            block20: {
                File dir = FMLPaths.CONFIGDIR.get().resolve("mysticalcustomization/").toFile();
                if (!dir.exists() && dir.mkdirs()) {
                    LOGGER.info("Created /config/mysticalcustomization/ directory");
                }
                if (!(file = FMLPaths.CONFIGDIR.get().resolve("mysticalcustomization/configure-tiers.json").toFile()).exists() || !file.isFile()) break block20;
                FileReader reader = null;
                try {
                    JsonParser parser = new JsonParser();
                    reader = new FileReader(file);
                    JsonObject json = parser.parse((Reader)reader).getAsJsonObject();
                    json.entrySet().forEach(entry -> {
                        String id = (String)entry.getKey();
                        JsonObject changes = ((JsonElement)entry.getValue()).getAsJsonObject();
                        CropTier tier = MysticalAgricultureAPI.getCropTierById((ResourceLocation)new ResourceLocation(id));
                        if (tier == null) {
                            String error = String.format("Invalid crop tier id provided: %s", id);
                            throw new JsonParseException(error);
                        }
                        CropTierModifier.modify(tier, changes);
                    });
                    reader.close();
                }
                catch (Exception e) {
                    try {
                        LOGGER.error("An error occurred while reading configure-tiers.json", (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(reader);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((Reader)reader);
                    break block19;
                }
                IOUtils.closeQuietly((Reader)reader);
                break block19;
            }
            try (FileWriter writer = new FileWriter(file);){
                JsonObject object = new JsonObject();
                GSON.toJson((JsonElement)object, (Appendable)writer);
            }
            catch (IOException e) {
                LOGGER.error("An error occurred while creating configure-tiers.json", (Throwable)e);
            }
        }
    }

    public static void onCommonSetup() {
        FARMLAND_MAP.forEach((tier, block) -> {
            Block farmland = (Block)ForgeRegistries.BLOCKS.getValue(block);
            if (farmland instanceof FarmlandBlock) {
                tier.setFarmland(() -> (FarmlandBlock)farmland);
            } else {
                LOGGER.error("Invalid farmland block provided");
            }
        });
        ESSENCE_MAP.forEach((tier, item) -> {
            Item essence = (Item)ForgeRegistries.ITEMS.getValue(item);
            if (essence == Items.field_190931_a) {
                throw new JsonSyntaxException("Invalid essence item provided");
            }
            tier.setEssence(() -> essence);
        });
    }
}

