/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalcustomization.loader;

import com.blakebr0.mysticalagriculture.api.registry.IMobSoulTypeRegistry;
import com.blakebr0.mysticalagriculture.api.soul.IMobSoulType;
import com.blakebr0.mysticalcustomization.create.MobSoulTypeCreator;
import com.blakebr0.mysticalcustomization.modify.MobSoulTypeModifier;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class MobSoulTypeLoader {
    private static final Logger LOGGER = LogManager.getLogger((String)"Mystical Customization");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final Map<IMobSoulType, List<ResourceLocation>> ENTITY_ADDITIONS_MAP = new HashMap<IMobSoulType, List<ResourceLocation>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onRegisterMobSoulTypes(IMobSoulTypeRegistry registry) {
        File[] files;
        File dir = FMLPaths.CONFIGDIR.get().resolve("mysticalcustomization/mobsoultypes/").toFile();
        if (!dir.exists() && dir.mkdirs()) {
            LOGGER.info("Created /config/mysticalcustomization/mobsoultypes/ directory");
        }
        if ((files = dir.listFiles((FileFilter)FileFilterUtils.suffixFileFilter((String)".json"))) == null) {
            return;
        }
        for (File file : files) {
            FileReader reader = null;
            ResourceLocation id = null;
            IMobSoulType type = null;
            try {
                JsonParser parser = new JsonParser();
                reader = new FileReader(file);
                JsonObject json = parser.parse((Reader)reader).getAsJsonObject();
                String name = file.getName().replace(".json", "");
                id = new ResourceLocation("mysticalcustomization", name);
                type = MobSoulTypeCreator.create(id, json);
                reader.close();
            }
            catch (Exception e) {
                try {
                    LOGGER.error("An error occurred while creating mob soul type with id {}", id, (Object)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(reader);
                    throw throwable;
                }
                IOUtils.closeQuietly((Reader)reader);
            }
            IOUtils.closeQuietly((Reader)reader);
            if (type == null) continue;
            registry.register(type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onPostRegisterMobSoulTypes(IMobSoulTypeRegistry registry) {
        block19: {
            File file;
            block20: {
                File dir = FMLPaths.CONFIGDIR.get().resolve("mysticalcustomization/").toFile();
                if (!dir.exists() && dir.mkdirs()) {
                    LOGGER.info("Created /config/mysticalcustomization/ directory");
                }
                if (!(file = FMLPaths.CONFIGDIR.get().resolve("mysticalcustomization/configure-mobsoultypes.json").toFile()).exists() || !file.isFile()) break block20;
                FileReader reader = null;
                try {
                    JsonParser parser = new JsonParser();
                    reader = new FileReader(file);
                    JsonObject json = parser.parse((Reader)reader).getAsJsonObject();
                    json.entrySet().forEach(entry -> {
                        String id = (String)entry.getKey();
                        JsonObject changes = ((JsonElement)entry.getValue()).getAsJsonObject();
                        IMobSoulType type = registry.getMobSoulTypeById(new ResourceLocation(id));
                        if (type == null) {
                            String error = String.format("Invalid mob soul type id provided: %s", id);
                            throw new JsonParseException(error);
                        }
                        MobSoulTypeModifier.modify(type, changes);
                    });
                    reader.close();
                }
                catch (Exception e) {
                    try {
                        LOGGER.error("An error occurred while reading configure-mobsoultypes.json", (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(reader);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((Reader)reader);
                    break block19;
                }
                IOUtils.closeQuietly((Reader)reader);
                break block19;
            }
            try (FileWriter writer = new FileWriter(file);){
                JsonObject object = new JsonObject();
                GSON.toJson((JsonElement)object, (Appendable)writer);
            }
            catch (IOException e) {
                LOGGER.error("An error occurred while creating configure-mobsoultypes.json", (Throwable)e);
            }
        }
        ENTITY_ADDITIONS_MAP.forEach((type, entities) -> entities.forEach(entity -> {
            boolean success = registry.addEntityTo(type, entity);
            if (!success) {
                LOGGER.error("Could not add entity {} to mob soul type {}, maybe it's already in use?", entity, (Object)type.getId());
            }
        }));
    }
}

