/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalcustomization.modify;

import com.blakebr0.mysticalagriculture.api.MysticalAgricultureAPI;
import com.blakebr0.mysticalagriculture.api.soul.IMobSoulType;
import com.blakebr0.mysticalcustomization.loader.MobSoulTypeLoader;
import com.blakebr0.mysticalcustomization.util.ParsingUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class MobSoulTypeModifier {
    private static final Logger LOGGER = LogManager.getLogger((String)"Mystical Customization");

    public static void modify(IMobSoulType type, JsonObject json) throws JsonSyntaxException {
        if (json.has("souls")) {
            float souls = JSONUtils.func_151217_k((JsonObject)json, (String)"souls");
            type.setSoulRequirement((double)souls);
        }
        if (json.has("entities")) {
            JsonObject entities = JSONUtils.func_152754_s((JsonObject)json, (String)"entities");
            if (entities.has("remove")) {
                JsonArray remove = JSONUtils.func_151214_t((JsonObject)entities, (String)"remove");
                remove.forEach(entity -> {
                    boolean success = MysticalAgricultureAPI.getMobSoulTypeRegistry().removeEntityFrom(type, new ResourceLocation(entity.getAsString()));
                    if (!success) {
                        LOGGER.error("Could not remove entity {} from mob soul type {}, maybe it wasn't added?", (Object)entity.getAsString(), (Object)type.getId());
                    }
                });
            }
            if (entities.has("add")) {
                JsonArray add = JSONUtils.func_151214_t((JsonObject)entities, (String)"add");
                add.forEach(entity -> MobSoulTypeLoader.ENTITY_ADDITIONS_MAP.computeIfAbsent(type, t -> new ArrayList()).add(new ResourceLocation(entity.getAsString())));
            }
        }
        if (json.has("color")) {
            String color = JSONUtils.func_151200_h((JsonObject)json, (String)"color");
            int i = ParsingUtils.parseHex(color, "color");
            type.setColor(i);
        }
        if (json.has("name")) {
            String name = JSONUtils.func_151200_h((JsonObject)json, (String)"name");
            type.setEntityDisplayName((ITextComponent)new StringTextComponent(name));
        }
        if (json.has("enabled")) {
            boolean enabled = JSONUtils.func_151212_i((JsonObject)json, (String)"enabled");
            type.setEnabled(enabled);
        }
    }
}

