/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.texture.ctx;

import com.google.common.base.Preconditions;
import java.util.EnumMap;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import team.chisel.ctm.client.texture.ctx.TextureContextPosition;
import team.chisel.ctm.client.texture.render.TextureMap;
import team.chisel.ctm.client.util.FaceOffset;

@ParametersAreNonnullByDefault
public abstract class TextureContextGrid
extends TextureContextPosition {
    private final EnumMap<Direction, Point2i> textureCoords = new EnumMap(Direction.class);
    private final long serialized;

    public TextureContextGrid(BlockPos pos, TextureMap tex, boolean applyOffset) {
        super(pos);
        Preconditions.checkArgument((tex.getXSize() * tex.getYSize() < 1024 ? 1 : 0) != 0, (String)"V* Texture size too large for texture %s", (Object)tex.getParticle());
        if (applyOffset) {
            this.applyOffset();
        }
        long serialized = 0L;
        for (Direction side : Direction.values()) {
            BlockPos modifiedPosition = this.position.func_177971_a((Vector3i)FaceOffset.getBlockPosOffsetFromFaceOffset(side, tex.getXOffset(), tex.getYOffset()));
            Point2i coords = this.calculateTextureCoord(modifiedPosition, tex.getXSize(), tex.getYSize(), side);
            this.textureCoords.put(side, coords);
            serialized |= (long)(coords.x + coords.y * tex.getXSize() << 10 * side.ordinal());
        }
        this.serialized = serialized;
    }

    protected abstract Point2i calculateTextureCoord(BlockPos var1, int var2, int var3, Direction var4);

    public Point2i getTextureCoords(Direction side) {
        return this.textureCoords.get(side);
    }

    @Override
    public long getCompressedData() {
        return this.serialized;
    }

    public static class Random
    extends TextureContextGrid {
        private static final java.util.Random rand = new java.util.Random();

        public Random(BlockPos pos, TextureMap tex, boolean applyOffset) {
            super(pos, tex, applyOffset);
        }

        @Override
        protected Point2i calculateTextureCoord(BlockPos pos, int w, int h, Direction side) {
            rand.setSeed(MathHelper.func_180186_a((Vector3i)pos) + (long)side.ordinal());
            rand.nextBoolean();
            int tx = rand.nextInt(w) + 1;
            int ty = rand.nextInt(h) + 1;
            return new Point2i(tx, ty);
        }
    }

    public static class Patterned
    extends TextureContextGrid {
        public Patterned(BlockPos pos, TextureMap tex, boolean applyOffset) {
            super(pos, tex, applyOffset);
        }

        @Override
        protected Point2i calculateTextureCoord(BlockPos pos, int w, int h, Direction side) {
            int ty;
            int tx;
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            if (side.func_176740_k().func_200128_b()) {
                tx = x % w;
                ty = (side.func_96559_d() * z + 1) % h;
            } else if (side.func_176740_k() == Direction.Axis.Z) {
                tx = x % w;
                ty = -y % h;
            } else {
                tx = (z + 1) % w;
                ty = -y % h;
            }
            if (side == Direction.NORTH || side == Direction.EAST) {
                tx = (w - tx - 1) % w;
            }
            if (tx < 0) {
                tx += w;
            }
            if (ty < 0) {
                ty += h;
            }
            return new Point2i(tx, ty);
        }
    }

    public static final class Point2i {
        private final int x;
        private final int y;

        public Point2i(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Point2i)) {
                return false;
            }
            Point2i other = (Point2i)o;
            if (this.getX() != other.getX()) {
                return false;
            }
            return this.getY() == other.getY();
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getX();
            result = result * 59 + this.getY();
            return result;
        }

        public String toString() {
            return "TextureContextGrid.Point2i(x=" + this.getX() + ", y=" + this.getY() + ")";
        }
    }
}

