/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.util;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.renderer.RenderType;

public enum BlockRenderLayer {
    SOLID(RenderType::func_228639_c_),
    CUTOUT(RenderType::func_228643_e_),
    CUTOUT_MIPPED(RenderType::func_228641_d_),
    TRANSLUCENT(RenderType::func_228645_f_),
    TRIPWIRE(RenderType::func_241715_r_);

    private static final Map<RenderType, BlockRenderLayer> reverseLookup;
    private final RenderType renderType;

    private BlockRenderLayer(Supplier<RenderType> renderType) {
        this.renderType = renderType.get();
    }

    public static BlockRenderLayer fromType(RenderType layer) {
        return reverseLookup.get(layer);
    }

    private BlockRenderLayer(RenderType renderType) {
        this.renderType = renderType;
    }

    public RenderType getRenderType() {
        return this.renderType;
    }

    static {
        reverseLookup = new IdentityHashMap<RenderType, BlockRenderLayer>();
        for (BlockRenderLayer layer : BlockRenderLayer.values()) {
            reverseLookup.put(layer.getRenderType(), layer);
        }
    }
}

