/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.client.map;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.client.FTBChunksClient;
import dev.ftb.mods.ftbchunks.client.map.MapChunk;
import dev.ftb.mods.ftbchunks.client.map.MapDimension;
import dev.ftb.mods.ftbchunks.client.map.MapManager;
import dev.ftb.mods.ftbchunks.client.map.MapRegionData;
import dev.ftb.mods.ftbchunks.client.map.MapTask;
import dev.ftb.mods.ftbchunks.client.map.RegionSyncKey;
import dev.ftb.mods.ftbchunks.client.map.RenderMapImageTask;
import dev.ftb.mods.ftbchunks.client.map.color.ColorUtils;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.math.MathUtils;
import dev.ftb.mods.ftblibrary.math.XZ;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.zip.InflaterInputStream;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.TextureUtil;
import org.jetbrains.annotations.Nullable;

public class MapRegion
implements MapTask {
    public static final Color4I GRID_COLOR = Color4I.rgba((int)70, (int)70, (int)70, (int)50);
    public final MapDimension dimension;
    public final XZ pos;
    private MapRegionData data;
    private boolean isLoadingData;
    public boolean saveData;
    private NativeImage renderedMapImage;
    private boolean updateRenderedMapImage;
    public boolean updateRenderedMapTexture;
    private int renderedMapImageTextureId;
    public boolean mapImageLoaded;
    public boolean renderingMapImage;

    public MapRegion(MapDimension d, XZ p) {
        this.dimension = d;
        this.pos = p;
        this.data = null;
        this.isLoadingData = false;
        this.saveData = false;
        this.renderedMapImage = null;
        this.updateRenderedMapImage = true;
        this.updateRenderedMapTexture = true;
        this.renderedMapImageTextureId = -1;
        this.mapImageLoaded = false;
    }

    public MapRegion created() {
        this.dimension.saveData = true;
        return this;
    }

    public boolean isDataLoaded() {
        return this.data != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapRegionData getDataBlocking() {
        Object object = this.dimension.manager.lock;
        synchronized (object) {
            return this.getDataBlockingNoSync();
        }
    }

    public MapRegionData getDataBlockingNoSync() {
        if (this.data != null) {
            return this.data;
        }
        this.data = new MapRegionData(this);
        Path chunksFile = this.dimension.directory.resolve(this.pos.toRegionString() + "-chunks.dat");
        if (Files.exists(chunksFile, new LinkOption[0]) && Files.isReadable(chunksFile)) {
            int y;
            int x;
            InputStream stream;
            FTBChunks.LOGGER.info("Found old map files, converting... [" + this.dimension.safeDimensionId + "/" + this.pos.toRegionString() + "]");
            try {
                stream = new DataInputStream(new BufferedInputStream(new InflaterInputStream(Files.newInputStream(chunksFile, new OpenOption[0]))));
                try {
                    ((DataInputStream)stream).readByte();
                    ((DataInputStream)stream).readByte();
                    int s = ((DataInputStream)stream).readShort();
                    for (int i = 0; i < s; ++i) {
                        x = ((DataInputStream)stream).readByte();
                        byte z = ((DataInputStream)stream).readByte();
                        long m = ((DataInputStream)stream).readLong();
                        MapChunk c = new MapChunk(this, XZ.of((int)x, (int)z));
                        c.modified = m;
                        this.data.chunks.put(c.pos, c);
                    }
                }
                finally {
                    ((FilterInputStream)stream).close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            try {
                stream = Files.newInputStream(this.dimension.directory.resolve(this.pos.toRegionString() + "-data.png"), new OpenOption[0]);
                try {
                    BufferedImage img = ImageIO.read(stream);
                    for (y = 0; y < 512; ++y) {
                        for (x = 0; x < 512; ++x) {
                            int index = x + y * 512;
                            int d = ColorUtils.convertToNative(img.getRGB(x, y) & 0xFFFFFF);
                            this.data.height[index] = (short)(d >> 16);
                            this.data.waterLightAndBiome[index] = (short)d;
                            this.data.foliage[index] = img.getRGB(x + 512, y) & 0xFFFFFF;
                            this.data.grass[index] = img.getRGB(x, y + 512) & 0xFFFFFF;
                            this.data.water[index] = img.getRGB(x + 512, y + 512) & 0xFFFFFF;
                        }
                    }
                }
                finally {
                    if (stream != null) {
                        stream.close();
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            try {
                stream = Files.newInputStream(this.dimension.directory.resolve(this.pos.toRegionString() + "-blocks.png"), new OpenOption[0]);
                try {
                    BufferedImage img = ImageIO.read(stream);
                    for (y = 0; y < 512; ++y) {
                        for (x = 0; x < 512; ++x) {
                            this.data.setBlockIndex(x + y * 512, ColorUtils.convertToNative(img.getRGB(x, y)));
                        }
                    }
                }
                finally {
                    if (stream != null) {
                        stream.close();
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            try {
                Files.deleteIfExists(chunksFile);
                Files.deleteIfExists(this.dimension.directory.resolve(this.pos.toRegionString() + "-data.png"));
                Files.deleteIfExists(this.dimension.directory.resolve(this.pos.toRegionString() + "-blocks.png"));
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            try {
                this.data.write();
                this.update(false);
            }
            catch (IOException ex) {
                this.update(true);
                ex.printStackTrace();
            }
        } else {
            try {
                this.data.read();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return this.data;
    }

    @Nullable
    public MapRegionData getData() {
        if (this.data == null && !this.isLoadingData) {
            this.isLoadingData = true;
            FTBChunks.EXECUTOR.execute(this::getDataBlocking);
        }
        return this.data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NativeImage getRenderedMapImage() {
        Object object = this.dimension.manager.lock;
        synchronized (object) {
            if (this.renderedMapImage == null) {
                this.renderedMapImage = new NativeImage(NativeImage.PixelFormat.RGBA, 512, 512, true);
                this.renderedMapImage.func_195715_a(0, 0, 512, 512, 0);
                this.update(false);
            }
        }
        if (this.updateRenderedMapImage && !this.renderingMapImage) {
            this.updateRenderedMapImage = false;
            this.mapImageLoaded = false;
            this.renderingMapImage = true;
            FTBChunks.EXECUTOR.execute(new RenderMapImageTask(this));
        }
        return this.renderedMapImage;
    }

    public int getRenderedMapImageTextureId() {
        if (this.renderedMapImageTextureId == -1) {
            this.renderedMapImageTextureId = TextureUtil.func_225678_a_();
            TextureUtil.func_225680_a_((int)this.renderedMapImageTextureId, (int)512, (int)512);
        }
        this.getRenderedMapImage();
        if (this.updateRenderedMapTexture) {
            this.mapImageLoaded = false;
            Minecraft.func_71410_x().func_222817_e(() -> {
                RenderSystem.bindTexture((int)this.renderedMapImageTextureId);
                this.uploadRenderedMapImage();
                this.mapImageLoaded = true;
                FTBChunksClient.updateMinimap = true;
            });
            this.updateRenderedMapTexture = false;
        }
        return this.renderedMapImageTextureId;
    }

    public void release() {
        if (this.saveData && this.data != null) {
            try {
                this.data.write();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        this.data = null;
        this.isLoadingData = false;
        this.releaseMapImage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseMapImage() {
        Object object = this.dimension.manager.lock;
        synchronized (object) {
            if (this.renderedMapImage != null) {
                this.renderedMapImage.close();
                this.renderedMapImage = null;
            }
        }
        if (this.renderedMapImageTextureId != -1) {
            TextureUtil.func_225679_a_((int)this.renderedMapImageTextureId);
            this.renderedMapImageTextureId = -1;
        }
        this.mapImageLoaded = false;
    }

    @Override
    public void runMapTask(MapManager m) throws Exception {
        if (this.data != null) {
            this.data.write();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRenderedMapImageRGBA(int x, int z, int col) {
        Object object = this.dimension.manager.lock;
        synchronized (object) {
            this.renderedMapImage.func_195700_a(x, z, col);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadRenderedMapImage() {
        Object object = this.dimension.manager.lock;
        synchronized (object) {
            this.renderedMapImage.func_195697_a(0, 0, 0, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterImageRenderTask() {
        Object object = this.dimension.manager.lock;
        synchronized (object) {
            this.updateRenderedMapTexture = true;
            FTBChunksClient.updateMinimap = true;
            this.renderingMapImage = false;
        }
    }

    public void update(boolean save) {
        if (save) {
            this.saveData = true;
            this.dimension.saveData = true;
        }
        this.updateRenderedMapImage = true;
        this.updateRenderedMapTexture = true;
        FTBChunksClient.updateMinimap = true;
    }

    public MapRegion offset(int x, int z) {
        return this.dimension.getRegion(this.pos.offset(x, z));
    }

    public RegionSyncKey getSyncKey() {
        RegionSyncKey key = new RegionSyncKey();
        key.dim = this.dimension.dimension;
        key.x = this.pos.x;
        key.z = this.pos.z;
        key.random = MathUtils.RAND.nextInt();
        return key;
    }

    public double distToPlayer() {
        return MathUtils.distSq((double)((double)this.pos.x * 512.0 + 256.0), (double)((double)this.pos.z * 512.0 + 256.0), (double)Minecraft.func_71410_x().field_71439_g.func_226277_ct_(), (double)Minecraft.func_71410_x().field_71439_g.func_226281_cx_());
    }

    public String toString() {
        return this.pos.toRegionString();
    }
}

