/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.compat.crafttweaker;

import com.blakebr0.cucumber.helper.RecipeHelper;
import com.blakebr0.mysticalagriculture.api.crafting.ISoulExtractionRecipe;
import com.blakebr0.mysticalagriculture.api.crafting.RecipeTypes;
import com.blakebr0.mysticalagriculture.api.soul.IMobSoulType;
import com.blakebr0.mysticalagriculture.crafting.recipe.SoulExtractionRecipe;
import com.blakebr0.mysticalagriculture.registry.MobSoulTypeRegistry;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.actions.IAction;
import com.blamejared.crafttweaker.api.actions.IRuntimeAction;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import org.openzen.zencode.java.ZenCodeType;

@ZenCodeType.Name(value="mods.mysticalagriculture.SoulExtractorCrafting")
@ZenRegister
public final class SoulExtractorCrafting {
    @ZenCodeType.Method
    public static void addRecipe(final String id, final IIngredient input, final String type, final double souls) {
        CraftTweakerAPI.apply((IAction)new IRuntimeAction(){

            public void apply() {
                IMobSoulType mobSoulType = MobSoulTypeRegistry.getInstance().getMobSoulTypeById(new ResourceLocation(type));
                SoulExtractionRecipe recipe = new SoulExtractionRecipe(new ResourceLocation("crafttweaker", id), input.asVanillaIngredient(), mobSoulType, souls);
                RecipeHelper.addRecipe((IRecipe)recipe);
            }

            public String describe() {
                return "Adding Soul Extractor Crafting recipe for " + input.getCommandString() + " to " + type;
            }
        });
    }

    @ZenCodeType.Method
    public static void remove(final IItemStack stack) {
        CraftTweakerAPI.apply((IAction)new IRuntimeAction(){

            public void apply() {
                List<ResourceLocation> recipes = ((Map)RecipeHelper.getRecipes().getOrDefault(RecipeTypes.SOUL_EXTRACTION, new HashMap())).values().stream().filter(r -> ((Ingredient)r.func_192400_c().get(0)).test(stack.getInternal())).map(IRecipe::func_199560_c).collect(Collectors.toList());
                recipes.forEach(r -> ((Map)RecipeHelper.getRecipes().get(RecipeTypes.SOUL_EXTRACTION)).remove(r));
            }

            public String describe() {
                return "Removing Soul Extractor Crafting recipes for item " + stack.getCommandString();
            }
        });
    }

    @ZenCodeType.Method
    public static void remove(final String type) {
        CraftTweakerAPI.apply((IAction)new IRuntimeAction(){

            public void apply() {
                List<ResourceLocation> recipes = ((Map)RecipeHelper.getRecipes().getOrDefault(RecipeTypes.SOUL_EXTRACTION, new HashMap())).values().stream().filter(r -> type.equals(((ISoulExtractionRecipe)r).getMobSoulType().getId().toString())).map(IRecipe::func_199560_c).collect(Collectors.toList());
                recipes.forEach(r -> ((Map)RecipeHelper.getRecipes().get(RecipeTypes.SOUL_EXTRACTION)).remove(r));
            }

            public String describe() {
                return "Removing Soul Extractor Crafting recipes for mob soul type " + type;
            }
        });
    }
}

