/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.crafting.recipe;

import com.blakebr0.cucumber.crafting.ISpecialRecipe;
import com.blakebr0.mysticalagriculture.api.crafting.IInfusionRecipe;
import com.blakebr0.mysticalagriculture.api.crafting.RecipeTypes;
import com.blakebr0.mysticalagriculture.init.ModRecipeSerializers;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class InfusionRecipe
implements ISpecialRecipe,
IInfusionRecipe {
    public static final int RECIPE_SIZE = 9;
    private final ResourceLocation recipeId;
    private final NonNullList<Ingredient> inputs;
    private final ItemStack output;

    public InfusionRecipe(ResourceLocation recipeId, NonNullList<Ingredient> inputs, ItemStack output) {
        this.recipeId = recipeId;
        this.inputs = inputs;
        this.output = output;
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public ItemStack func_77571_b() {
        return this.output;
    }

    public NonNullList<Ingredient> func_192400_c() {
        return this.inputs;
    }

    public ResourceLocation func_199560_c() {
        return this.recipeId;
    }

    public IRecipeSerializer<InfusionRecipe> func_199559_b() {
        return ModRecipeSerializers.INFUSION;
    }

    public IRecipeType<? extends IInfusionRecipe> func_222127_g() {
        return RecipeTypes.INFUSION;
    }

    public ItemStack getCraftingResult(IItemHandler inventory) {
        return this.output.func_77946_l();
    }

    public boolean matches(IItemHandler inventory) {
        ItemStack altarStack = inventory.getStackInSlot(0);
        return !this.inputs.isEmpty() && ((Ingredient)this.inputs.get(0)).test(altarStack) && super.matches(inventory);
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<InfusionRecipe> {
        public InfusionRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            NonNullList inputs = NonNullList.func_191197_a((int)9, (Object)Ingredient.field_193370_a);
            JsonObject input = JSONUtils.func_152754_s((JsonObject)json, (String)"input");
            inputs.set(0, (Object)Ingredient.func_199802_a((JsonElement)input));
            JsonArray ingredients = JSONUtils.func_151214_t((JsonObject)json, (String)"ingredients");
            for (int i = 0; i < ingredients.size(); ++i) {
                inputs.set(i + 1, (Object)Ingredient.func_199802_a((JsonElement)ingredients.get(i)));
            }
            ItemStack output = ShapedRecipe.func_199798_a((JsonObject)json.getAsJsonObject("result"));
            return new InfusionRecipe(recipeId, (NonNullList<Ingredient>)inputs, output);
        }

        public InfusionRecipe fromNetwork(ResourceLocation recipeId, PacketBuffer buffer) {
            int size = buffer.func_150792_a();
            NonNullList inputs = NonNullList.func_191197_a((int)size, (Object)Ingredient.field_193370_a);
            for (int i = 0; i < size; ++i) {
                inputs.set(i, (Object)Ingredient.func_199566_b((PacketBuffer)buffer));
            }
            ItemStack output = buffer.func_150791_c();
            return new InfusionRecipe(recipeId, (NonNullList<Ingredient>)inputs, output);
        }

        public void toNetwork(PacketBuffer buffer, InfusionRecipe recipe) {
            buffer.func_150787_b(recipe.inputs.size());
            for (Ingredient ingredient : recipe.inputs) {
                ingredient.func_199564_a(buffer);
            }
            buffer.func_150788_a(recipe.output);
        }
    }
}

