/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.internal.client.debug;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import it.zerono.mods.zerocore.lib.data.gfx.Colour;
import it.zerono.mods.zerocore.lib.debug.DebugHelper;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.entity.Entity;
import net.minecraft.item.DyeColor;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.DrawHighlightEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class VoxelShapeHighlighter {
    private static final Colour COLOUR_SHAPE = Colour.from(DyeColor.YELLOW);
    private static final Colour COLOUR_RENDERSHAPE = Colour.from(DyeColor.RED);
    private static final Colour COLOUR_COLLISIONSHAPE = Colour.from(DyeColor.BLUE);
    private static final Colour COLOUR_RAYTRACESHAPE = Colour.from(DyeColor.PURPLE);

    @SubscribeEvent
    public static void onHighlightBlock(DrawHighlightEvent.HighlightBlock event) {
        BlockPos position;
        BlockRayTraceResult result = event.getTarget();
        if (RayTraceResult.Type.BLOCK != result.func_216346_c()) {
            return;
        }
        World world = event.getInfo().func_216773_g().func_130014_f_();
        DebugHelper.VoxelShapeType voxelType = DebugHelper.getBlockVoxelShapeHighlight(world, position = result.func_216350_a());
        if (DebugHelper.VoxelShapeType.None == voxelType || !world.func_175723_af().func_177746_a(position)) {
            return;
        }
        BlockState blockstate = world.func_180495_p(position);
        if (blockstate.func_196958_f()) {
            return;
        }
        ActiveRenderInfo renderInfo = event.getInfo();
        ISelectionContext selection = ISelectionContext.func_216374_a((Entity)renderInfo.func_216773_g());
        IVertexBuilder builder = event.getBuffers().getBuffer(RenderType.func_228659_m_());
        MatrixStack matrixStack = event.getMatrix();
        double x = (double)position.func_177958_n() - renderInfo.func_216785_c().func_82615_a();
        double y = (double)position.func_177956_o() - renderInfo.func_216785_c().func_82617_b();
        double z = (double)position.func_177952_p() - renderInfo.func_216785_c().func_82616_c();
        switch (voxelType) {
            case General: {
                VoxelShapeHighlighter.paint(matrixStack, builder, x, y, z, COLOUR_SHAPE, blockstate.func_215700_a((IBlockReader)world, position, selection));
                break;
            }
            case Render: {
                VoxelShapeHighlighter.paint(matrixStack, builder, x, y, z, COLOUR_RENDERSHAPE, blockstate.func_196951_e((IBlockReader)world, position));
                break;
            }
            case Collision: {
                VoxelShapeHighlighter.paint(matrixStack, builder, x, y, z, COLOUR_COLLISIONSHAPE, blockstate.func_215685_b((IBlockReader)world, position, selection));
                break;
            }
            case RayTrace: {
                VoxelShapeHighlighter.paint(matrixStack, builder, x, y, z, COLOUR_RAYTRACESHAPE, blockstate.func_199611_f((IBlockReader)world, position, ISelectionContext.func_216377_a()));
            }
        }
        event.setCanceled(true);
    }

    private static void paint(MatrixStack matrixStack, IVertexBuilder vertexBuilder, double originX, double originY, double originZ, Colour colour, VoxelShape voxelShape) {
        Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
        float red = colour.glRed();
        float green = colour.glGreen();
        float blue = colour.glBlue();
        voxelShape.func_197754_a((x1, y1, z1, x2, y2, z2) -> {
            vertexBuilder.func_227888_a_(matrix, (float)(x1 + originX), (float)(y1 + originY), (float)(z1 + originZ)).func_227885_a_(red, green, blue, 0.5f).func_181675_d();
            vertexBuilder.func_227888_a_(matrix, (float)(x2 + originX), (float)(y2 + originY), (float)(z2 + originZ)).func_227885_a_(red, green, blue, 0.5f).func_181675_d();
        });
    }
}

