/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.block;

import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.block.IBlockStateUpdater;
import it.zerono.mods.zerocore.lib.block.INeighborChangeListener;
import it.zerono.mods.zerocore.lib.item.ItemHelper;
import it.zerono.mods.zerocore.lib.world.WorldHelper;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.DoubleSupplier;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class ModBlock
extends Block
implements IBlockStateUpdater {
    public static AbstractBlock.Properties createProperties(Material material, SoundType soundType, float hardnessAndResistance) {
        return ModBlock.createProperties(material, soundType, hardnessAndResistance, hardnessAndResistance, false);
    }

    public static AbstractBlock.Properties createProperties(Material material, SoundType soundType, float hardness, float resistance, boolean randomTick) {
        AbstractBlock.Properties builder = AbstractBlock.Properties.func_200945_a((Material)material).func_200948_a(hardness, resistance).func_200947_a(soundType);
        if (randomTick) {
            builder.func_200944_c();
        }
        return builder;
    }

    public static ITextComponent getNameForTranslation(Block block) {
        return new TranslationTextComponent(block.func_149739_a());
    }

    public static int lightValueFrom(float value) {
        return (int)(15.0f * value);
    }

    public ModBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j(this.buildDefaultState((BlockState)this.func_176194_O().func_177621_b()));
    }

    public ItemStack createItemStack() {
        return ItemHelper.stackFrom((IItemProvider)this, 1);
    }

    public ItemStack createItemStack(int amount) {
        return ItemHelper.stackFrom((IItemProvider)this, amount);
    }

    public BlockItem createBlockItem(Item.Properties properties) {
        return new BlockItem((Block)this, properties);
    }

    public void callOnLogicalSide(World world, Runnable serverCode, Runnable clientCode) {
        CodeHelper.callOnLogicalSide(world, serverCode, clientCode);
    }

    public <T> T callOnLogicalSide(World world, Supplier<T> serverCode, Supplier<T> clientCode) {
        return CodeHelper.callOnLogicalSide(world, serverCode, clientCode);
    }

    public boolean callOnLogicalSide(World world, BooleanSupplier serverCode, BooleanSupplier clientCode) {
        return CodeHelper.callOnLogicalSide(world, serverCode, clientCode);
    }

    public int callOnLogicalSide(World world, IntSupplier serverCode, IntSupplier clientCode) {
        return CodeHelper.callOnLogicalSide(world, serverCode, clientCode);
    }

    public long callOnLogicalSide(World world, LongSupplier serverCode, LongSupplier clientCode) {
        return CodeHelper.callOnLogicalSide(world, serverCode, clientCode);
    }

    public double callOnLogicalSide(World world, DoubleSupplier serverCode, DoubleSupplier clientCode) {
        return CodeHelper.callOnLogicalSide(world, serverCode, clientCode);
    }

    public void callOnLogicalServer(World world, Runnable code) {
        CodeHelper.callOnLogicalServer(world, code);
    }

    public void callOnLogicalServer(World world, Consumer<World> code) {
        if (CodeHelper.calledByLogicalServer(world)) {
            code.accept(world);
        }
    }

    public <T> T callOnLogicalServer(World world, Supplier<T> code, Supplier<T> invalidSideReturnValue) {
        return CodeHelper.callOnLogicalServer(world, code, invalidSideReturnValue);
    }

    public boolean callOnLogicalServer(World world, BooleanSupplier code) {
        return CodeHelper.callOnLogicalServer(world, code);
    }

    public int callOnLogicalServer(World world, IntSupplier code, int invalidSideReturnValue) {
        return CodeHelper.callOnLogicalServer(world, code, invalidSideReturnValue);
    }

    public long callOnLogicalServer(World world, LongSupplier code, long invalidSideReturnValue) {
        return CodeHelper.callOnLogicalServer(world, code, invalidSideReturnValue);
    }

    public double callOnLogicalServer(World world, DoubleSupplier code, double invalidSideReturnValue) {
        return CodeHelper.callOnLogicalServer(world, code, invalidSideReturnValue);
    }

    public void callOnLogicalClient(World world, Runnable code) {
        CodeHelper.callOnLogicalClient(world, code);
    }

    public void callOnLogicalClient(World world, Consumer<World> code) {
        if (CodeHelper.calledByLogicalClient(world)) {
            code.accept(world);
        }
    }

    public <T> T callOnLogicalClient(World world, Supplier<T> code, Supplier<T> invalidSideReturnValue) {
        return CodeHelper.callOnLogicalClient(world, code, invalidSideReturnValue);
    }

    public boolean callOnLogicalClient(World world, BooleanSupplier code) {
        return CodeHelper.callOnLogicalClient(world, code);
    }

    public int callOnLogicalClient(World world, IntSupplier code, int invalidSideReturnValue) {
        return CodeHelper.callOnLogicalClient(world, code, invalidSideReturnValue);
    }

    public long callOnLogicalClient(World world, LongSupplier code, long invalidSideReturnValue) {
        return CodeHelper.callOnLogicalClient(world, code, invalidSideReturnValue);
    }

    public double callOnLogicalClient(World world, DoubleSupplier code, double invalidSideReturnValue) {
        return CodeHelper.callOnLogicalClient(world, code, invalidSideReturnValue);
    }

    @Override
    public void updateBlockState(BlockState currentState, IWorld world, BlockPos position, @Nullable TileEntity tileEntity, int updateFlags) {
        world.func_180501_a(position, this.buildUpdatedState(currentState, (IBlockReader)world, position, tileEntity), updateFlags);
    }

    @Override
    public BlockState buildUpdatedState(BlockState currentState, IBlockReader reader, BlockPos position, @Nullable TileEntity tileEntity) {
        return currentState;
    }

    public void func_220069_a(BlockState state, World world, BlockPos blockPosition, Block block, BlockPos neighborPosition, boolean isMoving) {
        super.func_220069_a(state, world, blockPosition, block, neighborPosition, isMoving);
        if (this instanceof INeighborChangeListener.Notifier && this.hasTileEntity(state)) {
            WorldHelper.getTile(world, blockPosition).filter(te -> te instanceof INeighborChangeListener).map(te -> (INeighborChangeListener)te).ifPresent(listener -> listener.onNeighborBlockChanged(state, neighborPosition, isMoving));
        }
    }

    public void onNeighborChange(BlockState state, IWorldReader world, BlockPos blockPosition, BlockPos neighborPosition) {
        TileEntity te;
        super.onNeighborChange(state, world, blockPosition, neighborPosition);
        if (this instanceof INeighborChangeListener.Notifier && this.hasTileEntity(state) && (te = WorldHelper.getLoadedTile(world, blockPosition)) instanceof INeighborChangeListener) {
            ((INeighborChangeListener)te).onNeighborTileChanged(state, neighborPosition);
        }
    }

    public VoxelShape func_230335_e_(BlockState state, IBlockReader reader, BlockPos pos) {
        return super.func_230335_e_(state, reader, pos);
    }

    public boolean func_189539_a(BlockState state, World world, BlockPos position, int id, int param) {
        if (this.hasTileEntity(state)) {
            return WorldHelper.getTile(world, position).map(tile -> tile.func_145842_c(id, param)).orElse(super.func_189539_a(state, world, position, id, param));
        }
        return super.func_189539_a(state, world, position, id, param);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        this.buildBlockState(builder);
    }

    protected void buildBlockState(StateContainer.Builder<Block, BlockState> builder) {
    }

    protected BlockState buildDefaultState(BlockState state) {
        return state;
    }
}

