/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.client.gui.control;

import com.mojang.blaze3d.matrix.MatrixStack;
import it.zerono.mods.zerocore.lib.client.gui.ButtonState;
import it.zerono.mods.zerocore.lib.client.gui.IWindow;
import it.zerono.mods.zerocore.lib.client.gui.ModContainerScreen;
import it.zerono.mods.zerocore.lib.client.gui.Padding;
import it.zerono.mods.zerocore.lib.client.gui.control.AbstractButtonControl;
import it.zerono.mods.zerocore.lib.client.gui.layout.HorizontalAlignment;
import it.zerono.mods.zerocore.lib.client.gui.layout.VerticalAlignment;
import it.zerono.mods.zerocore.lib.event.Event;
import it.zerono.mods.zerocore.lib.event.IEvent;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import java.util.function.BiConsumer;
import net.minecraft.util.text.ITextComponent;

public class Button
extends AbstractButtonControl {
    public final IEvent<BiConsumer<Button, Integer>> Clicked;
    private boolean _pressed;
    private Padding _pressedPadding;

    public Button(ModContainerScreen<? extends ModContainer> gui, String name, ITextComponent text) {
        this(gui, name, text.getString());
    }

    public Button(ModContainerScreen<? extends ModContainer> gui, String name, String text) {
        super(gui, name, text);
        this.setPressed(false);
        this.setPadding(3, 3, 2, 2);
        this.setHorizontalAlignment(HorizontalAlignment.Center);
        this.setVerticalAlignment(VerticalAlignment.Center);
        this.Clicked = new Event<BiConsumer<Button, Integer>>();
    }

    @Override
    public void onWindowClosed() {
        super.onWindowClosed();
        this.Clicked.unsubscribeAll();
    }

    @Override
    public Padding getPadding() {
        return this.getPressed() ? this._pressedPadding : super.getPadding();
    }

    @Override
    public void setPadding(int left, int right, int top, int bottom) {
        super.setPadding(left, right, top, bottom);
        this._pressedPadding = Padding.get(left + 1, right - 1, top + 1, bottom - 1);
    }

    @Override
    public boolean onMouseClicked(IWindow wnd, int mouseX, int mouseY, int clickedButton) {
        super.onMouseClicked(wnd, mouseX, mouseY, clickedButton);
        this.setPressed(true);
        wnd.captureMouse(this);
        return true;
    }

    @Override
    public boolean onMouseReleased(IWindow wnd, int mouseX, int mouseY, int releasedButton) {
        if (this.getPressed()) {
            this.setPressed(false);
            wnd.releaseMouse();
            this.Clicked.raise(c -> c.accept(this, releasedButton));
        }
        return true;
    }

    @Override
    public void onPaintBackground(MatrixStack matrix, float partialTicks, int mouseX, int mouseY) {
        this.paintButton3D(matrix, this.getButtonState(), 0, 0, this.getBounds().Width, this.getBounds().Height);
    }

    @Override
    protected ButtonState getButtonState() {
        if (!this.getEnabled()) {
            return ButtonState.DefaultDisabled;
        }
        if (this.getPressed()) {
            return ButtonState.ActiveHighlighted;
        }
        if (this.getMouseOver()) {
            return ButtonState.DefaultHighlighted;
        }
        return ButtonState.Default;
    }

    @Override
    protected int getIconWidth() {
        int width = super.getIconWidth();
        return 0 != width ? width + 2 : 0;
    }

    @Override
    protected StringBuilder toStringBuilder() {
        return super.toStringBuilder().append(" pressed:").append(this._pressed);
    }

    protected boolean getPressed() {
        return this._pressed;
    }

    protected void setPressed(boolean pressed) {
        this._pressed = pressed;
    }
}

