/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.client.gui.control;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.matrix.MatrixStack;
import it.zerono.mods.zerocore.lib.client.gui.ModContainerScreen;
import it.zerono.mods.zerocore.lib.client.gui.control.AbstractGaugeBar;
import it.zerono.mods.zerocore.lib.client.gui.sprite.ISprite;
import it.zerono.mods.zerocore.lib.client.render.ModRenderHelper;
import it.zerono.mods.zerocore.lib.data.EnumIndexedArray;
import it.zerono.mods.zerocore.lib.data.geometry.Rectangle;
import it.zerono.mods.zerocore.lib.data.gfx.Colour;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.util.Direction;
import net.minecraft.util.math.MathHelper;

public class MultiValueGaugeBar<Index extends Enum<Index>>
extends AbstractGaugeBar {
    private final EnumIndexedArray<Index, Double> _values;
    private final EnumIndexedArray<Index, ISprite> _sprites;
    private final EnumIndexedArray<Index, Colour> _tints;

    @SafeVarargs
    public MultiValueGaugeBar(ModContainerScreen<? extends ModContainer> gui, String name, double maxValue, Index firstValidIndex, Index secondValidIndex, Index ... otherValidIndices) {
        super(gui, name, maxValue);
        this._values = new EnumIndexedArray(Double[]::new, firstValidIndex, secondValidIndex, otherValidIndices);
        this._sprites = new EnumIndexedArray(ISprite[]::new, firstValidIndex, secondValidIndex, otherValidIndices);
        this._tints = new EnumIndexedArray(Colour[]::new, firstValidIndex, secondValidIndex, otherValidIndices);
        this._values.setAll(0.0);
    }

    public double getValue(Index index) {
        return this._values.getElement(index).orElse(0.0);
    }

    public void setValue(Index index, double value) {
        this._values.setElement(index, MathHelper.func_151237_a((double)value, (double)0.0, (double)this.getMaxValueFor(index)));
    }

    public void setBarSprite(Index index, ISprite sprite) {
        this._sprites.setElement(index, (ISprite)Preconditions.checkNotNull((Object)sprite));
    }

    public void setBarSprite(Index index, Supplier<ISprite> sprite) {
        this.setBarSprite(index, sprite.get());
    }

    public void setBarSpriteTint(Index index, Colour tint) {
        this._tints.setElement(index, tint);
    }

    @Override
    public void onPaint(MatrixStack matrix, float partialTicks, int mouseX, int mouseY) {
        super.onPaint(matrix, partialTicks, mouseX, mouseY);
        Rectangle area = this.getPaddingRect();
        int skip = 0;
        if (Direction.Plane.HORIZONTAL == area.getLayout()) {
            for (Enum index : this._values.getValidIndices()) {
                skip += this.paintValueRect(matrix, index, area, skip);
            }
        } else {
            for (Enum index : this._values.getValidIndices()) {
                skip += this.paintValueRect(matrix, index, area, skip);
            }
        }
    }

    @Override
    protected StringBuilder toStringBuilder() {
        return super.toStringBuilder().append(" indices:").append(this._values.getValidIndices());
    }

    protected double getFillRatio() {
        return this._values.stream().mapToDouble(Double::doubleValue).sum() / this.getMaxValue();
    }

    protected double getFillRatio(Index index) {
        return this.getValue(index) / this.getMaxValue();
    }

    protected double getMaxValueFor(Index index) {
        return this.getMaxValue();
    }

    protected Optional<ISprite> getSprite(Index index) {
        return this._sprites.getElement(index);
    }

    protected Optional<Colour> getTint(Index index) {
        return this._tints.getElement(index);
    }

    protected int paintValueRect(MatrixStack matrix, Index index, Rectangle rect, int skip) {
        return this.getSprite(index).map(sprite -> ModRenderHelper.paintVerticalProgressSprite(matrix, sprite, this.getTint(index).orElse(Colour.WHITE), this.controlToScreen(rect.Origin.X, rect.Origin.Y), (int)this.getZLevel(), rect, skip, this.getFillRatio(index))).orElse(0);
    }
}

