/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.client.gui.control;

import com.mojang.blaze3d.matrix.MatrixStack;
import it.zerono.mods.zerocore.lib.client.gui.ButtonState;
import it.zerono.mods.zerocore.lib.client.gui.IWindow;
import it.zerono.mods.zerocore.lib.client.gui.ModContainerScreen;
import it.zerono.mods.zerocore.lib.client.gui.control.AbstractControl;
import it.zerono.mods.zerocore.lib.client.gui.control.Theme;
import it.zerono.mods.zerocore.lib.client.render.ModRenderHelper;
import it.zerono.mods.zerocore.lib.data.geometry.Point;
import it.zerono.mods.zerocore.lib.data.geometry.Polygon;
import it.zerono.mods.zerocore.lib.data.geometry.Rectangle;
import it.zerono.mods.zerocore.lib.data.gfx.Colour;
import it.zerono.mods.zerocore.lib.event.Event;
import it.zerono.mods.zerocore.lib.event.IEvent;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundEvents;

public class UpDown
extends AbstractControl {
    public final IEvent<BiConsumer<Direction.AxisDirection, Integer>> Clicked = new Event<BiConsumer<Direction.AxisDirection, Integer>>();
    private Polygon _upArrow;
    private Polygon _downArrow;
    private Polygon _upArrowPaint;
    private Polygon _downArrowPaint;
    private Direction.AxisDirection _pressed;
    private Direction.AxisDirection _over;

    public UpDown(ModContainerScreen<? extends ModContainer> gui, String name) {
        super(gui, name);
    }

    @Override
    public void onMoved() {
        super.onMoved();
        Rectangle bound = this.getBounds();
        int w = bound.Width - 1;
        int h = bound.Height - 1;
        this._upArrow = new Polygon(-1, -1, w, -1, -1, h);
        this._downArrow = new Polygon(w + 1, 0, w + 1, h + 1, 0, h + 1);
        this._upArrowPaint = new Polygon(0, 0, w - 1, 0, 0, h - 1).transform(this::controlToScreen);
        this._downArrowPaint = new Polygon(w, 1, w, h, 1, h).transform(this::controlToScreen);
    }

    @Override
    public boolean onMouseClicked(IWindow wnd, int mouseX, int mouseY, int clickedButton) {
        super.onMouseClicked(wnd, mouseX, mouseY, clickedButton);
        int childX = mouseX - this.getBounds().Origin.X;
        int childY = mouseY - this.getBounds().Origin.Y;
        if (this._upArrow.contains(childX, childY)) {
            this.setPressed(Direction.AxisDirection.POSITIVE);
        } else if (this._downArrow.contains(childX, childY)) {
            this.setPressed(Direction.AxisDirection.NEGATIVE);
        } else {
            this.setPressed(null);
        }
        wnd.captureMouse(this);
        this.playClickSound();
        return true;
    }

    @Override
    public boolean onMouseReleased(IWindow wnd, int mouseX, int mouseY, int releasedButton) {
        this.getPressed().ifPresent(button -> {
            this.setPressed(null);
            wnd.releaseMouse();
            this.Clicked.raise(c -> c.accept(button, releasedButton));
        });
        return true;
    }

    @Override
    public void setMouseOver(boolean over, int mouseX, int mouseY) {
        super.setMouseOver(over, mouseX, mouseY);
        if (over) {
            Point mouse = this.screenToControl(mouseX, mouseY);
            if (this._upArrow.contains(mouse.X, mouse.Y)) {
                this.setOver(Direction.AxisDirection.POSITIVE);
            } else if (this._downArrow.contains(mouse.X, mouse.Y)) {
                this.setOver(Direction.AxisDirection.NEGATIVE);
            } else {
                this.setOver(null);
            }
        } else {
            this.setOver(null);
        }
    }

    @Override
    public void onPaintBackground(MatrixStack matrix, float partialTicks, int mouseX, int mouseY) {
        this.paintUpButton(matrix);
        this.paintDownButton(matrix);
    }

    @Override
    protected StringBuilder toStringBuilder() {
        return super.toStringBuilder().append(" pressed:").append(this._pressed).append(" over:").append(this._over);
    }

    protected Optional<Direction.AxisDirection> getPressed() {
        return Optional.ofNullable(this._pressed);
    }

    protected void setPressed(@Nullable Direction.AxisDirection button) {
        this._pressed = button;
    }

    protected Optional<Direction.AxisDirection> getOver() {
        return Optional.ofNullable(this._over);
    }

    protected void setOver(@Nullable Direction.AxisDirection button) {
        this._over = button;
    }

    protected ButtonState getButtonState(Direction.AxisDirection button) {
        if (!this.getEnabled()) {
            return ButtonState.DefaultDisabled;
        }
        if (this.getPressed().filter(b -> b == button).isPresent()) {
            return ButtonState.ActiveHighlighted;
        }
        if (this.getOver().filter(b -> b == button).isPresent()) {
            return ButtonState.DefaultHighlighted;
        }
        return ButtonState.Default;
    }

    protected void paintUpButton(MatrixStack matrix) {
        ButtonState state = this.getButtonState(Direction.AxisDirection.POSITIVE);
        switch (state) {
            case DefaultDisabled: {
                this.paintUpButton(matrix, Theme.DARK_OUTLINE_COLOR, Theme.BUTTON_DISABLED_3D_GRADIENT_LIGHT, Theme.BUTTON_DISABLED_3D_GRADIENT_DARK, Theme.BUTTON_DISABLED_3D_BORDER_LIGHT, Theme.BUTTON_DISABLED_3D_BORDER_DARK);
                break;
            }
            case Active: 
            case ActiveHighlighted: {
                this.paintUpButton(matrix, Theme.DARK_OUTLINE_COLOR, Theme.BUTTON_ACTIVE_3D_GRADIENT_LIGHT, Theme.BUTTON_ACTIVE_3D_GRADIENT_DARK, Theme.BUTTON_ACTIVE_3D_BORDER_LIGHT, Theme.BUTTON_ACTIVE_3D_BORDER_DARK);
                break;
            }
            case DefaultHighlighted: {
                this.paintUpButton(matrix, Theme.DARK_OUTLINE_COLOR, Theme.BUTTON_HIGHLIGHTED_3D_GRADIENT_LIGHT, Theme.BUTTON_HIGHLIGHTED_3D_GRADIENT_DARK, Theme.BUTTON_HIGHLIGHTED_3D_BORDER_LIGHT, Theme.BUTTON_HIGHLIGHTED_3D_BORDER_DARK);
                break;
            }
            case Default: {
                this.paintUpButton(matrix, Theme.DARK_OUTLINE_COLOR, Theme.BUTTON_NORMAL_3D_GRADIENT_LIGHT, Theme.BUTTON_NORMAL_3D_GRADIENT_DARK, Theme.BUTTON_NORMAL_3D_BORDER_LIGHT, Theme.BUTTON_NORMAL_3D_BORDER_DARK);
            }
        }
    }

    protected void paintDownButton(MatrixStack matrix) {
        ButtonState state = this.getButtonState(Direction.AxisDirection.NEGATIVE);
        switch (state) {
            case DefaultDisabled: {
                this.paintDownButton(matrix, Theme.DARK_OUTLINE_COLOR, Theme.BUTTON_DISABLED_3D_GRADIENT_LIGHT, Theme.BUTTON_DISABLED_3D_GRADIENT_DARK, Theme.BUTTON_DISABLED_3D_BORDER_LIGHT, Theme.BUTTON_DISABLED_3D_BORDER_DARK);
                break;
            }
            case Active: 
            case ActiveHighlighted: {
                this.paintDownButton(matrix, Theme.DARK_OUTLINE_COLOR, Theme.BUTTON_ACTIVE_3D_GRADIENT_LIGHT, Theme.BUTTON_ACTIVE_3D_GRADIENT_DARK, Theme.BUTTON_ACTIVE_3D_BORDER_LIGHT, Theme.BUTTON_ACTIVE_3D_BORDER_DARK);
                break;
            }
            case DefaultHighlighted: {
                this.paintDownButton(matrix, Theme.DARK_OUTLINE_COLOR, Theme.BUTTON_HIGHLIGHTED_3D_GRADIENT_LIGHT, Theme.BUTTON_HIGHLIGHTED_3D_GRADIENT_DARK, Theme.BUTTON_HIGHLIGHTED_3D_BORDER_LIGHT, Theme.BUTTON_HIGHLIGHTED_3D_BORDER_DARK);
                break;
            }
            case Default: {
                this.paintDownButton(matrix, Theme.DARK_OUTLINE_COLOR, Theme.BUTTON_NORMAL_3D_GRADIENT_LIGHT, Theme.BUTTON_NORMAL_3D_GRADIENT_DARK, Theme.BUTTON_NORMAL_3D_BORDER_LIGHT, Theme.BUTTON_NORMAL_3D_BORDER_DARK);
            }
        }
    }

    protected void paintUpButton(MatrixStack matrix, Colour darkOutlineColour, Colour gradientLightColour, Colour gradientDarkColour, Colour borderLightColour, Colour borderDarkColour) {
        float z = this.getZLevel();
        int x1 = this._upArrowPaint.getX(0);
        int y1 = this._upArrowPaint.getY(0);
        int x2 = this._upArrowPaint.getX(1);
        int y2 = this._upArrowPaint.getY(1);
        int x3 = this._upArrowPaint.getX(2);
        int y3 = this._upArrowPaint.getY(2);
        ModRenderHelper.paint3DGradientTriangle(matrix, (double)x1 + 1.0, (double)y1 + 1.0, (double)x2 - 0.5, (double)y2 + 1.0, (double)x3 + 1.0, y3, z, gradientLightColour, gradientDarkColour);
        ModRenderHelper.paintSolidLines(matrix, borderLightColour, 1.0 * this.getGui().getGuiScaleFactor(), z, (double)x1 + 1.0, (double)y1 + 1.5, (double)x2 - 1.5, (double)y2 + 1.5);
        ModRenderHelper.paintSolidLines(matrix, borderLightColour, 1.0 * this.getGui().getGuiScaleFactor(), z, (double)x1 + 1.5, (double)y1 + 1.5, (double)x3 + 1.5, (double)y3 - 1.5);
        ModRenderHelper.paintSolidLines(matrix, borderDarkColour, 1.0 * this.getGui().getGuiScaleFactor(), z, (double)x2 - 1.0, (double)y2 + 1.0, (double)x3 + 1.0, (double)y3 - 0.5);
        ModRenderHelper.paintSolidLines(matrix, darkOutlineColour, 1.0 * this.getGui().getGuiScaleFactor(), z, x1, (double)y1 + 0.5, (double)x2 + 1.0, (double)y2 + 0.5, (double)x2 + 0.5, (double)y2 + 0.5, (double)x3 + 0.5, (double)y3 + 1.0, (double)x3 + 0.5, (double)y3 + 1.0, (double)x1 + 0.5, y1);
    }

    protected void paintDownButton(MatrixStack matrix, Colour darkOutlineColour, Colour gradientLightColour, Colour gradientDarkColour, Colour borderLightColour, Colour borderDarkColour) {
        float z = this.getZLevel();
        int x1 = this._downArrowPaint.getX(0);
        int y1 = this._downArrowPaint.getY(0);
        int x2 = this._downArrowPaint.getX(1);
        int y2 = this._downArrowPaint.getY(1);
        int x3 = this._downArrowPaint.getX(2);
        int y3 = this._downArrowPaint.getY(2);
        ModRenderHelper.paint3DGradientTriangle(matrix, x1, (double)y1 + 1.5, x2, y2, (double)x3 + 1.5, y3, z, gradientLightColour, gradientDarkColour);
        ModRenderHelper.paintSolidLines(matrix, borderLightColour, 1.0 * this.getGui().getGuiScaleFactor(), z, x1, (double)y1 + 2.0, (double)x3 + 2.0, (double)y3 - 0.5);
        ModRenderHelper.paintSolidLines(matrix, borderDarkColour, 1.0 * this.getGui().getGuiScaleFactor(), z, (double)x1 - 0.5, (double)y1 + 1.5, (double)x2 - 0.5, (double)y2 - 1.0);
        ModRenderHelper.paintSolidLines(matrix, borderDarkColour, 1.0 * this.getGui().getGuiScaleFactor(), z, x2, (double)y2 - 0.5, (double)x3 + 1.5, (double)y3 - 0.5);
        ModRenderHelper.paintSolidLines(matrix, darkOutlineColour, 1.0 * this.getGui().getGuiScaleFactor(), z, (double)x1 + 0.5, y1, (double)x2 + 0.5, (double)y2 + 1.0, (double)x2 + 0.5, (double)y2 + 0.5, x3, (double)y3 + 0.5, (double)x3 + 0.5, (double)y3 + 0.5, (double)x1 + 0.5, y1);
    }

    private void playClickSound() {
        this.playSound(SoundEvents.field_187909_gi);
    }
}

