/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.client.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import it.zerono.mods.zerocore.internal.Log;
import it.zerono.mods.zerocore.lib.client.model.BlockVariantsModel;
import it.zerono.mods.zerocore.lib.client.model.ICustomModelBuilder;
import it.zerono.mods.zerocore.lib.client.render.ModRenderHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.ModelLoader;

public class BlockVariantsModelBuilder
implements ICustomModelBuilder {
    private final boolean _ambientOcclusion;
    private final boolean _guid3D;
    private final boolean _builtInRenderer;
    private final Map<Integer, ResourceLocation> _modelToBeReplaced;
    private final Map<Integer, List<ResourceLocation>> _modelsToBeLoaded;
    private final Map<Integer, List<ResourceLocation>> _variants;
    private final Map<Integer, Integer> _particleVariantIndex;
    private final Map<Integer, Boolean> _hasGeneralQuads;

    public BlockVariantsModelBuilder(boolean ambientOcclusion, boolean guid3D, boolean builtInRenderer) {
        this._ambientOcclusion = ambientOcclusion;
        this._guid3D = guid3D;
        this._builtInRenderer = builtInRenderer;
        this._modelToBeReplaced = Maps.newHashMap();
        this._modelsToBeLoaded = Maps.newHashMap();
        this._variants = Maps.newHashMap();
        this._particleVariantIndex = Maps.newHashMap();
        this._hasGeneralQuads = Maps.newHashMap();
    }

    public void addBlock(int id, ResourceLocation modelToReplace) {
        this.addBlock(id, modelToReplace, 0, false);
    }

    public void addBlock(int id, ResourceLocation modelToReplace, int particleVariantIndex) {
        this.addBlock(id, modelToReplace, particleVariantIndex, false);
    }

    public void addBlock(int id, ResourceLocation modelToReplace, int particleVariantIndex, boolean hasGeneralQuads) {
        this._modelToBeReplaced.put(id, modelToReplace);
        this._hasGeneralQuads.put(id, hasGeneralQuads);
        this._particleVariantIndex.put(id, particleVariantIndex);
    }

    public void addModels(int blockId, ResourceLocation ... models) {
        Collections.addAll(this._modelsToBeLoaded.computeIfAbsent(blockId, id -> Lists.newArrayListWithCapacity((int)models.length)), models);
        Collections.addAll(this._variants.computeIfAbsent(blockId, id -> Lists.newArrayListWithCapacity((int)models.length)), models);
    }

    public void addModels(int blockId, List<ResourceLocation> models) {
        this._modelsToBeLoaded.computeIfAbsent(blockId, id -> Lists.newArrayListWithCapacity((int)models.size())).addAll(models);
        this._variants.computeIfAbsent(blockId, id -> Lists.newArrayListWithCapacity((int)models.size())).addAll(models);
    }

    public void addVariant(int blockId, ResourceLocation model) {
        this._variants.computeIfAbsent(blockId, id -> Lists.newArrayListWithCapacity((int)8)).add(model);
    }

    public void loadModel(int blockId, ResourceLocation model) {
        if (!(model instanceof ModelResourceLocation)) {
            this._modelsToBeLoaded.computeIfAbsent(blockId, id -> Lists.newArrayListWithCapacity((int)8)).add(model);
        }
    }

    protected BlockVariantsModel createReplacementModel(int blockCount, boolean ambientOcclusion, boolean guid3D, boolean builtInRenderer) {
        return new BlockVariantsModel(blockCount, ambientOcclusion, guid3D, builtInRenderer);
    }

    @Override
    public void onRegisterModels() {
        this._modelsToBeLoaded.values().stream().filter(list -> list.size() > 1).flatMap(Collection::stream).filter(resourceLocation -> !(resourceLocation instanceof ModelResourceLocation)).forEach(ModelLoader::addSpecialModel);
    }

    @Override
    public void onBakeModels(ModelBakeEvent event) {
        Map modelRegistry = event.getModelRegistry();
        Set<Integer> ids = this._modelToBeReplaced.keySet();
        BlockVariantsModel model = this.createReplacementModel(ids.size(), this._ambientOcclusion, this._guid3D, this._builtInRenderer);
        for (int id : ids) {
            List<IBakedModel> variants = this._variants.getOrDefault(id, Collections.emptyList()).stream().map(location -> BlockVariantsModelBuilder.lookupModel(modelRegistry, location)).collect(Collectors.toList());
            model.addBlock(id, (boolean)this._hasGeneralQuads.get(id), variants);
            modelRegistry.put(this._modelToBeReplaced.get(id), model);
        }
    }

    private static IBakedModel lookupModel(Map<ResourceLocation, IBakedModel> modelRegistry, ResourceLocation location) {
        if (modelRegistry.containsKey(location)) {
            return modelRegistry.get(location);
        }
        Log.LOGGER.warn(Log.MULTIBLOCK, "Unable to find a backed model for {}", (Object)location);
        return ModRenderHelper.getMissingModel();
    }
}

