/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.client.render.builder;

import it.zerono.mods.zerocore.lib.client.gui.sprite.ISprite;
import it.zerono.mods.zerocore.lib.client.render.Shape;
import it.zerono.mods.zerocore.lib.client.render.builder.IPrimitiveBuilder;
import it.zerono.mods.zerocore.lib.client.render.builder.VertexElementType;
import it.zerono.mods.zerocore.lib.data.geometry.Vector3d;
import it.zerono.mods.zerocore.lib.data.gfx.Colour;
import it.zerono.mods.zerocore.lib.data.gfx.LightMap;
import it.zerono.mods.zerocore.lib.data.gfx.UV;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class AbstractShapeBuilder
implements IPrimitiveBuilder<Shape> {
    private final boolean _autoReset;

    protected AbstractShapeBuilder(boolean autoReset) {
        this._autoReset = autoReset;
    }

    protected boolean autoReset() {
        return this._autoReset;
    }

    protected static class PolygonalFaceData {
        public final int VERTICES_COUNT;
        public final Vector3d[] NORMALS;
        public final UV[] UV_MAP;
        public final Colour[] COLOURS;
        public final LightMap[] LIGHT_MAPS;
        public final LightMap[] OVERLAY_MAPS;
        private final EnumSet<VertexElementType> _filledElements;

        public PolygonalFaceData(int vertexCount) {
            this.VERTICES_COUNT = vertexCount;
            this.NORMALS = new Vector3d[vertexCount];
            this.UV_MAP = new UV[vertexCount];
            this.COLOURS = new Colour[vertexCount];
            this.LIGHT_MAPS = new LightMap[vertexCount];
            this.OVERLAY_MAPS = new LightMap[vertexCount];
            this._filledElements = EnumSet.noneOf(VertexElementType.class);
        }

        public void reset() {
            this._filledElements.clear();
            for (int idx = 0; idx < this.VERTICES_COUNT; ++idx) {
                this.NORMALS[idx] = null;
                this.UV_MAP[idx] = null;
                this.COLOURS[idx] = null;
                this.LIGHT_MAPS[idx] = null;
                this.OVERLAY_MAPS[idx] = null;
            }
        }

        public Optional<Vector3d> getNormalAt(int vertexIndex) {
            return this.checkElement(VertexElementType.Normal) ? Optional.ofNullable(this.NORMALS[vertexIndex]) : Optional.empty();
        }

        public Optional<UV> getUvAt(int vertexIndex) {
            return this.checkElement(VertexElementType.Texture) ? Optional.ofNullable(this.UV_MAP[vertexIndex]) : Optional.empty();
        }

        public Optional<Colour> getColourlAt(int vertexIndex) {
            return this.checkElement(VertexElementType.Colour) ? Optional.ofNullable(this.COLOURS[vertexIndex]) : Optional.empty();
        }

        public Optional<LightMap> getLightMapAt(int vertexIndex) {
            return this.checkElement(VertexElementType.LightMap) ? Optional.ofNullable(this.LIGHT_MAPS[vertexIndex]) : Optional.empty();
        }

        public Optional<LightMap> getOverlayMapAt(int vertexIndex) {
            return this.checkElement(VertexElementType.OverlayMap) ? Optional.ofNullable(this.OVERLAY_MAPS[vertexIndex]) : Optional.empty();
        }

        public PolygonalFaceData setNormal(Vector3d normal) {
            Arrays.fill(this.NORMALS, normal);
            this.addElement(VertexElementType.Normal);
            return this;
        }

        public PolygonalFaceData setNormal(int vertexIndex, Vector3d normal) {
            this.NORMALS[vertexIndex] = normal;
            this.addElement(VertexElementType.Normal);
            return this;
        }

        public PolygonalFaceData setTexture(UV texture) {
            Arrays.fill(this.UV_MAP, texture);
            this.addElement(VertexElementType.Texture);
            return this;
        }

        public PolygonalFaceData setTexture(float u, float v) {
            return this.setTexture(new UV(u, v));
        }

        public PolygonalFaceData setTexture(int vertexIndex, UV texture) {
            this.UV_MAP[vertexIndex] = texture;
            this.addElement(VertexElementType.Texture);
            return this;
        }

        public PolygonalFaceData setTexture(int vertexIndex, float u, float v) {
            return this.setTexture(vertexIndex, new UV(u, v));
        }

        public PolygonalFaceData setTexture(TextureAtlasSprite sprite) {
            if (4 != this.VERTICES_COUNT) {
                throw new IllegalArgumentException("This polygonal face does not have 4 vertices");
            }
            this.setTexture(0, sprite.func_94209_e(), sprite.func_94206_g());
            this.setTexture(1, sprite.func_94209_e(), sprite.func_94210_h());
            this.setTexture(2, sprite.func_94212_f(), sprite.func_94210_h());
            this.setTexture(3, sprite.func_94212_f(), sprite.func_94206_g());
            return this;
        }

        public PolygonalFaceData setTexture(ISprite sprite) {
            if (4 != this.VERTICES_COUNT) {
                throw new IllegalArgumentException("This polygonal face does not have 4 vertices");
            }
            this.setTexture(0, sprite.getMinU(), sprite.getMinV());
            this.setTexture(1, sprite.getMinU(), sprite.getMaxV());
            this.setTexture(2, sprite.getMaxU(), sprite.getMaxV());
            this.setTexture(3, sprite.getMaxU(), sprite.getMinV());
            return this;
        }

        public PolygonalFaceData setTexture(Supplier<ISprite> sprite) {
            return this.setTexture(sprite.get());
        }

        public PolygonalFaceData setColour(Colour colour) {
            Arrays.fill(this.COLOURS, colour);
            this.addElement(VertexElementType.Colour);
            return this;
        }

        public PolygonalFaceData setColour(int vertexIndex, Colour colour) {
            this.COLOURS[vertexIndex] = colour;
            this.addElement(VertexElementType.Colour);
            return this;
        }

        public PolygonalFaceData setLightMap(LightMap map) {
            Arrays.fill(this.LIGHT_MAPS, map);
            this.addElement(VertexElementType.LightMap);
            return this;
        }

        public PolygonalFaceData setLightMapCombined(int combined) {
            return this.setLightMap(new LightMap(combined));
        }

        public PolygonalFaceData setLightMap(int vertexIndex, LightMap map) {
            this.LIGHT_MAPS[vertexIndex] = map;
            this.addElement(VertexElementType.LightMap);
            return this;
        }

        public PolygonalFaceData setLightMapCombined(int vertexIndex, int combined) {
            return this.setLightMap(vertexIndex, new LightMap(combined));
        }

        public PolygonalFaceData setOverlayMap(LightMap map) {
            Arrays.fill(this.OVERLAY_MAPS, map);
            this.addElement(VertexElementType.OverlayMap);
            return this;
        }

        public PolygonalFaceData setOverlayMapCombined(int combined) {
            return this.setOverlayMap(new LightMap(combined));
        }

        public PolygonalFaceData setOverlayMap(int vertexIndex, LightMap map) {
            this.OVERLAY_MAPS[vertexIndex] = map;
            this.addElement(VertexElementType.OverlayMap);
            return this;
        }

        public PolygonalFaceData setOverlayMapCombined(int vertexIndex, int combined) {
            return this.setOverlayMap(vertexIndex, new LightMap(combined));
        }

        protected boolean checkElement(VertexElementType element) {
            return this._filledElements.contains((Object)element);
        }

        protected void addElement(VertexElementType element) {
            this._filledElements.add(element);
        }
    }
}

