/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.client.render.builder;

import it.zerono.mods.zerocore.lib.client.gui.sprite.ISprite;
import it.zerono.mods.zerocore.lib.client.render.Shape;
import it.zerono.mods.zerocore.lib.client.render.Vertex;
import it.zerono.mods.zerocore.lib.client.render.builder.AbstractShapeBuilder;
import it.zerono.mods.zerocore.lib.client.render.builder.VertexBuilder;
import it.zerono.mods.zerocore.lib.data.geometry.Cuboid;
import it.zerono.mods.zerocore.lib.data.gfx.Colour;
import it.zerono.mods.zerocore.lib.data.gfx.LightMap;
import it.zerono.mods.zerocore.lib.data.gfx.UV;
import java.util.function.Supplier;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class QuadBuilder
extends AbstractShapeBuilder {
    public static final int VERTICES_COUNT = 4;
    private final AbstractShapeBuilder.PolygonalFaceData _faceData = new AbstractShapeBuilder.PolygonalFaceData(4);
    private Cuboid.Face _face;
    private static QuadBuilder s_defaultBuilder = null;

    public static QuadBuilder getDefaultBuilder() {
        if (null == s_defaultBuilder) {
            s_defaultBuilder = new QuadBuilder(false);
        }
        return s_defaultBuilder;
    }

    public QuadBuilder(boolean autoReset) {
        super(autoReset);
    }

    @Override
    public Shape build() {
        if (null == this._face) {
            throw new IllegalStateException("No face was provided!");
        }
        Shape shape = new Shape(4);
        VertexBuilder vertexBuilder = new VertexBuilder(true);
        for (int vertexIndex = 3; vertexIndex >= 0; --vertexIndex) {
            shape.addVertex(QuadBuilder.buildSingleVertex(vertexIndex, vertexIndex, vertexBuilder, this._face, this._faceData));
        }
        if (this.autoReset()) {
            this.reset();
        }
        return shape;
    }

    @Override
    public void reset() {
        this._face = null;
        this._faceData.reset();
    }

    public QuadBuilder setFace(Cuboid.Face face) {
        this._face = face;
        return this;
    }

    public QuadBuilder setFace(Cuboid cuboid, Direction facing) {
        return this.setFace(cuboid.getFace(facing));
    }

    public QuadBuilder setColour(Colour colour) {
        this._faceData.setColour(colour);
        return this;
    }

    public QuadBuilder setColour(int vertexIndex, Colour colour) {
        this._faceData.setColour(vertexIndex, colour);
        return this;
    }

    public QuadBuilder setTexture(UV a, UV b, UV c, UV d) {
        this._faceData.setTexture(0, a);
        this._faceData.setTexture(1, b);
        this._faceData.setTexture(2, c);
        this._faceData.setTexture(3, d);
        return this;
    }

    public QuadBuilder setTexture(int vertexIndex, UV uv) {
        this._faceData.setTexture(vertexIndex, uv);
        return this;
    }

    public QuadBuilder setTexture(int vertexIndex, float u, float v) {
        return this.setTexture(vertexIndex, new UV(u, v));
    }

    public QuadBuilder setTexture(TextureAtlasSprite sprite) {
        this._faceData.setTexture(sprite);
        return this;
    }

    public QuadBuilder setTexture(ISprite sprite) {
        this._faceData.setTexture(sprite);
        return this;
    }

    public QuadBuilder setTexture(Supplier<ISprite> sprite) {
        this._faceData.setTexture(sprite);
        return this;
    }

    public QuadBuilder setLightMap(LightMap map) {
        this._faceData.setLightMap(map);
        return this;
    }

    public QuadBuilder setLightMap(int vertexIndex, LightMap map) {
        this._faceData.setLightMap(vertexIndex, map);
        return this;
    }

    public QuadBuilder setLightMap(int sky, int block) {
        return this.setLightMap(new LightMap(sky, block));
    }

    public QuadBuilder setLightMap(int vertexIndex, int sky, int block) {
        return this.setLightMap(vertexIndex, new LightMap(sky, block));
    }

    public QuadBuilder setLightMapCombined(int combined) {
        return this.setLightMap(new LightMap(combined));
    }

    public QuadBuilder setLightMapCombined(int vertexIndex, int combined) {
        return this.setLightMap(vertexIndex, new LightMap(combined));
    }

    public QuadBuilder setOverlayMap(LightMap map) {
        this._faceData.setOverlayMap(map);
        return this;
    }

    public QuadBuilder setOverlayMap(int vertexIndex, LightMap map) {
        this._faceData.setOverlayMap(vertexIndex, map);
        return this;
    }

    public QuadBuilder setOverlayMap(int sky, int block) {
        return this.setOverlayMap(new LightMap(sky, block));
    }

    public QuadBuilder setOverlayMapCombined(int combined) {
        return this.setOverlayMap(new LightMap(combined));
    }

    public QuadBuilder setOverlayMap(int vertexIndex, int sky, int block) {
        return this.setOverlayMap(vertexIndex, new LightMap(sky, block));
    }

    public QuadBuilder setOverlayMapCombined(int vertexIndex, int combined) {
        return this.setOverlayMap(vertexIndex, new LightMap(combined));
    }

    static Vertex buildSingleVertex(int vidx, int vertexIndex, VertexBuilder vertexBuilder, Cuboid.Face face, AbstractShapeBuilder.PolygonalFaceData faceData) {
        vertexBuilder.setIdx(vidx);
        vertexBuilder.setPosition(face.getVertexByIndex(vertexIndex));
        faceData.getUvAt(vertexIndex).ifPresent(vertexBuilder::setTexture);
        faceData.getColourlAt(vertexIndex).ifPresent(vertexBuilder::setColour);
        faceData.getLightMapAt(vertexIndex).ifPresent(vertexBuilder::setLightMap);
        faceData.getOverlayMapAt(vertexIndex).ifPresent(vertexBuilder::setOverlayMap);
        vertexBuilder.setNormal(face.getNormal());
        return vertexBuilder.build();
    }
}

