/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.data.geometry;

import it.zerono.mods.zerocore.lib.data.geometry.Vector3d;
import net.minecraft.util.math.vector.Vector3i;

public class BoundingSphere {
    private final Vector3d _center;
    private final double _radius;

    public static BoundingSphere of(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        Vector3d center = new Vector3d((minX + maxX) / 2.0, (minY + maxY) / 2.0, (minZ + maxZ) / 2.0);
        double radius = Math.sqrt((maxX - center.X) * (maxX - center.X) + (maxY - center.Y) * (maxY - center.Y) + (maxZ - center.Z) * (maxZ - center.Z));
        return new BoundingSphere(center, radius);
    }

    public static BoundingSphere of(Vector3d min, Vector3d max) {
        return BoundingSphere.of(min.X, min.Y, min.Z, max.X, max.Y, max.Z);
    }

    public static BoundingSphere of(Vector3i min, Vector3i max) {
        return BoundingSphere.of(min.func_177958_n(), min.func_177956_o(), min.func_177952_p(), max.func_177958_n(), max.func_177956_o(), max.func_177952_p());
    }

    public Vector3d getCenter() {
        return this._center;
    }

    public double getRadius() {
        return this._radius;
    }

    public String toString() {
        return String.format("%s  r%f", this.getCenter(), this.getRadius());
    }

    protected BoundingSphere(Vector3d center, double radius) {
        this._center = center;
        this._radius = radius;
    }
}

