/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.data.geometry;

import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.math.vector.Vector4f;

public class Vector3d
implements IPosition {
    public static final Vector3d ZERO = new Vector3d();
    public static final Vector3d HALF = new Vector3d(0.5, 0.5, 0.5);
    public static final Vector3d XN = new Vector3d(-1.0, 0.0, 0.0);
    public static final Vector3d XP = new Vector3d(1.0, 0.0, 0.0);
    public static final Vector3d YN = new Vector3d(0.0, -1.0, 0.0);
    public static final Vector3d YP = new Vector3d(0.0, 1.0, 0.0);
    public static final Vector3d ZN = new Vector3d(0.0, 0.0, -1.0);
    public static final Vector3d ZP = new Vector3d(0.0, 0.0, 1.0);
    public final double X;
    public final double Y;
    public final double Z;

    public Vector3d(double x, double y, double z) {
        this.X = x;
        this.Y = y;
        this.Z = z;
    }

    public Vector3d(Vector3d other) {
        this(other.X, other.Y, other.Z);
    }

    public Vector3d(Vector3i other) {
        this(other.func_177958_n(), other.func_177956_o(), other.func_177952_p());
    }

    public static Vector3d from(Vector3i data) {
        return new Vector3d(data.func_177958_n(), data.func_177956_o(), data.func_177952_p());
    }

    public static Vector3d from(Vector3f data) {
        return new Vector3d(data.func_195899_a(), data.func_195900_b(), data.func_195902_c());
    }

    public static Vector3d from(Vector4f data) {
        return new Vector3d(data.func_195910_a(), data.func_195913_b(), data.func_195914_c());
    }

    public static Vector3d fromCenter(Vector3i data) {
        return new Vector3d((double)data.func_177958_n() + 0.5, (double)data.func_177956_o() + 0.5, (double)data.func_177952_p() + 0.5);
    }

    public static Vector3d from(Entity data) {
        return new Vector3d(data.func_226277_ct_(), data.func_226278_cu_(), data.func_226281_cx_());
    }

    public static Vector3d fromCenter(Entity data) {
        return new Vector3d(data.func_226277_ct_() + 0.5, data.func_226278_cu_() + 0.5, data.func_226281_cx_() + 0.5);
    }

    public static Vector3d from(TileEntity data) {
        return Vector3d.from((Vector3i)data.func_174877_v());
    }

    public static Vector3d fromCenter(TileEntity data) {
        return Vector3d.fromCenter((Vector3i)data.func_174877_v());
    }

    public static Vector3d syncDataFrom(CompoundNBT data) {
        return new Vector3d(data.func_74769_h("vx"), data.func_74769_h("vy"), data.func_74769_h("vz"));
    }

    public CompoundNBT syncDataTo(CompoundNBT data) {
        data.func_74780_a("vx", this.X);
        data.func_74780_a("vy", this.Y);
        data.func_74780_a("vz", this.Z);
        return data;
    }

    public Vector3i toVec3i() {
        return new Vector3i(this.X, this.Y, this.Z);
    }

    public BlockPos toBlockPos() {
        return new BlockPos(this.X, this.Y, this.Z);
    }

    public Vector3d add(double offsetX, double offsetY, double offsetZ) {
        return new Vector3d(this.X + offsetX, this.Y + offsetY, this.Z + offsetZ);
    }

    public Vector3d add(double offset) {
        return this.add(offset, offset, offset);
    }

    public Vector3d add(Vector3d v) {
        return this.add(v.X, v.Y, v.Z);
    }

    public Vector3d add(Vector3i v) {
        return this.add(v.func_177958_n(), v.func_177956_o(), v.func_177952_p());
    }

    public Vector3d subtract(double offsetX, double offsetY, double offsetZ) {
        return this.add(-offsetX, -offsetY, -offsetZ);
    }

    public Vector3d subtract(double offset) {
        return this.subtract(offset, offset, offset);
    }

    public Vector3d subtract(Vector3i v) {
        return this.subtract(v.func_177958_n(), v.func_177956_o(), v.func_177952_p());
    }

    public Vector3d subtract(Vector3d v) {
        return this.subtract(v.X, v.Y, v.Z);
    }

    public Vector3d multiply(double factorX, double factorY, double factorZ) {
        return new Vector3d(this.X * factorX, this.Y * factorY, this.Z * factorZ);
    }

    public Vector3d multiply(double factor) {
        return this.multiply(factor, factor, factor);
    }

    public Vector3d multiply(Vector3i factor) {
        return this.multiply(factor.func_177958_n(), factor.func_177956_o(), factor.func_177952_p());
    }

    public Vector3d multiply(Vector3d v) {
        return this.multiply(v.func_82615_a(), v.func_82617_b(), v.func_82616_c());
    }

    public Vector3d divide(double factorX, double factorY, double factorZ) {
        return new Vector3d(this.X / factorX, this.Y / factorY, this.Z / factorZ);
    }

    public Vector3d divide(double factor) {
        return this.divide(factor, factor, factor);
    }

    public Vector3d divide(Vector3i factor) {
        return this.divide(factor.func_177958_n(), factor.func_177956_o(), factor.func_177952_p());
    }

    public Vector3d ceil() {
        return new Vector3d(MathHelper.func_76143_f((double)this.X), MathHelper.func_76143_f((double)this.Y), MathHelper.func_76143_f((double)this.Z));
    }

    public Vector3d floor() {
        return new Vector3d(MathHelper.func_76128_c((double)this.X), MathHelper.func_76128_c((double)this.Y), MathHelper.func_76128_c((double)this.Z));
    }

    public Vector3d crossProduct(Vector3d vec) {
        return new Vector3d(this.Y * vec.Z - this.Z * vec.Y, this.Z * vec.X - this.X * vec.Z, this.X * vec.Y - this.Y * vec.X);
    }

    public double magnitude() {
        return Math.sqrt(this.X * this.X + this.Y * this.Y + this.Z * this.Z);
    }

    public Vector3d normalize() {
        double magnitude = this.magnitude();
        if (0.0 != magnitude) {
            return this.multiply(1.0 / magnitude);
        }
        return this;
    }

    public double scalarProduct(double x, double y, double z) {
        return this.X * x + this.Y * y + this.Z * z;
    }

    public double scalarProduct(Vector3d vector) {
        double product = this.X * vector.X + this.Y * vector.Y + this.Z * vector.Z;
        if (product > 1.0 && product < 1.00001) {
            product = 1.0;
        } else if (product < -1.0 && product > -1.00001) {
            product = -1.0;
        }
        return product;
    }

    public double func_82615_a() {
        return this.X;
    }

    public double func_82617_b() {
        return this.Y;
    }

    public double func_82616_c() {
        return this.Z;
    }

    public boolean equals(Object other) {
        if (other instanceof Vector3d) {
            Vector3d v = (Vector3d)other;
            return this.X == v.X && this.Y == v.Y && this.Z == v.Z;
        }
        return false;
    }

    public String toString() {
        return String.format("Vector3d (%f, %f, %f)", this.X, this.Y, this.Z);
    }

    private Vector3d() {
        this.Z = 0.0;
        this.Y = 0.0;
        this.X = 0.0;
    }
}

