/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.data.stack;

import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.data.stack.IStackHolder;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.ObjIntConsumer;

public abstract class AbstractStackHolder<Holder extends AbstractStackHolder<Holder, Stack>, Stack>
implements IStackHolder<Holder, Stack> {
    private final BiPredicate<Integer, Stack> _stackValidator;
    private ObjIntConsumer<IStackHolder.ChangeType> _onChangeListener;
    private Runnable _onLoadListener;

    protected AbstractStackHolder() {
        this(AbstractStackHolder::defaultValidator);
    }

    protected AbstractStackHolder(BiPredicate<Integer, Stack> stackValidator) {
        this._stackValidator = Objects.requireNonNull(stackValidator);
        this._onChangeListener = (change, index) -> {};
        this._onLoadListener = CodeHelper.VOID_RUNNABLE;
    }

    protected void onLoad() {
        this._onLoadListener.run();
    }

    protected void onChange(IStackHolder.ChangeType change, int index) {
        this._onChangeListener.accept(change, index);
    }

    @Override
    public boolean isStackValid(int index, Stack stack) {
        return this._stackValidator.test(index, stack);
    }

    @Override
    public Holder setOnContentsChangedListener(ObjIntConsumer<IStackHolder.ChangeType> listener) {
        this._onChangeListener = Objects.requireNonNull(listener);
        return (Holder)this;
    }

    @Override
    public Holder setOnLoadListener(Runnable listener) {
        this._onLoadListener = Objects.requireNonNull(listener);
        return (Holder)this;
    }

    protected static <Stack> boolean defaultValidator(Integer index, Stack stack) {
        return true;
    }
}

