/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.energy.adapter;

import it.zerono.mods.zerocore.lib.energy.EnergySystem;
import it.zerono.mods.zerocore.lib.energy.IWideEnergyProvider;
import it.zerono.mods.zerocore.lib.energy.IWideEnergyReceiver;
import it.zerono.mods.zerocore.lib.energy.IWideEnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;

public final class ForgeEnergyAdapter {
    public static IEnergyStorage wrap(final IWideEnergyReceiver receiver) {
        return new IEnergyStorage(){

            public int receiveEnergy(int maxReceive, boolean simulate) {
                return (int)receiver.receiveEnergy(EnergySystem.ForgeEnergy, null, maxReceive, simulate);
            }

            public int extractEnergy(int maxExtract, boolean simulate) {
                return 0;
            }

            public int getEnergyStored() {
                return (int)receiver.getEnergyStored(EnergySystem.ForgeEnergy, null);
            }

            public int getMaxEnergyStored() {
                return (int)receiver.getCapacity(EnergySystem.ForgeEnergy, null);
            }

            public boolean canExtract() {
                return false;
            }

            public boolean canReceive() {
                return true;
            }
        };
    }

    public static IEnergyStorage wrap(final IWideEnergyProvider provider) {
        return new IEnergyStorage(){

            public int receiveEnergy(int maxReceive, boolean simulate) {
                return 0;
            }

            public int extractEnergy(int maxExtract, boolean simulate) {
                return (int)provider.extractEnergy(EnergySystem.ForgeEnergy, null, maxExtract, simulate);
            }

            public int getEnergyStored() {
                return (int)provider.getEnergyStored(EnergySystem.ForgeEnergy, null);
            }

            public int getMaxEnergyStored() {
                return (int)provider.getCapacity(EnergySystem.ForgeEnergy, null);
            }

            public boolean canExtract() {
                return true;
            }

            public boolean canReceive() {
                return false;
            }
        };
    }

    public static IEnergyStorage wrap(final IWideEnergyStorage storage) {
        return new IEnergyStorage(){

            public int receiveEnergy(int maxReceive, boolean simulate) {
                return (int)storage.insertEnergy(EnergySystem.ForgeEnergy, maxReceive, simulate);
            }

            public int extractEnergy(int maxExtract, boolean simulate) {
                return (int)storage.extractEnergy(EnergySystem.ForgeEnergy, maxExtract, simulate);
            }

            public int getEnergyStored() {
                return (int)storage.getEnergyStored(EnergySystem.ForgeEnergy);
            }

            public int getMaxEnergyStored() {
                return (int)storage.getCapacity(EnergySystem.ForgeEnergy);
            }

            public boolean canExtract() {
                return storage.canExtract();
            }

            public boolean canReceive() {
                return storage.canInsert();
            }
        };
    }

    private ForgeEnergyAdapter() {
    }
}

