/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.item.inventory;

import it.zerono.mods.zerocore.lib.data.stack.OperationMode;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;

public interface IInventorySlot {
    public int getIndex();

    public ItemStack getStackInSlot();

    public void setStackInSlot(ItemStack var1);

    default public void setToEmpty() {
        this.setStackInSlot(ItemStack.field_190927_a);
    }

    default public boolean isSlotEmpty() {
        return this.getStackInSlot().func_190926_b();
    }

    default public int getStackSize() {
        return this.getStackInSlot().func_190916_E();
    }

    default public int setStackSize(int amount, OperationMode mode) {
        if (this.isSlotEmpty()) {
            return 0;
        }
        if (amount <= 0) {
            if (mode.execute()) {
                this.setToEmpty();
            }
            return 0;
        }
        ItemStack stack = this.getStackInSlot();
        int maxStackSize = this.getSlotLimit(stack);
        if (amount > maxStackSize) {
            amount = maxStackSize;
        }
        if (stack.func_190916_E() == amount || mode.simulate()) {
            return amount;
        }
        ItemStack newStack = stack.func_77946_l();
        newStack.func_190920_e(amount);
        this.setStackInSlot(newStack);
        return amount;
    }

    default public int increaseStackSize(int amount, OperationMode mode) {
        if (amount > 0) {
            amount = Math.min(amount, this.getSlotLimit(this.getStackInSlot()));
        }
        int currentSize = this.getStackSize();
        return this.setStackSize(currentSize + amount, mode) - currentSize;
    }

    default public int decreaseStackSize(int amount, OperationMode mode) {
        return -this.increaseStackSize(-amount, mode);
    }

    default public ItemStack insertStack(ItemStack stack, OperationMode mode) {
        if (stack.func_190926_b() || this.canInsertStack(stack)) {
            return stack;
        }
        int needed = this.getSlotLimit(stack) - this.getStackSize();
        if (needed <= 0) {
            return stack;
        }
        boolean typeMatch = false;
        if (this.isSlotEmpty() || (typeMatch = ItemHandlerHelper.canItemStacksStack((ItemStack)this.getStackInSlot(), (ItemStack)stack))) {
            int toAdd = Math.min(stack.func_190916_E(), needed);
            if (mode.execute()) {
                if (typeMatch) {
                    this.increaseStackSize(toAdd, mode);
                } else {
                    ItemStack toSet = stack.func_77946_l();
                    toSet.func_190920_e(toAdd);
                    this.setStackInSlot(toSet);
                }
            }
            ItemStack remainder = stack.func_77946_l();
            remainder.func_190920_e(stack.func_190916_E() - toAdd);
            return remainder;
        }
        return stack;
    }

    default public ItemStack extractStack(int amount, OperationMode mode) {
        if (this.isSlotEmpty() || amount < 1) {
            return ItemStack.field_190927_a;
        }
        ItemStack current = this.getStackInSlot();
        int currentAmount = Math.min(this.getStackSize(), current.func_77976_d());
        if (currentAmount < amount) {
            amount = currentAmount;
        }
        ItemStack result = current.func_77946_l();
        result.func_190920_e(amount);
        if (mode.execute()) {
            this.decreaseStackSize(amount, mode);
        }
        return result;
    }

    public boolean canInsertStack(ItemStack var1);

    public boolean canExtractStack(int var1);

    public int getSlotLimit(ItemStack var1);

    default public int getSlotFreeSpace(ItemStack stack) {
        return this.isSlotEmpty() ? this.getSlotLimit(stack) : this.getSlotLimit(stack) - this.getStackInSlot().func_190916_E();
    }
}

