/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.item.inventory.handler;

import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.DebuggableHelper;
import it.zerono.mods.zerocore.lib.IDebugMessages;
import it.zerono.mods.zerocore.lib.IDebuggable;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.IntConsumer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityItemStackHandler
extends ItemStackHandler
implements IDebuggable {
    private final TileEntity _linkedTE;
    private final BiPredicate<Integer, ItemStack> _itemValidator;
    private IntConsumer _slotChanged;

    public TileEntityItemStackHandler(TileEntity linkedTileEntity) {
        this(linkedTileEntity, 1);
    }

    public TileEntityItemStackHandler(TileEntity linkedTileEntity, int size) {
        this(linkedTileEntity, size, TileEntityItemStackHandler::defaultValidator);
    }

    public TileEntityItemStackHandler(TileEntity linkedTileEntity, int size, BiPredicate<Integer, ItemStack> itemValidator) {
        super(size);
        this._linkedTE = linkedTileEntity;
        this._itemValidator = itemValidator;
        this._slotChanged = CodeHelper.VOID_INT_CONSUMER;
    }

    public TileEntityItemStackHandler(TileEntity linkedTileEntity, NonNullList<ItemStack> stacks) {
        this(linkedTileEntity, stacks, TileEntityItemStackHandler::defaultValidator);
    }

    public TileEntityItemStackHandler(TileEntity linkedTileEntity, NonNullList<ItemStack> stacks, BiPredicate<Integer, ItemStack> itemValidator) {
        super(stacks);
        this._linkedTE = linkedTileEntity;
        this._itemValidator = itemValidator;
        this._slotChanged = CodeHelper.VOID_INT_CONSUMER;
    }

    public TileEntityItemStackHandler setContentsChangedListener(IntConsumer listener) {
        this._slotChanged = Objects.requireNonNull(listener);
        return this;
    }

    @Override
    public void getDebugMessages(LogicalSide side, IDebugMessages messages) {
        DebuggableHelper.getDebugMessagesFor(messages, (IItemHandler)this);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return this._itemValidator.test(slot, stack);
    }

    protected void onContentsChanged(int slot) {
        this._linkedTE.func_70296_d();
        this._slotChanged.accept(slot);
    }

    private static boolean defaultValidator(Integer slot, ItemStack stack) {
        return true;
    }
}

