/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.network;

import it.zerono.mods.zerocore.lib.network.IModMessage;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public class NetworkHandler {
    private final String _protocolVersion;
    private final SimpleChannel _channel;
    private int _nextIndex = 0;

    public NetworkHandler(ResourceLocation channelName, String protocolVersion) {
        this._protocolVersion = protocolVersion;
        this._channel = NetworkRegistry.ChannelBuilder.named((ResourceLocation)channelName).clientAcceptedVersions(this._protocolVersion::equals).serverAcceptedVersions(this._protocolVersion::equals).networkProtocolVersion(() -> this._protocolVersion).simpleChannel();
    }

    public <T extends IModMessage> void registerMessage(Class<T> messageType, Function<PacketBuffer, T> messageFactory) {
        this._channel.registerMessage(this._nextIndex++, messageType, IModMessage::encodeTo, messageFactory, NetworkHandler::handleMessage);
    }

    public <T extends IModMessage> void sendToServer(T message) {
        this._channel.sendToServer(message);
    }

    public <T extends IModMessage> void sendToPlayer(T message, ServerPlayerEntity player) {
        if (!(player instanceof FakePlayer)) {
            this._channel.sendTo(message, player.field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    public <T extends IModMessage> void sendReply(T message, NetworkEvent.Context originalContext) {
        this._channel.reply(message, originalContext);
    }

    public <T extends IModMessage> void sendTo(T message, PacketDistributor.PacketTarget target) {
        this._channel.send(target, message);
    }

    public <T extends IModMessage> void sendToAllAround(T message, Supplier<PacketDistributor.TargetPoint> targetSupplier) {
        this.sendTo(message, PacketDistributor.NEAR.with(targetSupplier));
    }

    public <T extends IModMessage> void sendToAllAround(T message, double x, double y, double z, double radius, RegistryKey<World> dimension) {
        this.sendToAllAround(message, PacketDistributor.TargetPoint.p((double)x, (double)y, (double)z, (double)radius, dimension));
    }

    public <T extends IModMessage> void sendToAllAround(T message, BlockPos center, double radius, RegistryKey<World> dimension) {
        this.sendToAllAround(message, PacketDistributor.TargetPoint.p((double)center.func_177958_n(), (double)center.func_177956_o(), (double)center.func_177952_p(), (double)radius, dimension));
    }

    public <T extends IModMessage> void sendToDimension(T message, RegistryKey<World> dimension) {
        this.sendTo(message, PacketDistributor.DIMENSION.with(() -> dimension));
    }

    public <T extends IModMessage> void sendToAllPlayers(T message) {
        this.sendTo(message, PacketDistributor.ALL.noArg());
    }

    private static <T extends IModMessage> void handleMessage(T message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context messageContext = contextSupplier.get();
        messageContext.enqueueWork(() -> message.processMessage(messageContext));
        messageContext.setPacketHandled(true);
    }
}

