/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.recipe.ingredient;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import it.zerono.mods.zerocore.lib.data.json.JSONHelper;
import it.zerono.mods.zerocore.lib.fluid.FluidHelper;
import it.zerono.mods.zerocore.lib.recipe.ingredient.IRecipeIngredient;
import it.zerono.mods.zerocore.lib.tag.TagsHelper;
import java.util.List;
import java.util.Objects;
import net.minecraft.fluid.Fluid;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public abstract class FluidStackRecipeIngredient
implements IRecipeIngredient<FluidStack> {
    public static FluidStackRecipeIngredient from(Fluid fluid, int amount) {
        return FluidStackRecipeIngredient.from(new FluidStack(fluid, amount));
    }

    public static FluidStackRecipeIngredient from(FluidStack stack) {
        return new Impl(stack);
    }

    public static FluidStackRecipeIngredient from(ITag<Fluid> tag, int amount) {
        return new TaggedImpl(tag, amount);
    }

    public static FluidStackRecipeIngredient from(FluidStackRecipeIngredient ... ingredients) {
        return new CompositeImpl(ingredients);
    }

    public static FluidStackRecipeIngredient from(PacketBuffer buffer) {
        byte type = buffer.readByte();
        switch (type) {
            case 1: {
                return new Impl(FluidStack.readFromPacket((PacketBuffer)buffer));
            }
            case 2: {
                FluidStackRecipeIngredient[] ingredients = new FluidStackRecipeIngredient[buffer.func_150792_a()];
                for (int idx = 0; idx < ingredients.length; ++idx) {
                    ingredients[idx] = new Impl(FluidStack.readFromPacket((PacketBuffer)buffer));
                }
                return new CompositeImpl(ingredients);
            }
            case 3: {
                return new TaggedImpl((ITag<Fluid>)FluidTags.func_206956_a((String)buffer.func_192575_l().toString()), buffer.func_150792_a());
            }
        }
        throw new IllegalArgumentException("Invalid fluid ingredient data from then network");
    }

    public static FluidStackRecipeIngredient from(JsonElement jsonElement) {
        if (jsonElement.isJsonNull()) {
            throw new JsonSyntaxException("A fluid ingredient entry cannot be null");
        }
        if (jsonElement.isJsonArray()) {
            JsonArray json = jsonElement.getAsJsonArray();
            int size = json.size();
            switch (size) {
                case 0: {
                    throw new JsonSyntaxException("No ingredients found, at least one is required");
                }
                case 1: {
                    return FluidStackRecipeIngredient.from(json.get(0));
                }
            }
            return FluidStackRecipeIngredient.from((FluidStackRecipeIngredient[])Streams.stream((Iterable)json).map(FluidStackRecipeIngredient::from).toArray(FluidStackRecipeIngredient[]::new));
        }
        if (jsonElement.isJsonObject()) {
            JsonObject json = jsonElement.getAsJsonObject();
            if (json.has("fluid") && json.has("tag")) {
                throw new JsonParseException("A fluid ingredient entry must be either a Tag or a Fluid, but cannot be both");
            }
            if (json.has("fluid")) {
                return FluidStackRecipeIngredient.from(FluidHelper.stackFrom(json.get("fluid")));
            }
            if (json.has("tag")) {
                int amount = JSONHelper.jsonGetInt(json, "count", 0);
                if (amount < 1) {
                    throw new JsonSyntaxException("The amount entry of a fluid ingredient must be a number greater than zero");
                }
                ResourceLocation tagId = JSONHelper.jsonGetResourceLocation(json, "tag");
                ITag tag = TagCollectionManager.func_242178_a().func_241837_c().func_199910_a(tagId);
                if (null == tag) {
                    throw new JsonSyntaxException("Unknown fluid ingredient Tag: " + tagId);
                }
                return FluidStackRecipeIngredient.from((ITag<Fluid>)tag, amount);
            }
        }
        throw new JsonSyntaxException("Expected fluid ingredient entry to be object or array of objects");
    }

    static class TaggedImpl
    extends FluidStackRecipeIngredient {
        private final ITag<Fluid> _tag;
        private final int _amount;
        private List<FluidStack> _cachedMatchingElements;

        @Override
        public boolean isCompatible(FluidStack stack) {
            return Objects.requireNonNull(stack).getFluid().func_207185_a(this._tag);
        }

        @Override
        public FluidStack getMatchFrom(FluidStack stack) {
            return this.test(stack) ? new FluidStack(stack, this._amount) : FluidStack.EMPTY;
        }

        @Override
        public long getAmount(FluidStack stack) {
            return this.isCompatible(stack) ? (long)this._amount : 0L;
        }

        @Override
        public List<FluidStack> getMatchingElements() {
            if (null == this._cachedMatchingElements) {
                this._cachedMatchingElements = (List)TagsHelper.FLUIDS.getMatchingElements(this._tag).stream().map(fluid -> new FluidStack(fluid, this._amount)).collect(ImmutableList.toImmutableList());
            }
            return this._cachedMatchingElements;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean test(FluidStack stack) {
            return this.isCompatible(stack) && stack.getAmount() >= this._amount;
        }

        @Override
        public void serializeTo(PacketBuffer buffer) {
            buffer.writeByte(3);
            buffer.func_192572_a(TagCollectionManager.func_242178_a().func_241837_c().func_232975_b_(this._tag));
            buffer.func_150787_b(this._amount);
        }

        @Override
        public JsonElement serializeTo() {
            JsonObject json = new JsonObject();
            JSONHelper.jsonSetResourceLocation(json, "tag", TagCollectionManager.func_242178_a().func_241837_c().func_232975_b_(this._tag));
            JSONHelper.jsonSetInt(json, "count", this._amount);
            return json;
        }

        public String toString() {
            return this._amount + 32 + this._tag.toString();
        }

        protected TaggedImpl(ITag<Fluid> tag, int amount) {
            this._tag = tag;
            this._amount = amount;
        }
    }

    static class CompositeImpl
    extends FluidStackRecipeIngredient {
        private final List<FluidStackRecipeIngredient> _ingredients;
        private List<FluidStack> _cachedMatchingElements;

        @Override
        public boolean isCompatible(FluidStack stack) {
            return this._ingredients.stream().anyMatch(ingredient -> ingredient.isCompatible(stack));
        }

        @Override
        public FluidStack getMatchFrom(FluidStack stack) {
            return this._ingredients.stream().map(ingredient -> ingredient.getMatchFrom(stack)).filter(match -> !match.isEmpty()).findAny().orElse(FluidStack.EMPTY);
        }

        @Override
        public long getAmount(FluidStack stack) {
            return this._ingredients.stream().mapToLong(ingredient -> ingredient.getAmount(stack)).filter(amount -> amount > 0L).findAny().orElse(0L);
        }

        @Override
        public List<FluidStack> getMatchingElements() {
            if (null == this._cachedMatchingElements) {
                this._cachedMatchingElements = (List)this._ingredients.stream().flatMap(ingredient -> ingredient.getMatchingElements().stream()).collect(ImmutableList.toImmutableList());
            }
            return this._cachedMatchingElements;
        }

        @Override
        public boolean isEmpty() {
            return this._ingredients.stream().anyMatch(IRecipeIngredient::isEmpty);
        }

        @Override
        public boolean test(FluidStack stack) {
            return this._ingredients.stream().anyMatch(ingredient -> ingredient.test(stack));
        }

        @Override
        public void serializeTo(PacketBuffer buffer) {
            buffer.writeByte(2);
            buffer.func_150787_b(this._ingredients.size());
            this._ingredients.forEach(ingredient -> ingredient.serializeTo(buffer));
        }

        @Override
        public JsonElement serializeTo() {
            JsonArray json = new JsonArray();
            this._ingredients.forEach(ingredient -> json.add(ingredient.serializeTo()));
            return json;
        }

        public String toString() {
            return this._ingredients.stream().map(Object::toString).collect(StringBuilder::new, StringBuilder::append, StringBuilder::append).toString();
        }

        protected CompositeImpl(FluidStackRecipeIngredient[] ingredients) {
            this._ingredients = Lists.newArrayList((Object[])ingredients);
        }
    }

    static class Impl
    extends FluidStackRecipeIngredient {
        private final FluidStack _ingredient;
        private List<FluidStack> _cachedMatchingElements;

        @Override
        public boolean isCompatible(FluidStack stack) {
            return Objects.requireNonNull(stack).isFluidEqual(this._ingredient);
        }

        @Override
        public FluidStack getMatchFrom(FluidStack stack) {
            return this.test(stack) ? this._ingredient : FluidStack.EMPTY;
        }

        @Override
        public long getAmount(FluidStack stack) {
            return this.isCompatible(stack) ? (long)this._ingredient.getAmount() : 0L;
        }

        @Override
        public List<FluidStack> getMatchingElements() {
            if (null == this._cachedMatchingElements) {
                this._cachedMatchingElements = ObjectLists.singleton((Object)this._ingredient);
            }
            return this._cachedMatchingElements;
        }

        @Override
        public boolean isEmpty() {
            return this._ingredient.isEmpty();
        }

        @Override
        public void serializeTo(PacketBuffer buffer) {
            buffer.writeByte(1);
            this._ingredient.writeToPacket(buffer);
        }

        @Override
        public JsonElement serializeTo() {
            JsonObject json = new JsonObject();
            json.add("fluid", FluidHelper.stackToJSON(this._ingredient));
            return json;
        }

        @Override
        public boolean test(FluidStack stack) {
            return this.isCompatible(stack) && stack.getAmount() >= this._ingredient.getAmount();
        }

        public String toString() {
            return FluidHelper.toStringHelper(this._ingredient);
        }

        protected Impl(FluidStack ingredient) {
            this._ingredient = ingredient;
        }
    }
}

