/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.world;

import com.google.common.collect.Sets;
import it.zerono.mods.zerocore.lib.data.AreaShape;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;

public class ChunkPosDistance
extends ChunkPos {
    public final float distance;

    public ChunkPosDistance(int x, int z, float distance) {
        super(x, z);
        this.distance = distance;
    }

    public ChunkPosDistance(BlockPos pos, float distance) {
        super(pos);
        this.distance = distance;
    }

    public static Set<ChunkPosDistance> getChunksInRange(BlockPos startingPoint, AreaShape area, int radiusX, int radiusZ) {
        return ChunkPosDistance.getChunksInRange(startingPoint.func_177958_n() >> 4, startingPoint.func_177952_p() >> 4, area, radiusX, radiusZ);
    }

    public static Set<ChunkPosDistance> getChunksInRange(int startingChunkX, int startingChunkZ, AreaShape area, int radiusX, int radiusZ) {
        HashSet chunks = Sets.newHashSet();
        switch (area) {
            case LineEastWest: {
                chunks.add(new ChunkPosDistance(startingChunkX, startingChunkZ, 0.0f));
                for (int distance = 1; distance <= radiusX; ++distance) {
                    chunks.add(new ChunkPosDistance(startingChunkX - distance, startingChunkZ, distance));
                    chunks.add(new ChunkPosDistance(startingChunkX + distance, startingChunkZ, distance));
                }
                break;
            }
            case LineUpDown: {
                chunks.add(new ChunkPosDistance(startingChunkX, startingChunkZ, 0.0f));
                break;
            }
            case LineSouthNorth: {
                chunks.add(new ChunkPosDistance(startingChunkX, startingChunkZ, 0.0f));
                for (int distance = 1; distance <= radiusZ; ++distance) {
                    chunks.add(new ChunkPosDistance(startingChunkX, startingChunkZ - distance, distance));
                    chunks.add(new ChunkPosDistance(startingChunkX, startingChunkZ + distance, distance));
                }
                break;
            }
            case Square: 
            case Rectangle: {
                int rz = AreaShape.Rectangle == area ? radiusZ : radiusX;
                for (int z = startingChunkZ - rz; z <= startingChunkZ + rz; ++z) {
                    for (int x = startingChunkX - radiusX; x <= startingChunkX + radiusX; ++x) {
                        chunks.add(new ChunkPosDistance(x, z, (float)Math.sqrt(x * x + z * z)));
                    }
                }
                break;
            }
            case Circle: {
                for (int x = startingChunkX - radiusX; x <= startingChunkX + radiusX; ++x) {
                    for (int z = startingChunkZ - radiusX; z <= startingChunkZ + radiusX; ++z) {
                        int deltaX = x - startingChunkX;
                        int deltaZ = z - startingChunkZ;
                        double distance = Math.sqrt(deltaX * deltaX + deltaZ * deltaZ);
                        if (!(distance < (double)radiusX)) continue;
                        chunks.add(new ChunkPosDistance(x, z, (float)distance));
                    }
                }
                break;
            }
            case Ellipse: {
                for (int x = startingChunkX - radiusX; x <= startingChunkX + radiusX; ++x) {
                    for (int z = startingChunkZ - radiusZ; z <= startingChunkZ + radiusZ; ++z) {
                        if (x * x / (radiusX * radiusX) + z * z / (radiusZ * radiusZ) > 1) continue;
                        int deltaX = x - startingChunkX;
                        int deltaZ = z - startingChunkZ;
                        double distance = Math.sqrt(deltaX * deltaX + deltaZ * deltaZ);
                        chunks.add(new ChunkPosDistance(x, z, (float)distance));
                    }
                }
                break;
            }
        }
        return chunks;
    }
}

