/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.world;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.zerono.mods.zerocore.internal.Log;
import it.zerono.mods.zerocore.internal.gamecontent.Content;
import it.zerono.mods.zerocore.lib.block.ModBlock;
import it.zerono.mods.zerocore.lib.world.AbstractWorldGenFeaturesMap;
import it.zerono.mods.zerocore.lib.world.WorldGenManager;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.function.BooleanSupplier;
import java.util.function.IntSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.template.RuleTest;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.server.FMLServerStoppedEvent;
import org.apache.commons.lang3.tuple.Pair;

public class WorldReGenHandler
extends AbstractWorldGenFeaturesMap<Biome> {
    private static final long MAX_CHUNKS_PROCESS_TIME = 16000000L;
    private final BooleanSupplier _enabled;
    private final String _worldGenVersionTagName;
    private final IntSupplier _worldGenCurrentVersion;
    private Map<ResourceLocation, Queue<ChunkPos>> _chunksToRegen;

    public WorldReGenHandler(String worldGenVersionTagName, IntSupplier worldGenCurrentVersionSupplier, BooleanSupplier enabledCheck) {
        this._enabled = enabledCheck;
        this._worldGenVersionTagName = worldGenVersionTagName;
        this._worldGenCurrentVersion = worldGenCurrentVersionSupplier;
        IEventBus bus = MinecraftForge.EVENT_BUS;
        bus.addListener(this::onChunkDataSave);
        bus.addListener(this::onChunkDataLoad);
        bus.addListener(this::onServerStopped);
        bus.addListener(this::onWorldTick);
    }

    public static Predicate<Biome> matchAll() {
        return biome -> true;
    }

    public static Predicate<Biome> matchOnly(ResourceLocation biomeId) {
        return biome -> biome.getRegistryName().equals((Object)biomeId);
    }

    public static Predicate<Biome> anyExcept(ResourceLocation biomeId) {
        return biome -> !biome.getRegistryName().equals((Object)biomeId);
    }

    public static Predicate<Biome> onlyNether() {
        return biome -> Biome.Category.NETHER == biome.func_201856_r();
    }

    public static Predicate<Biome> exceptNether() {
        return biome -> Biome.Category.NETHER != biome.func_201856_r();
    }

    public static Predicate<Biome> onlyTheEnd() {
        return biome -> Biome.Category.THEEND == biome.func_201856_r();
    }

    public static Predicate<Biome> exceptTheEnd() {
        return biome -> Biome.Category.THEEND != biome.func_201856_r();
    }

    public static ConfiguredFeature<?, ?> oreFeature(Supplier<ModBlock> oreBlock, RuleTest matchRule, int clustersAmount, int oresPerCluster, int placementBottomOffset, int placementTopOffset, int placementMaximum) {
        return WorldReGenHandler.oreFeature(Content.FEATURE_ORE_REGEN, oreBlock, matchRule, clustersAmount, oresPerCluster, placementBottomOffset, placementTopOffset, placementMaximum);
    }

    public static Pair<ConfiguredFeature<?, ?>, ConfiguredFeature<?, ?>> oreGenAndRegenFeatures(Supplier<ModBlock> oreBlock, RuleTest matchRule, int clustersAmount, int oresPerCluster, int placementBottomOffset, int placementTopOffset, int placementMaximum) {
        ConfiguredFeature<?, ?> gen = WorldGenManager.oreFeature(oreBlock, matchRule, clustersAmount, oresPerCluster, placementBottomOffset, placementTopOffset, placementMaximum);
        ConfiguredFeature<?, ?> regen = WorldReGenHandler.oreFeature(oreBlock, matchRule, clustersAmount, oresPerCluster, placementBottomOffset, placementTopOffset, placementMaximum);
        return Pair.of(gen, regen);
    }

    public void addGenAndRegenOre(Pair<ConfiguredFeature<?, ?>, ConfiguredFeature<?, ?>> suppliers, Predicate<BiomeLoadingEvent> genBiomeMatcher, Predicate<Biome> reGenBiomeMatcher) {
        WorldGenManager.INSTANCE.addOre(genBiomeMatcher, (ConfiguredFeature)suppliers.getLeft());
        this.addOre(reGenBiomeMatcher, (ConfiguredFeature)suppliers.getRight());
    }

    private boolean enabled() {
        return this._enabled.getAsBoolean();
    }

    private String getWorldGenVersionTagName() {
        return "zcwg_" + this._worldGenVersionTagName;
    }

    private synchronized void onChunkDataLoad(ChunkDataEvent.Load event) {
        IWorld world = event.getWorld();
        if (this.enabled() && world instanceof World && !world.func_201670_d() && (!event.getData().func_74764_b(this.getWorldGenVersionTagName()) || event.getData().func_74762_e(this.getWorldGenVersionTagName()) < this._worldGenCurrentVersion.getAsInt())) {
            this.addChunkToRegen((RegistryKey<World>)((World)world).func_234923_W_(), event.getChunk().func_76632_l());
        }
    }

    private void onChunkDataSave(ChunkDataEvent.Save event) {
        if (this.enabled() && null != event.getWorld() && !event.getWorld().func_201670_d()) {
            event.getData().func_74768_a(this.getWorldGenVersionTagName(), this._worldGenCurrentVersion.getAsInt());
        }
    }

    private void onServerStopped(FMLServerStoppedEvent event) {
        if (null != this._chunksToRegen) {
            this._chunksToRegen.clear();
        }
    }

    private void onWorldTick(TickEvent.WorldTickEvent event) {
        if (this.enabled() && event.side.isServer() && TickEvent.Phase.END == event.phase) {
            this.processChunks((ServerWorld)event.world);
        }
    }

    private void addChunkToRegen(RegistryKey<World> dimension, ChunkPos chunkPosition) {
        Queue positions;
        if (null == this._chunksToRegen) {
            this._chunksToRegen = new Object2ObjectArrayMap();
        }
        if (!(positions = this._chunksToRegen.computeIfAbsent(dimension.func_240901_a_(), k -> new LinkedList())).contains(chunkPosition)) {
            positions.add(chunkPosition);
        }
    }

    private void processChunks(ServerWorld world) {
        ResourceLocation dimensionId;
        if (!world.field_72995_K && null != this._chunksToRegen && this._chunksToRegen.containsKey(dimensionId = world.func_234923_W_().func_240901_a_())) {
            ChunkPos nextChunk;
            Queue<ChunkPos> chunksToGen = this._chunksToRegen.get(dimensionId);
            long startTime = System.nanoTime();
            while (System.nanoTime() - startTime < 16000000L && !chunksToGen.isEmpty() && null != (nextChunk = chunksToGen.poll())) {
                Random random = new Random(world.func_72905_C());
                long xSeed = random.nextLong() >> 3;
                long zSeed = random.nextLong() >> 3;
                random.setSeed(xSeed * (long)nextChunk.field_77276_a + zSeed * (long)nextChunk.field_77275_b ^ world.func_72905_C());
                this.regenerateChunk(world, random, nextChunk.field_77276_a, nextChunk.field_77275_b);
            }
            if (chunksToGen.isEmpty()) {
                this._chunksToRegen.remove(dimensionId);
            }
        }
    }

    private void regenerateChunk(ServerWorld world, Random random, int chunkX, int chunkZ) {
        if (!world.func_217354_b(chunkX, chunkZ)) {
            return;
        }
        ChunkGenerator chunkGenerator = world.func_72863_F().func_201711_g();
        BlockPos position = new BlockPos(chunkX * 16, 0, chunkZ * 16);
        Biome biome = world.func_226691_t_(position);
        for (GenerationStage.Decoration stage : this._entries.keySet()) {
            boolean processed = false;
            for (Pair pair : (List)this._entries.get(stage)) {
                if (!((Predicate)pair.getKey()).test(biome)) continue;
                processed |= ((ConfiguredFeature)pair.getValue()).func_242765_a((ISeedReader)world, chunkGenerator, random, position);
            }
            if (!processed) continue;
            Log.LOGGER.info(Log.CORE, "Retro-gen run on chunk {}, {}", (Object)chunkX, (Object)chunkZ);
        }
    }
}

